/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.imagej.ops.Namespace;
import net.imagej.ops.Op;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpMatchingService;
import org.scijava.AbstractContextual;
import org.scijava.Context;

public class CustomOpEnvironment
extends AbstractContextual
implements OpEnvironment {
    private final OpEnvironment parent;
    private final OpIndex index;

    public CustomOpEnvironment(Context context) {
        this(context, null, null);
    }

    public CustomOpEnvironment(OpEnvironment parent) {
        this(parent, null);
    }

    public CustomOpEnvironment(OpEnvironment parent, Collection<? extends OpInfo> infos) {
        this(parent.getContext(), parent, infos);
    }

    private CustomOpEnvironment(Context context, OpEnvironment parent, Collection<? extends OpInfo> infos) {
        this.setContext(context);
        this.parent = parent;
        this.index = new OpIndex();
        if (parent != null) {
            this.index.addOps(parent.infos());
        }
        this.index.addOps(infos);
    }

    @Override
    public OpMatchingService matcher() {
        return this.parent().matcher();
    }

    @Override
    public OpInfo info(Class<? extends Op> type) {
        return (OpInfo)this.index.get(type.getName());
    }

    @Override
    public Collection<OpInfo> infos() {
        return this.index.values();
    }

    @Override
    public OpEnvironment parent() {
        return this.parent;
    }

    @Override
    public <NS extends Namespace> NS namespace(Class<NS> nsClass) {
        return this.parent().namespace(nsClass);
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.parent.setMaxThreads(maxThreads);
    }

    @Override
    public int getMaxThreads() {
        return this.parent.getMaxThreads();
    }

    private static class OpIndex
    extends HashMap<String, OpInfo> {
        private OpIndex() {
        }

        public void addOps(Collection<? extends OpInfo> infos) {
            if (infos == null) {
                return;
            }
            for (OpInfo opInfo : infos) {
                this.put(opInfo.cInfo().getDelegateClassName(), opInfo);
            }
        }

        @Override
        public Collection<OpInfo> values() {
            ArrayList<OpInfo> infos = new ArrayList<OpInfo>();
            infos.addAll(super.values());
            Collections.sort(infos);
            return infos;
        }
    }
}

