/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Lists;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

public class AbstractKeysFunction
implements Function {
    private final boolean sortKeys;
    private final String name;

    public AbstractKeysFunction(String name, boolean sortKeys) {
        this.name = name;
        this.sortKeys = sortKeys;
    }

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType(this.name, in, JsonNodeType.OBJECT, JsonNodeType.ARRAY);
        if (in.isObject()) {
            List<String> keys = Lists.newArrayList(in.fieldNames());
            if (this.sortKeys) {
                Collections.sort(keys);
            }
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (String key : keys) {
                result.add((JsonNode)new TextNode(key));
            }
            output.emit((JsonNode)result, null);
        } else if (in.isArray()) {
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (int i = 0; i < in.size(); ++i) {
                result.add((JsonNode)new IntNode(i));
            }
            output.emit((JsonNode)result, null);
        } else {
            throw new IllegalStateException();
        }
    }
}

