/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.binaryop.assignment;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;
import net.thisptr.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import net.thisptr.jackson.jq.path.Path;
import net.thisptr.jackson.jq.path.RootPath;

public class ComplexAssignment
extends BinaryOperatorExpression {
    private BinaryOperator operator;

    public ComplexAssignment(Expression lhs, Expression rhs, BinaryOperator operator) {
        super(lhs, rhs, operator.image() + "=");
        this.operator = operator;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.rhs.apply(scope, in, rval -> {
            ArrayList lpaths = new ArrayList();
            this.lhs.apply(scope, in, RootPath.getInstance(), (lval, lpath) -> {
                if (lpath == null && in.isValueNode() && JsonNodeComparator.getInstance().compare(in, lval) == 0) {
                    lpath = RootPath.getInstance();
                }
                if (lpath == null) {
                    throw new JsonQueryException("Invalid path expression with result %s", JsonNodeUtils.toString(lval));
                }
                lpaths.add(lpath);
            }, true);
            JsonNode out = in;
            for (Path lpath2 : lpaths) {
                out = lpath2.mutate(out, lval -> this.operator.apply(scope.getObjectMapper(), lval, rval));
            }
            output.emit(out, null);
        });
    }
}

