/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

public class MergeFileAction
extends AbstractTMAction {
    public static final String NAME = "Merge a TrackMate file";
    public static final String KEY = "MERGE_OTHER_FILE";
    public static final String INFO_TEXT = "<html>Merge the current model with the data from another <br>file, specified by the user. This is useful <i>e.g.</i> <br>if two operators have been annotating the same datasets <br>and want to merge their work in a single file.<p>Only the spots belonging to visible tracks are imported <br>from the target file, which makes this action non-entirely <br>symmetrical.  Numerical features are re-calculated using <br>the current settings. There is no check that the imported <br>data was generated on the raw source.</html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        File tmpFile;
        File file = TMUtils.proposeTrackMateSaveFile(trackmate.getSettings(), this.logger);
        if (null == file) {
            File folder = new File(System.getProperty("user.dir")).getParentFile().getParentFile();
            file = new File(folder.getPath() + File.separator + "TrackMateData.xml");
        }
        if (null == (tmpFile = IOUtils.askForFileForLoading(file, "Merge a TrackMate XML file", parent, this.logger))) {
            return;
        }
        file = tmpFile;
        TmXmlReader reader = new TmXmlReader(file);
        if (!reader.isReadingOk()) {
            this.logger.error(reader.getErrorMessage());
            this.logger.error("Aborting.\n");
            return;
        }
        Model modelToMerge = reader.getModel();
        Model model = trackmate.getModel();
        int nNewTracks = modelToMerge.getTrackModel().nTracks(true);
        int progress = 0;
        model.beginUpdate();
        int nNewSpots = 0;
        try {
            for (int id : modelToMerge.getTrackModel().trackIDs(true)) {
                Set<Spot> spots = modelToMerge.getTrackModel().trackSpots(id);
                HashMap<Spot, Spot> mapOldToNew = new HashMap<Spot, Spot>(spots.size());
                Spot newSpot = null;
                for (Spot spot : spots) {
                    newSpot = new Spot(spot);
                    for (String feature : spot.getFeatures().keySet()) {
                        newSpot.putFeature(feature, spot.getFeature(feature));
                    }
                    mapOldToNew.put(spot, newSpot);
                    model.addSpotTo(newSpot, spot.getFeature("FRAME").intValue());
                    ++nNewSpots;
                }
                Set<DefaultWeightedEdge> edges = modelToMerge.getTrackModel().trackEdges(id);
                for (DefaultWeightedEdge edge : edges) {
                    Spot oldSource = modelToMerge.getTrackModel().getEdgeSource(edge);
                    Spot oldTarget = modelToMerge.getTrackModel().getEdgeTarget(edge);
                    Spot newSource = (Spot)mapOldToNew.get(oldSource);
                    Spot newTarget = (Spot)mapOldToNew.get(oldTarget);
                    double weight = modelToMerge.getTrackModel().getEdgeWeight(edge);
                    model.addEdge(newSource, newTarget, weight);
                }
                String string = modelToMerge.getTrackModel().name(id);
                int newId = model.getTrackModel().trackIDOf(newSpot);
                model.getTrackModel().setName(newId, string);
                this.logger.setProgress((double)(++progress) / (double)nNewTracks);
            }
        }
        finally {
            model.endUpdate();
            this.logger.setProgress(0.0);
            this.logger.log("Imported " + nNewTracks + " tracks made of " + nNewSpots + " spots.\n");
        }
    }

    @Plugin(type=TrackMateActionFactory.class, visible=true)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return MergeFileAction.INFO_TEXT;
        }

        @Override
        public String getName() {
            return MergeFileAction.NAME;
        }

        @Override
        public String getKey() {
            return MergeFileAction.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.MERGE_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new MergeFileAction();
        }
    }
}

