/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LogDetector<T extends RealType<T> & NativeType<T>>
implements SpotDetector<T>,
MultiThreaded {
    private static final String BASE_ERROR_MESSAGE = "LogDetector: ";
    protected RandomAccessible<T> img;
    protected double radius;
    protected double threshold;
    protected boolean doSubPixelLocalization;
    protected boolean doMedianFilter;
    protected String baseErrorMessage;
    protected String errorMessage;
    protected List<Spot> spots = new ArrayList<Spot>();
    protected long processingTime;
    protected int numThreads;
    protected final Interval interval;
    protected final double[] calibration;

    public LogDetector(RandomAccessible<T> img, Interval interval, double[] calibration, double radius, double threshold, boolean doSubPixelLocalization, boolean doMedianFilter) {
        this.img = img;
        this.interval = DetectionUtils.squeeze(interval);
        this.calibration = calibration;
        this.radius = radius;
        this.threshold = threshold;
        this.doSubPixelLocalization = doSubPixelLocalization;
        this.doMedianFilter = doMedianFilter;
        this.baseErrorMessage = BASE_ERROR_MESSAGE;
        this.setNumThreads();
    }

    public boolean checkInput() {
        if (null == this.img) {
            this.errorMessage = this.baseErrorMessage + "Image is null.";
            return false;
        }
        if (this.img.numDimensions() > 3) {
            this.errorMessage = this.baseErrorMessage + "Image must be 1D, 2D or 3D, got " + this.img.numDimensions() + "D.";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        ImgFactory factory = Util.getArrayOrCellImgFactory((Dimensions)this.interval, (NativeType)new FloatType());
        FinalInterval floatImg = DetectionUtils.copyToFloatImg(this.img, this.interval, (ImgFactory<FloatType>)factory);
        if (this.doMedianFilter && null == (floatImg = DetectionUtils.applyMedianFilter(floatImg))) {
            this.errorMessage = "LogDetector: Failed to apply median filter.";
            return false;
        }
        int ndims = this.interval.numDimensions();
        for (int d = 0; d < this.interval.numDimensions(); ++d) {
            if (this.interval.dimension(d) > 1L) continue;
            --ndims;
        }
        Img<FloatType> kernel = DetectionUtils.createLoGKernel(this.radius, ndims, this.calibration);
        FFTConvolution fftconv = new FFTConvolution(floatImg, kernel);
        FinalInterval fftinterval = floatImg;
        for (int d = 0; d < kernel.numDimensions(); ++d) {
            fftinterval = Intervals.expand(fftinterval, (long)kernel.dimension(d), (int)d);
        }
        ImgFactory imgFactory = Util.getArrayOrCellImgFactory(fftinterval, (NativeType)new ComplexFloatType());
        fftconv.setFFTImgFactory(imgFactory);
        ExecutorService service = Threads.newFixedThreadPool(this.numThreads);
        fftconv.setExecutorService(service);
        fftconv.convolve();
        service.shutdown();
        long[] minopposite = new long[this.interval.numDimensions()];
        this.interval.min(minopposite);
        IntervalView to = Views.translate((RandomAccessibleInterval)floatImg, (long[])minopposite);
        this.spots = DetectionUtils.findLocalMaxima(to, this.threshold, this.calibration, this.radius, this.doSubPixelLocalization, this.numThreads);
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public List<Spot> getResult() {
        return this.spots;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

