/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.gui.Fonts;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

public class CategoryJComboBox<K, V>
extends JComboBox<Object> {
    private static final long serialVersionUID = 1L;
    protected static final String INDENT = "  ";
    private final HashSet<Integer> categoryIndexSet = new HashSet();
    private boolean isCategoryIndex = false;
    private Map<V, String> itemNames;
    private final HashMap<V, K> invertMap = new HashMap();
    private Map<K, String> categoryNames;

    public CategoryJComboBox(Map<K, Collection<V>> items, Map<V, String> itemNames, Map<K, String> categoryNames) {
        this.setItems(items, itemNames, categoryNames);
    }

    public void setItems(Map<K, Collection<V>> items, Map<V, String> itemNames, Map<K, String> categoryNames) {
        this.invertMap.clear();
        this.categoryIndexSet.clear();
        this.itemNames = itemNames;
        this.categoryNames = categoryNames;
        V previous = this.getSelectedItem();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        for (K category : items.keySet()) {
            model.addElement(category);
            this.categoryIndexSet.add(model.getSize() - 1);
            Collection<V> categoryItems = items.get(category);
            for (V item : categoryItems) {
                model.addElement(item);
                this.invertMap.put(item, category);
            }
        }
        this.setModel(model);
        this.init();
        if (previous != null) {
            this.setSelectedItem(previous);
        } else if (items.size() > 0) {
            this.setSelectedItem(items.get(items.keySet().iterator().next()).iterator().next());
        }
    }

    public K getSelectedCategory() {
        V obj = this.getSelectedItem();
        return this.invertMap.get(obj);
    }

    public void setDisableIndex(HashSet<Integer> set) {
        this.categoryIndexSet.clear();
        for (Integer i : set) {
            this.categoryIndexSet.add(i);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (!v && this.isCategoryIndex) {
            this.isCategoryIndex = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    @Override
    public V getSelectedItem() {
        return (V)super.getSelectedItem();
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.categoryIndexSet.contains(index)) {
            this.isCategoryIndex = true;
        } else {
            super.setSelectedIndex(index);
        }
    }

    private void init() {
        this.setFont(Fonts.SMALL_FONT);
        final ListCellRenderer r = this.getRenderer();
        this.setRenderer(new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c;
                if (CategoryJComboBox.this.categoryIndexSet.contains(index)) {
                    c = (JLabel)r.getListCellRendererComponent(list, value, index, false, false);
                    c.setEnabled(false);
                    c.setFont(Fonts.SMALL_FONT.deriveFont(1));
                    c.setText(CategoryJComboBox.this.categoryNames.get(value));
                } else {
                    c = (JLabel)r.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    c.setEnabled(true);
                    c.setFont(Fonts.SMALL_FONT);
                    c.setText(CategoryJComboBox.INDENT + CategoryJComboBox.this.itemNames.get(value));
                }
                return c;
            }
        });
        AbstractAction up = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int si = CategoryJComboBox.this.getSelectedIndex();
                for (int i = si - 1; i >= 0; --i) {
                    if (CategoryJComboBox.this.categoryIndexSet.contains(i)) continue;
                    CategoryJComboBox.this.setSelectedIndex(i);
                    break;
                }
            }
        };
        AbstractAction down = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int si = CategoryJComboBox.this.getSelectedIndex();
                for (int i = si + 1; i < CategoryJComboBox.this.getModel().getSize(); ++i) {
                    if (CategoryJComboBox.this.categoryIndexSet.contains(i)) continue;
                    CategoryJComboBox.this.setSelectedIndex(i);
                    break;
                }
            }
        };
        ActionMap am = this.getActionMap();
        am.put("selectPrevious", up);
        am.put("selectNext", down);
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke(38, 0), "selectPrevious");
        im.put(KeyStroke.getKeyStroke(224, 0), "selectPrevious");
        im.put(KeyStroke.getKeyStroke(40, 0), "selectNext");
        im.put(KeyStroke.getKeyStroke(225, 0), "selectNext");
    }

    public static void main(String[] args) {
        ArrayList<String> fruits = new ArrayList<String>(5);
        fruits.add("Apple");
        fruits.add("Pear");
        fruits.add("Orange");
        fruits.add("Strawberry");
        ArrayList<String> cars = new ArrayList<String>(3);
        cars.add("Peugeot");
        cars.add("Ferrari");
        cars.add("Ford");
        ArrayList<String> computers = new ArrayList<String>(2);
        computers.add("PC");
        computers.add("Mac");
        LinkedHashMap<String, ArrayList<String>> items = new LinkedHashMap<String, ArrayList<String>>(3);
        items.put("Fruits", fruits);
        items.put("Cars", cars);
        items.put("Computers", computers);
        HashMap<String, String> itemNames = new HashMap<String, String>();
        for (Object key : items.keySet()) {
            for (String string : (Collection)items.get(key)) {
                itemNames.put(string, string);
            }
        }
        HashMap<String, String> categoryNames = new HashMap<String, String>();
        for (String key : items.keySet()) {
            categoryNames.put(key, key);
        }
        final CategoryJComboBox cb = new CategoryJComboBox(items, itemNames, categoryNames);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("Selected " + (String)cb.getSelectedItem() + " in category " + (String)cb.getSelectedCategory());
            }
        });
        JFrame frame = new JFrame();
        frame.getContentPane().add(cb);
        frame.setVisible(true);
    }
}

