/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Fonts;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class LogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DESCRIPTOR = "LogPanel";
    private final JTextPane textPane;
    private final JProgressBar progressBar;
    private final Logger logger;

    public LogPanel() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.setPreferredSize(new Dimension(270, 500));
        JPanel panelProgressBar = new JPanel();
        BorderLayout jPanelProgressBarLayout = new BorderLayout();
        panelProgressBar.setLayout(jPanelProgressBarLayout);
        this.add((Component)panelProgressBar, "North");
        panelProgressBar.setPreferredSize(new Dimension(270, 32));
        this.progressBar = new JProgressBar();
        panelProgressBar.add((Component)this.progressBar, "Center");
        this.progressBar.setPreferredSize(new Dimension(270, 20));
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(Fonts.SMALL_FONT);
        JScrollPane scrollPane = new JScrollPane();
        this.add(scrollPane);
        scrollPane.setPreferredSize(new Dimension(262, 136));
        this.textPane = new JTextPane();
        this.textPane.setEditable(true);
        this.textPane.setFont(Fonts.SMALL_FONT);
        scrollPane.setViewportView(this.textPane);
        this.textPane.setBackground(this.getBackground());
        this.logger = new LogPanelLogger();
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getTextContent() {
        return this.textPane.getText();
    }

    public void setTextContent(String log) {
        this.textPane.setText(log);
    }

    private class LogPanelLogger
    extends Logger {
        protected static final int MAX_N_CHARS = 10000;

        private LogPanelLogger() {
        }

        @Override
        public void error(String message) {
            this.log(message, Logger.ERROR_COLOR);
        }

        @Override
        public void log(final String message, final Color color) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int l;
                    StyleContext sc = StyleContext.getDefaultStyleContext();
                    AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
                    AbstractDocument doc = (AbstractDocument)((Object)LogPanel.this.textPane.getStyledDocument());
                    int len = doc.getLength();
                    if (len + (l = message.length()) > 10000) {
                        int delta = Math.max(0, Math.min(l - 1, len + l - 10000));
                        try {
                            if (len > 0) {
                                doc.remove(0, delta);
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                    LogPanel.this.textPane.setCaretPosition(doc.getLength());
                    LogPanel.this.textPane.setCharacterAttributes(aset, false);
                    LogPanel.this.textPane.replaceSelection(message);
                }
            });
        }

        @Override
        public void setStatus(final String status) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogPanel.this.progressBar.setString(status);
                }
            });
        }

        @Override
        public void setProgress(double val) {
            if (val < 0.0) {
                val = 0.0;
            }
            if (val > 1.0) {
                val = 1.0;
            }
            final int intVal = (int)(val * 100.0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogPanel.this.progressBar.setValue(intVal);
                }
            });
        }

        public String toString() {
            return LogPanel.this.getTextContent();
        }
    }
}

