/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.wizard.TransitionAnimator;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.util.PainterThread;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public class WizardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Font FONT = new Font("Arial", 0, 10);
    public static final Font BIG_FONT = new Font("Arial", 0, 14);
    public static final Font SMALL_FONT = FONT.deriveFont(8);
    private final CardLayout cardLayout;
    private final AnimatorPanel animatorPanel;
    final JPanel panelMain;
    final JButton btnSave;
    final JToggleButton btnLog;
    final JToggleButton btnDisplayConfig;
    final JButton btnPrevious;
    final JButton btnNext;
    final JButton btnCancel;
    final JButton btnResume;
    final JPanel panelButtons;

    public WizardPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.animatorPanel = new AnimatorPanel();
        this.panelButtons = new JPanel();
        this.panelButtons.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.add((Component)this.panelButtons, "South");
        this.panelButtons.setLayout(new BoxLayout(this.panelButtons, 0));
        this.btnSave = new JButton();
        this.panelButtons.add(this.btnSave);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        this.panelButtons.add(horizontalGlue_1);
        this.btnLog = new JToggleButton();
        this.panelButtons.add(this.btnLog);
        this.btnDisplayConfig = new JToggleButton();
        this.panelButtons.add(this.btnDisplayConfig);
        Component horizontalGlue = Box.createHorizontalGlue();
        this.panelButtons.add(horizontalGlue);
        this.btnPrevious = new JButton();
        this.panelButtons.add(this.btnPrevious);
        this.btnNext = new JButton();
        this.panelButtons.add(this.btnNext);
        this.btnCancel = new JButton();
        this.panelButtons.add(this.btnCancel);
        this.btnResume = new JButton();
        this.panelButtons.add(this.btnResume);
        this.panelMain = new JPanel();
        this.add((Component)this.panelMain, "Center");
        this.cardLayout = new CardLayout(0, 0);
        this.panelMain.setLayout(this.cardLayout);
    }

    public void display(WizardPanelDescriptor current) {
        this.panelMain.add(current.getPanelComponent(), current.getPanelDescriptorIdentifier());
        this.cardLayout.show(this.panelMain, current.getPanelDescriptorIdentifier());
    }

    public void transition(WizardPanelDescriptor to, WizardPanelDescriptor from, TransitionAnimator.Direction direction) {
        this.animatorPanel.start(from, to, direction);
    }

    private class AnimatorPanel
    extends JPanel
    implements PainterThread.Paintable {
        private static final long serialVersionUID = 1L;
        private static final long duration = 200L;
        private final JLabel label;
        private TransitionAnimator animator;
        private WizardPanelDescriptor to;
        private final PainterThread painterThread;

        public AnimatorPanel() {
            super(new GridLayout());
            this.label = new JLabel();
            this.add(this.label);
            this.painterThread = new PainterThread(this);
            this.painterThread.start();
            GuiUtils.addOnClosingEvent(this, () -> WizardPanel.this.animatorPanel.painterThread.interrupt());
        }

        public void start(WizardPanelDescriptor from, WizardPanelDescriptor to, TransitionAnimator.Direction direction) {
            this.to = to;
            this.animator = new TransitionAnimator(from.getPanelComponent(), to.getPanelComponent(), direction, 200L);
            this.label.setIcon(new ImageIcon(this.animator.getCurrent(System.currentTimeMillis())));
            WizardPanel.this.panelMain.add((Component)this, "transitionCard");
            WizardPanel.this.cardLayout.show(WizardPanel.this.panelMain, "transitionCard");
        }

        private void stop() {
            this.animator = null;
            WizardPanel.this.panelMain.remove(this);
            WizardPanel.this.panelMain.add(this.to.getPanelComponent(), this.to.getPanelDescriptorIdentifier());
            WizardPanel.this.cardLayout.show(WizardPanel.this.panelMain, this.to.getPanelDescriptorIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint() {
            AnimatorPanel animatorPanel = this;
            synchronized (animatorPanel) {
                if (this.animator != null) {
                    this.label.setIcon(new ImageIcon(this.animator.getCurrent(System.currentTimeMillis())));
                    if (this.animator.isComplete()) {
                        this.stop();
                    }
                    this.repaint();
                }
            }
        }

        @Override
        public void repaint() {
            if (null != this.painterThread) {
                this.painterThread.requestRepaint();
            }
        }
    }
}

