/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import view5d.TaggedCheck;
import view5d.TaggedChoice;
import view5d.TaggedDouble;
import view5d.TaggedText;

class AGenericDialog
extends Dialog
implements WindowListener,
ActionListener,
FocusListener,
ItemListener {
    static final long serialVersionUID = 1L;
    GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    int Components;
    int posS = 0;
    int posC = 0;
    int posN = 0;
    int posCh = 0;
    private int y;
    private Button cancel;
    private Button okay;
    boolean canceled = false;
    boolean firstNumericField = true;

    public AGenericDialog(String title) {
        this(title, new Frame());
    }

    public AGenericDialog(String title, Frame parent) {
        super(parent == null ? new Frame() : parent, title, true);
        this.setLayout(this.gridbag);
        this.addWindowListener(this);
    }

    public void showDialog() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        this.okay = new Button("  OK  ");
        this.okay.addActionListener(this);
        buttons.add(this.okay);
        buttons.add(this.cancel);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 2;
        this.c.insets = new Insets(15, 0, 0, 0);
        this.gridbag.setConstraints(buttons, this.c);
        this.add(buttons);
        this.pack();
        this.setVisible(true);
        this.toFront();
        this.repaint();
        this.update(this.getGraphics());
    }

    @Override
    public void repaint() {
        super.repaint();
        this.update(this.getGraphics());
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void addStringField(String label, String value) {
        TaggedText Comp = new TaggedText(label, label, value);
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.gridbag.setConstraints(Comp, this.c);
        this.add(Comp);
        ++this.Components;
    }

    public void addCheckbox(String label, boolean value) {
        TaggedCheck Comp = new TaggedCheck(label, label, value);
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.gridbag.setConstraints(Comp, this.c);
        this.add(Comp);
        ++this.Components;
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        TaggedChoice Comp = new TaggedChoice(label, label, items, defaultItem);
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints(Comp, this.c);
        this.add(Comp);
        ++this.Components;
    }

    public void addMessage(String text) {
        Component theLabel;
        String[] mysplit = text.split("\n");
        int lines = mysplit.length;
        if (lines > 1) {
            int columns = 0;
            for (int i = 0; i < lines; ++i) {
                if (mysplit[i].length() <= columns) continue;
                columns = mysplit[i].length();
            }
            TextArea myTextArea = new TextArea(text, lines, columns, 3);
            myTextArea.setEditable(false);
            theLabel = myTextArea;
        } else {
            theLabel = new Label(text);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(text.equals("") ? 0 : 10, 20, 0, 0);
        this.gridbag.setConstraints(theLabel, this.c);
        this.add(theLabel);
        ++this.Components;
        ++this.y;
    }

    public void addNumericField(String label, double value, int precision) {
        TaggedDouble Comp = new TaggedDouble(label, label, value);
        this.c.gridy = this.y++;
        this.c.anchor = 13;
        this.c.gridwidth = 3;
        this.c.gridx = 0;
        this.c.insets = this.firstNumericField ? new Insets(3, 0, 3, 0) : new Insets(0, 0, 3, 0);
        if (this.firstNumericField) {
            ((TextField)Comp.mycomp).selectAll();
        }
        this.firstNumericField = false;
        this.gridbag.setConstraints(Comp, this.c);
        this.add(Comp);
        ++this.Components;
    }

    public String getNextString() {
        int max = this.getComponentCount();
        while (this.posS < max) {
            TaggedText dummy = new TaggedText("", "", "");
            Component comp = this.getComponent(this.posS);
            if (dummy.getClass().isInstance(comp) && comp.getClass().isInstance(dummy)) {
                ++this.posS;
                return ((TaggedText)comp).getTextValue();
            }
            ++this.posS;
        }
        System.out.println("String component not found error!\n");
        return "";
    }

    public double getNextNumber() {
        int max = this.getComponentCount();
        while (this.posN < max) {
            TaggedDouble dummy = new TaggedDouble("", "", 0.0);
            Component comp = this.getComponent(this.posN);
            if (dummy.getClass().isInstance(comp) && comp.getClass().isInstance(dummy)) {
                ++this.posN;
                return ((TaggedDouble)comp).getDoubleValue();
            }
            ++this.posN;
        }
        System.out.println("Number component not found error!\n");
        return 0.0;
    }

    public boolean getNextBoolean() {
        int max = this.getComponentCount();
        while (this.posC < max) {
            TaggedCheck dummy = new TaggedCheck("", "", true);
            Component comp = this.getComponent(this.posC);
            if (dummy.getClass().isInstance(comp) && comp.getClass().isInstance(dummy)) {
                ++this.posC;
                return ((TaggedCheck)comp).getBoolValue();
            }
            ++this.posC;
        }
        System.out.println("Check component not found error!\n");
        return false;
    }

    public int getNextChoiceIndex() {
        int max = this.getComponentCount();
        while (this.posCh < max) {
            TaggedChoice dummy = new TaggedChoice("", "", null, "");
            Component comp = this.getComponent(this.posCh);
            if (dummy.getClass().isInstance(comp) && comp.getClass().isInstance(dummy)) {
                ++this.posCh;
                return ((TaggedChoice)comp).getChoiceValue();
            }
            ++this.posCh;
        }
        System.out.println("Check component not found error!\n");
        return 0;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
        System.out.println("Generic Dialog closing!\n");
        if (this.canceled) {
            System.out.println("canceled!\n");
        } else {
            System.out.println("okay!\n");
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.canceled = true;
        this.update(this.getGraphics());
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).selectAll();
        }
        this.update(this.getGraphics());
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).select(0, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.canceled = e.getSource() == this.cancel;
        this.setVisible(false);
    }
}

