/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJJacobi;
import bijnum.BIJmatrix;
import bijnum.BIJstats;
import ij.IJ;
import java.util.Date;

public class BIJpca {
    public float[][] eigenimages;
    public float[] eigenvalues;
    public float[][] eigenvectors;
    protected float[][] an;
    public float[][] a;
    public double totalVariance;

    public BIJpca() {
    }

    public BIJpca(float[][] eigenimages, float[][] eigenvectors) {
        this.eigenimages = eigenimages;
        this.eigenvectors = eigenvectors;
    }

    public float[][] compute(float[][] a) throws Exception {
        System.out.println("Computing pca...normalizing images");
        this.a = a;
        double avg = BIJstats.means(a);
        BIJmatrix.add(a, -avg);
        System.out.println("PCA uses " + a.length * a[0].length * 4 + " bytes (a).");
        System.out.println("Computing covariance matrix");
        float[][] cov = BIJstats.covariance(a, true);
        System.out.println("Computing pca...covariance matrix (" + cov.length * cov[0].length + "bytes) ok " + new Date().toString());
        BIJJacobi jacobi = new BIJJacobi(cov, true);
        System.out.println("PCA...computing eigenvectors ");
        jacobi.compute();
        cov = null;
        System.gc();
        System.out.println("Computing pca...eigenvector matrix ok " + new Date().toString());
        jacobi.sort();
        this.eigenvalues = BIJmatrix.copy(jacobi.eigenvalues);
        this.eigenvectors = BIJmatrix.copy(jacobi.eigenvectors);
        this.computeEigenimages();
        return this.eigenimages;
    }

    protected float[][] computeEigenimages() {
        System.out.println("PCA...computing eigenimages");
        this.eigenimages = BIJmatrix.mulT(this.a, this.eigenvectors, true);
        System.out.println("Computing pca...eigenimages (" + this.eigenimages.length * this.eigenimages[0].length + "bytes) ok " + new Date().toString());
        this.a = null;
        System.gc();
        this.eigenvectors = BIJmatrix.transpose(this.eigenvectors);
        System.out.println("PCA...cleaning eigensystem");
        for (int j = 0; j < this.eigenimages.length; ++j) {
            int i;
            if (!(this.eigenvalues[j] < 0.0f)) continue;
            this.eigenvalues[j] = 0.0f;
            for (i = 0; i < this.eigenimages[j].length; ++i) {
                this.eigenimages[j][i] = 0.0f;
            }
            for (i = 0; i < this.eigenvectors[j].length; ++i) {
                this.eigenvectors[j][i] = 0.0f;
            }
        }
        this.totalVariance = BIJstats.sum(this.eigenvalues);
        return this.eigenimages;
    }

    public float[] computeProjection(float[] v) throws Exception {
        IJ.showStatus((String)"Computing projection...");
        float[] proj = BIJmatrix.mul(this.eigenimages, v);
        return proj;
    }

    public float[][] computeLinearCombination() {
        float[] factor = new float[this.eigenimages.length];
        for (int j = 0; j < this.eigenimages.length; ++j) {
            factor[j] = 1.0f;
        }
        return this.computeLinearCombination(factor);
    }

    public float[] getEigenImage(int j) {
        float norm = BIJmatrix.norm(this.eigenimages[j]);
        float[] normImage = new float[this.eigenimages[j].length];
        BIJmatrix.mulElements(normImage, this.eigenimages[j], (double)(1.0f / norm));
        return normImage;
    }

    public float[][] getCoordinates() {
        if (this.eigenvalues == null) {
            return this.eigenvectors;
        }
        if (this.an == null) {
            this.an = new float[this.eigenvectors.length][this.eigenvectors[0].length];
            for (int j = 0; j < this.eigenvectors.length; ++j) {
                for (int i = 0; i < this.eigenvectors[0].length; ++i) {
                    this.an[j][i] = this.eigenvalues[j] != 0.0f ? (float)((double)this.eigenvectors[j][i] / Math.sqrt(this.eigenvalues[j])) : 0.0f;
                }
            }
        }
        return this.an;
    }

    public float[] getCoordinatesImage() {
        float[] v = new float[this.eigenvectors.length * this.eigenvectors[0].length];
        for (int j = 0; j < this.eigenvectors.length; ++j) {
            for (int i = 0; i < this.eigenvectors[0].length; ++i) {
                v[j * this.eigenvectors[0].length + i] = this.eigenvalues[j] != 0.0f ? (float)((double)this.eigenvectors[j][i] / Math.sqrt(this.eigenvalues[j])) : 0.0f;
            }
        }
        return v;
    }

    public float[][] computeLinearCombination(float[] factor) {
        int n = 0;
        for (int j = 0; j < this.eigenimages.length; ++j) {
            if (factor[j] == 0.0f) continue;
            ++n;
        }
        float[][] lc = new float[n][this.eigenimages[0].length];
        IJ.showStatus((String)("Computing linear combination (" + n + ")..."));
        n = 0;
        for (int j = 0; j < this.eigenvectors.length; ++j) {
            IJ.showProgress((int)j, (int)this.eigenvectors.length);
            if (factor[j] == 0.0f) continue;
            for (int k = 0; k < this.eigenvectors[j].length; ++k) {
                for (int i = 0; i < this.eigenimages[j].length; ++i) {
                    float[] fArray = lc[n];
                    int n2 = i;
                    fArray[n2] = fArray[n2] + factor[j] * this.eigenimages[k][i] * this.eigenvectors[k][j];
                }
            }
            ++n;
        }
        return lc;
    }

    public float[] varianceSpectrum() {
        int i;
        float[] spectrum = new float[this.eigenvalues.length];
        spectrum[0] = this.eigenvalues[0];
        float sum = 0.0f;
        for (i = 0; i < spectrum.length; ++i) {
            sum += this.eigenvalues[i];
        }
        for (i = 1; i < this.eigenvalues.length; ++i) {
            spectrum[i] = spectrum[i - 1] + this.eigenvalues[i];
        }
        i = 0;
        while (i < spectrum.length) {
            int n = i++;
            spectrum[n] = spectrum[n] / sum;
        }
        return spectrum;
    }

    public double getTotalVariance() {
        return this.totalVariance;
    }
}

