/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.shader;

import java.util.HashMap;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.GLSLShaderProgram;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.ShaderAttributeSet;
import org.jogamp.java3d.ShaderAttributeValue;
import org.jogamp.java3d.SourceCodeShader;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector4f;

public class SimpleShaderAppearance
extends ShaderAppearance {
    private static String versionString = "#version 100\n";
    private static String outString = "varying";
    private static String inString = "varying";
    private static String fragColorDec = "";
    private static String fragColorVar = "gl_FragColor";
    private static String vertexAttributeInString = "attribute";
    private static String texture2D = "texture2D";
    private static String constMaxLightsStr = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
    public static String alphaTestUniforms = "uniform int alphaTestEnabled;\nuniform int alphaTestFunction;\nuniform float alphaTestValue;\n";
    public static String alphaTestMethod = "\tif(alphaTestEnabled != 0){\r\n\t\tif(alphaTestFunction==512)discard;//never (never keep it)\r\n\t\tif(alphaTestFunction==513 && !(baseMap.a< alphaTestValue))discard;\r\n\t\tif(alphaTestFunction==514 && !(baseMap.a==alphaTestValue))discard;\r\n\t\tif(alphaTestFunction==515 && !(baseMap.a<=alphaTestValue))discard;\r\n\t\tif(alphaTestFunction==516 && !(baseMap.a> alphaTestValue))discard;\r\n\t\tif(alphaTestFunction==517 && !(baseMap.a!=alphaTestValue))discard;\r\n\t\tif(alphaTestFunction==518 && !(baseMap.a>=alphaTestValue))discard;\r\n\t\t//alphaTestFunction==519//always (always keep it)\r\n\t}";
    public static String glFrontMaterial = "struct material\n\t{\n\t\tint lightEnabled;\n\t\tvec4 ambient;\n\t\tvec4 diffuse;\n\t\tvec4 emission; \n\t\tvec3 specular;\n\t\tfloat shininess;\n\t};\nuniform material glFrontMaterial;\n";
    public static String glLightSource = "struct lightSource\n\t{\n\t\tvec4 position;// in eye space\n \t\tvec4 diffuse;\n\t\tvec4 specular;\n\t\tfloat constantAttenuation, linearAttenuation, quadraticAttenuation;\n\t\tfloat spotCutoff, spotExponent;\n\t\tvec3 spotDirection;\n\t};\n\n\tuniform int numberOfLights;\n" + constMaxLightsStr + "\tuniform lightSource glLightSource[maxLights];\n";
    private static HashMap<Integer, GLSLShaderProgram> shaderPrograms = new HashMap();
    private static GLSLShaderProgram flatShaderProgram;
    private static GLSLShaderProgram colorLineShaderProgram;
    private static HashMap<GLSLShaderProgram, String> vertexShaderSources;
    private static HashMap<GLSLShaderProgram, String> fragmentShaderSources;
    private static ShaderAttributeSet baseMapShaderAttributeSet;
    private static HashMap<String, ShaderAttributeSet> shaderAttributeSetCache;
    private boolean buildBasedOnAttributes = false;
    private TexCoordGeneration texCoordGeneration = null;
    private String vertexShaderSource = null;
    private String fragmentShaderSource = null;

    public static void setVersionES100() {
        versionString = "#version 100\n";
        outString = "varying";
        inString = "varying";
        fragColorDec = "";
        fragColorVar = "gl_FragColor";
        vertexAttributeInString = "attribute";
        texture2D = "texture2D";
        constMaxLightsStr = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
        shaderPrograms.clear();
        vertexShaderSources.clear();
        fragmentShaderSources.clear();
    }

    public static void setVersionES300() {
        versionString = "#version 300 es\n";
        outString = "out";
        inString = "in";
        fragColorDec = "out vec4 glFragColor;\n";
        fragColorVar = "glFragColor";
        vertexAttributeInString = "in";
        texture2D = "texture";
        constMaxLightsStr = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
        shaderPrograms.clear();
        vertexShaderSources.clear();
        fragmentShaderSources.clear();
    }

    public static void setVersion120() {
        versionString = "#version 120\n";
        outString = "varying";
        inString = "varying";
        fragColorDec = "";
        fragColorVar = "gl_FragColor";
        vertexAttributeInString = "attribute";
        texture2D = "texture2D";
        constMaxLightsStr = "\tconst int maxLights = 3;\n";
        shaderPrograms.clear();
        vertexShaderSources.clear();
        fragmentShaderSources.clear();
    }

    public SimpleShaderAppearance() {
        this.buildBasedOnAttributes = true;
        this.rebuildShaders();
    }

    public SimpleShaderAppearance(Color3f color) {
        this(color, false, false);
    }

    public SimpleShaderAppearance(boolean lit, boolean hasTexture) {
        this(null, lit, hasTexture);
    }

    private SimpleShaderAppearance(Color3f color, boolean lit, boolean hasTexture) {
        if (lit || hasTexture) {
            this.build(hasTexture, lit, false, false);
        } else if (color != null) {
            PolygonAttributes polyAtt = new PolygonAttributes(1, 0, 0.0f);
            polyAtt.setPolygonOffset(0.1f);
            this.setPolygonAttributes(polyAtt);
            LineAttributes lineAtt = new LineAttributes(1.0f, 0, false);
            this.setLineAttributes(lineAtt);
            ColoringAttributes colorAtt = new ColoringAttributes(color, 0);
            this.setColoringAttributes(colorAtt);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            this.setRenderingAttributes(ra);
            Material mat = new Material();
            this.setMaterial(mat);
            if (colorLineShaderProgram == null) {
                colorLineShaderProgram = new GLSLShaderProgram(){

                    @Override
                    public String toString() {
                        return "SimpleShaderAppearance colorLineShaderProgram";
                    }
                };
                String vertexProgram = versionString;
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = vertexProgram + "uniform int ignoreVertexColors;\n";
                vertexProgram = vertexProgram + "uniform vec4 objectColor;\n";
                vertexProgram = vertexProgram + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = vertexProgram + outString + " vec4 glFrontColor;\n";
                vertexProgram = vertexProgram + "void main( void ){\n";
                vertexProgram = vertexProgram + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = vertexProgram + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = vertexProgram + "\tglFrontColor = objectColor;\n";
                vertexProgram = vertexProgram + "else\n";
                vertexProgram = vertexProgram + "\tglFrontColor = glColor;\n";
                vertexProgram = vertexProgram + "}";
                String fragmentProgram = versionString;
                fragmentProgram = fragmentProgram + "precision mediump float;\n";
                fragmentProgram = fragmentProgram + inString + " vec4 glFrontColor;\n";
                fragmentProgram = fragmentProgram + fragColorDec;
                fragmentProgram = fragmentProgram + "void main( void ){\n";
                fragmentProgram = fragmentProgram + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = fragmentProgram + "}";
                colorLineShaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
                vertexShaderSources.put(colorLineShaderProgram, vertexProgram);
                fragmentShaderSources.put(colorLineShaderProgram, fragmentProgram);
            }
            this.setShaderProgram(colorLineShaderProgram);
            this.vertexShaderSource = vertexShaderSources.get(colorLineShaderProgram);
            this.fragmentShaderSource = fragmentShaderSources.get(colorLineShaderProgram);
        } else {
            if (flatShaderProgram == null) {
                flatShaderProgram = new GLSLShaderProgram(){

                    @Override
                    public String toString() {
                        return "SimpleShaderAppearance flatShaderProgram";
                    }
                };
                String vertexProgram = versionString;
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = vertexProgram + "uniform int ignoreVertexColors;\n";
                vertexProgram = vertexProgram + "uniform vec4 objectColor;\n";
                vertexProgram = vertexProgram + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = vertexProgram + outString + " vec4 glFrontColor;\n";
                vertexProgram = vertexProgram + "void main( void ){\n";
                vertexProgram = vertexProgram + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = vertexProgram + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = vertexProgram + "\tglFrontColor = objectColor;\n";
                vertexProgram = vertexProgram + "else\n";
                vertexProgram = vertexProgram + "\tglFrontColor = glColor;\n";
                vertexProgram = vertexProgram + "}";
                String fragmentProgram = versionString;
                fragmentProgram = fragmentProgram + "precision mediump float;\n";
                fragmentProgram = fragmentProgram + "uniform float transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + inString + " vec4 glFrontColor;\n";
                fragmentProgram = fragmentProgram + fragColorDec;
                fragmentProgram = fragmentProgram + "void main( void ){\n";
                fragmentProgram = fragmentProgram + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = fragmentProgram + fragColorVar + ".a *= transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + "}";
                flatShaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
                vertexShaderSources.put(flatShaderProgram, vertexProgram);
                fragmentShaderSources.put(flatShaderProgram, fragmentProgram);
            }
            this.setShaderProgram(flatShaderProgram);
            this.vertexShaderSource = vertexShaderSources.get(flatShaderProgram);
            this.fragmentShaderSource = fragmentShaderSources.get(flatShaderProgram);
        }
    }

    public String getVertexShaderSource() {
        return this.vertexShaderSource;
    }

    public String getFragmentShaderSource() {
        return this.fragmentShaderSource;
    }

    private static Shader[] makeShaders(String vertexProgram, String fragmentProgram) {
        Shader[] shaders = new Shader[]{new SourceCodeShader(1, 1, vertexProgram){

            @Override
            public String toString() {
                return "vertexProgram";
            }
        }, new SourceCodeShader(1, 2, fragmentProgram){

            @Override
            public String toString() {
                return "fragmentProgram";
            }
        }};
        return shaders;
    }

    public void setUpdatableCapabilities() {
        if (!this.getCapability(0)) {
            this.setCapability(0);
        }
        if (!this.getCapability(20)) {
            this.setCapability(20);
        }
        if (!this.getCapability(2)) {
            this.setCapability(2);
        }
        if (!this.getCapability(14)) {
            this.setCapability(14);
        }
        if (this.getPolygonAttributes() != null && !this.getPolygonAttributes().getCapability(2)) {
            this.getPolygonAttributes().setCapability(2);
        }
        if (!this.getCapability(6)) {
            this.setCapability(6);
        }
        if (this.getTextureAttributes() != null && !this.getTextureAttributes().getCapability(4)) {
            this.getTextureAttributes().setCapability(4);
        }
        if (!this.getCapability(23)) {
            this.setCapability(23);
        }
        if (!this.getCapability(25)) {
            this.setCapability(25);
        }
    }

    public void rebuildShaders() {
        if (this.buildBasedOnAttributes) {
            if ((!this.isLive() && !this.isCompiled() || this.getCapability(0) && this.getCapability(20) && this.getCapability(2) && this.getCapability(14) && this.getCapability(6)) && (this.getPolygonAttributes() == null || !this.getPolygonAttributes().isLive() && !this.getPolygonAttributes().isCompiled() || this.getPolygonAttributes().getCapability(2)) && (this.getTextureAttributes() == null || !this.getTextureAttributes().isLive() && !this.getTextureAttributes().isCompiled() || this.getTextureAttributes().getCapability(4)) && (!this.isLive() && !this.isCompiled() || this.getCapability(23) && this.getCapability(25))) {
                boolean hasTexture;
                boolean bl = hasTexture = this.getTexture() != null || this.getTextureUnitCount() > 0;
                if (this.getTextureUnitCount() > 0) {
                    System.out.println("this.getTextureUnitCount() " + this.getTextureUnitCount());
                }
                boolean lit = this.getMaterial() != null;
                lit = lit && (this.getPolygonAttributes() == null || this.getPolygonAttributes().getPolygonMode() == 2);
                boolean hasTextureCoordGen = hasTexture && this.texCoordGeneration != null;
                boolean hasTextureAttributeTransform = false;
                if (this.getTexture() != null && this.getTextureAttributes() != null) {
                    Transform3D t = new Transform3D();
                    this.getTextureAttributes().getTextureTransform(t);
                    hasTextureAttributeTransform = t.getBestType() != 2;
                } else if (this.getTextureUnitCount() > 0) {
                    Transform3D t = new Transform3D();
                    this.getTextureUnitState(0).getTextureAttributes().getTextureTransform(t);
                    hasTextureAttributeTransform = t.getBestType() != 2;
                }
                this.build(hasTexture, lit, hasTextureCoordGen, hasTextureAttributeTransform);
            } else {
                System.out.println("Shader unable to be rebuild due to read capabilities missing, or write shader missing");
                System.out.println("this.getCapability(ALLOW_MATERIAL_READ) " + this.getCapability(0));
                System.out.println("this.getCapability(ALLOW_TEXTURE_UNIT_STATE_READ) " + this.getCapability(20));
                System.out.println("this.getCapability(ALLOW_TEXTURE_READ) " + this.getCapability(2));
                System.out.println("this.getCapability(ALLOW_POLYGON_ATTRIBUTES_READ) " + this.getCapability(14));
                if (this.getCapability(14)) {
                    System.out.println("this.getPolygonAttributes() == null " + (this.getPolygonAttributes() == null));
                    if (this.getPolygonAttributes() != null) {
                        System.out.println("this.getPolygonAttributes().getCapability(PolygonAttributes.ALLOW_MODE_READ) " + this.getPolygonAttributes().getCapability(2));
                    }
                }
                System.out.println("this.getCapability(ALLOW_TEXTURE_ATTRIBUTES_READ) " + this.getCapability(6));
                if (this.getCapability(6)) {
                    System.out.println("this.getTextureAttributes() == null " + (this.getTextureAttributes() == null));
                    if (this.getTextureAttributes() != null) {
                        System.out.println("this.getTextureAttributes().getCapability(TextureAttributes.ALLOW_TRANSFORM_READ) " + this.getTextureAttributes().getCapability(4));
                    }
                }
                System.out.println("this.getCapability(ALLOW_SHADER_PROGRAM_WRITE) " + this.getCapability(23));
                System.out.println("this.getCapability(ALLOW_SHADER_ATTRIBUTE_SET_WRITE) " + this.getCapability(25));
                new Throwable().printStackTrace();
            }
        }
    }

    private void build(boolean hasTexture, boolean lit, boolean hasTextureCoordGen, boolean hasTextureAttributeTransform) {
        int shaderKey = (hasTexture ? 1 : 0) + (lit ? 2 : 0) + (hasTextureAttributeTransform ? 4 : 0) + (!hasTextureCoordGen ? 8 : (this.texCoordGeneration.getGenMode() == 0 ? 16 : (this.texCoordGeneration.getGenMode() == 1 ? 32 : (this.texCoordGeneration.getGenMode() == 2 ? 64 : 0))));
        GLSLShaderProgram shaderProgram = shaderPrograms.get(new Integer(shaderKey));
        if (shaderProgram == null) {
            String vertexProgram = versionString;
            String fragmentProgram = versionString;
            if (hasTextureCoordGen && this.texCoordGeneration.getFormat() != 0) {
                System.out.println("texCoordGeneration.getFormat() must be TEXTURE_COORDINATE_2");
            }
            if (lit) {
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = vertexProgram + vertexAttributeInString + " vec3 glNormal; \n";
                if (hasTexture && !hasTextureCoordGen) {
                    vertexProgram = vertexProgram + vertexAttributeInString + " vec2 glMultiTexCoord0;\n";
                }
                if (hasTextureAttributeTransform) {
                    vertexProgram = vertexProgram + "uniform mat4 textureTransform;\n";
                }
                vertexProgram = vertexProgram + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = vertexProgram + "uniform mat4 glModelViewMatrix;\n";
                vertexProgram = vertexProgram + "uniform mat3 glNormalMatrix;\n";
                vertexProgram = vertexProgram + "uniform int ignoreVertexColors;\n";
                vertexProgram = vertexProgram + "uniform vec4 glLightModelambient;\n";
                vertexProgram = vertexProgram + glFrontMaterial;
                vertexProgram = vertexProgram + glLightSource;
                if (hasTextureCoordGen && (this.texCoordGeneration.getGenMode() == 0 || this.texCoordGeneration.getGenMode() == 1)) {
                    vertexProgram = vertexProgram + "uniform vec4 texCoordGenPlaneS;\n";
                    vertexProgram = vertexProgram + "uniform vec4 texCoordGenPlaneT;\n";
                }
                if (hasTexture) {
                    vertexProgram = vertexProgram + outString + " vec2 glTexCoord0;\n";
                }
                vertexProgram = vertexProgram + outString + "  vec3 ViewVec;\n";
                vertexProgram = vertexProgram + outString + "  vec3 N;\n";
                vertexProgram = vertexProgram + outString + "  vec4 A;\n";
                vertexProgram = vertexProgram + outString + "  vec4 C;\n";
                vertexProgram = vertexProgram + outString + "  vec3 emissive;\n";
                vertexProgram = vertexProgram + outString + "  vec4 lightsD[maxLights];\n";
                vertexProgram = vertexProgram + outString + "  vec3 lightsS[maxLights];\n";
                vertexProgram = vertexProgram + outString + "  vec3 lightsLightDir[maxLights];\n";
                vertexProgram = vertexProgram + outString + "  float shininess;\n";
                if (hasTextureCoordGen) {
                    vertexProgram = vertexProgram + "vec2 texlinear(vec4 pos, vec4 planeOS, vec4 planeOT)\n";
                    vertexProgram = vertexProgram + "{\n";
                    vertexProgram = vertexProgram + "\treturn vec2(pos.x*planeOS.x+pos.y*planeOS.y+pos.z*planeOS.z+pos.w*planeOS.w,pos.x*planeOT.x+pos.y*planeOT.y+pos.z*planeOT.z+pos.w*planeOT.w);\n";
                    vertexProgram = vertexProgram + "}\n";
                }
                vertexProgram = vertexProgram + "void main( void ){\n";
                vertexProgram = vertexProgram + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = vertexProgram + "N = normalize(glNormalMatrix * glNormal);\n";
                if (hasTexture) {
                    if (!hasTextureCoordGen) {
                        vertexProgram = hasTextureAttributeTransform ? vertexProgram + "glTexCoord0 = (textureTransform * vec4(glMultiTexCoord0,0,1)).st;\n" : vertexProgram + "glTexCoord0 = glMultiTexCoord0.st;\n";
                    } else if (this.texCoordGeneration.getGenMode() == 0) {
                        vertexProgram = vertexProgram + "glTexCoord0 = texlinear(glVertex, texCoordGenPlaneS, texCoordGenPlaneT);\n";
                    } else if (this.texCoordGeneration.getGenMode() == 1) {
                        vertexProgram = vertexProgram + "glTexCoord0 = texlinear(inverse(glVertex), texCoordGenPlaneS, texCoordGenPlaneT);\n";
                    } else if (this.texCoordGeneration.getGenMode() == 2) {
                        vertexProgram = vertexProgram + "vec3 u = normalize( vec3(glModelViewMatrix * glVertex) ); \n";
                        vertexProgram = vertexProgram + "vec3 n = normalize( glNormalMatrix * glNormal ); \n";
                        vertexProgram = vertexProgram + "vec3 r = reflect( u, n ); \n";
                        vertexProgram = vertexProgram + "float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + (r.z+1.0)*(r.z+1.0)); \n";
                        vertexProgram = vertexProgram + "glTexCoord0.s = r.x/m + 0.5; \n";
                        vertexProgram = vertexProgram + "glTexCoord0.t = r.y/m + 0.5; \n";
                    } else {
                        System.err.println("texCoordGeneration.getGenMode() not supported " + this.texCoordGeneration.getGenMode());
                    }
                }
                vertexProgram = vertexProgram + "vec3 v = vec3(glModelViewMatrix * glVertex);\n";
                vertexProgram = vertexProgram + "ViewVec = -v.xyz;\n";
                vertexProgram = vertexProgram + "A = glLightModelambient * glFrontMaterial.ambient;\n";
                vertexProgram = vertexProgram + "if( ignoreVertexColors != 0) \n";
                vertexProgram = vertexProgram + "\tC = vec4(1,1,1,1);//glFrontMaterial.diffuse; \n";
                vertexProgram = vertexProgram + "else \n";
                vertexProgram = vertexProgram + "\tC = glColor; \n";
                vertexProgram = vertexProgram + "emissive = glFrontMaterial.emission.rgb;\n";
                vertexProgram = vertexProgram + "shininess = glFrontMaterial.shininess;\n";
                vertexProgram = vertexProgram + "for (int index = 0; index < numberOfLights && index < maxLights; index++) // for all light sources\n";
                vertexProgram = vertexProgram + "{\t\n";
                vertexProgram = vertexProgram + "\tlightsD[index] = glLightSource[index].diffuse * glFrontMaterial.diffuse;\t\n";
                vertexProgram = vertexProgram + "\tlightsS[index] = glLightSource[index].specular.rgb * glFrontMaterial.specular;\n";
                vertexProgram = vertexProgram + "\tlightsLightDir[index] = glLightSource[index].position.xyz;\t\n";
                vertexProgram = vertexProgram + "}\n";
                vertexProgram = vertexProgram + "}";
                fragmentProgram = fragmentProgram + "precision mediump float;\n";
                fragmentProgram = fragmentProgram + "precision highp int;\n";
                fragmentProgram = fragmentProgram + "uniform float transparencyAlpha;\n";
                if (hasTexture) {
                    fragmentProgram = fragmentProgram + alphaTestUniforms;
                    fragmentProgram = fragmentProgram + inString + " vec2 glTexCoord0;\n";
                    fragmentProgram = fragmentProgram + "uniform sampler2D BaseMap;\n";
                }
                fragmentProgram = fragmentProgram + "uniform int numberOfLights;\n";
                fragmentProgram = fragmentProgram + inString + " vec3 ViewVec;\n";
                fragmentProgram = fragmentProgram + inString + " vec3 N;\n";
                fragmentProgram = fragmentProgram + inString + " vec4 A;\n";
                fragmentProgram = fragmentProgram + inString + " vec4 C;\n";
                fragmentProgram = fragmentProgram + inString + " vec3 emissive;\n";
                fragmentProgram = fragmentProgram + inString + " float shininess;\n";
                fragmentProgram = fragmentProgram + constMaxLightsStr;
                fragmentProgram = fragmentProgram + inString + " vec4 lightsD[maxLights]; \n";
                fragmentProgram = fragmentProgram + inString + " vec3 lightsS[maxLights]; \n";
                fragmentProgram = fragmentProgram + inString + " vec3 lightsLightDir[maxLights]; \n";
                fragmentProgram = fragmentProgram + fragColorDec;
                fragmentProgram = fragmentProgram + "void main( void ){\n ";
                if (hasTexture) {
                    fragmentProgram = fragmentProgram + "vec4 baseMap = " + texture2D + "( BaseMap, glTexCoord0.st );\n";
                }
                if (hasTexture) {
                    fragmentProgram = fragmentProgram + alphaTestMethod;
                }
                fragmentProgram = fragmentProgram + "vec4 color;\n";
                fragmentProgram = fragmentProgram + "vec3 albedo = " + (hasTexture ? "baseMap.rgb *" : "") + " C.rgb;\n";
                fragmentProgram = fragmentProgram + "vec3 diffuse = A.rgb;\n";
                fragmentProgram = fragmentProgram + "vec3 spec;\n";
                fragmentProgram = fragmentProgram + "vec3 normal = N;\n";
                fragmentProgram = fragmentProgram + "vec3 E = normalize(ViewVec);\n";
                fragmentProgram = fragmentProgram + "float EdotN = max( dot(normal, E), 0.0 );\n";
                fragmentProgram = fragmentProgram + "for (int index = 0; index < numberOfLights && index < maxLights; index++) // for all light sources\n";
                fragmentProgram = fragmentProgram + "{ \t\n";
                fragmentProgram = fragmentProgram + "\tvec3 L = normalize( lightsLightDir[index] );\n";
                fragmentProgram = fragmentProgram + "\t//vec3 R = reflect(-L, normal);\n";
                fragmentProgram = fragmentProgram + "\tvec3 H = normalize( L + E );\t\t\n";
                fragmentProgram = fragmentProgram + "\tfloat NdotL = max( dot(normal, L), 0.0 );\n";
                fragmentProgram = fragmentProgram + "\tfloat NdotH = max( dot(normal, H), 0.0 );\t\n";
                fragmentProgram = fragmentProgram + "\tfloat NdotNegL = max( dot(normal, -L), 0.0 );\t\n";
                fragmentProgram = fragmentProgram + "\tdiffuse = diffuse + (lightsD[index].rgb * NdotL);\n";
                fragmentProgram = fragmentProgram + "\tspec = spec + (lightsS[index] * pow(NdotH, 0.3*shininess));\n";
                fragmentProgram = fragmentProgram + "}\n";
                fragmentProgram = fragmentProgram + "color.rgb = albedo * (diffuse + emissive) + spec;\n";
                fragmentProgram = hasTexture ? fragmentProgram + "color.a = C.a * baseMap.a;\n" : fragmentProgram + "color.a = C.a;\n";
                fragmentProgram = fragmentProgram + "color.a *= transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + fragColorVar + " = color;\n";
                fragmentProgram = fragmentProgram + "}";
            } else if (hasTexture) {
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glVertex;\n";
                if (!hasTextureCoordGen) {
                    vertexProgram = vertexProgram + vertexAttributeInString + " vec2 glMultiTexCoord0;\n";
                }
                if (hasTextureAttributeTransform) {
                    vertexProgram = vertexProgram + "uniform mat4 textureTransform;\n";
                }
                vertexProgram = vertexProgram + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = vertexProgram + outString + " vec2 glTexCoord0;\n";
                vertexProgram = vertexProgram + "void main( void ){\n";
                vertexProgram = vertexProgram + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                if (!hasTextureCoordGen) {
                    vertexProgram = hasTextureAttributeTransform ? vertexProgram + "glTexCoord0 = (textureTransform * vec4(glMultiTexCoord0,0,1)).st;\n" : vertexProgram + "glTexCoord0 = glMultiTexCoord0.st;\n";
                } else if (this.texCoordGeneration.getGenMode() == 0) {
                    vertexProgram = vertexProgram + "glTexCoord0 = texlinear(glVertex, texCoordGenPlaneS, texCoordGenPlaneT);\n";
                } else if (this.texCoordGeneration.getGenMode() == 1) {
                    vertexProgram = vertexProgram + "glTexCoord0 = texlinear(inverse(glVertex), texCoordGenPlaneS, texCoordGenPlaneT);\n";
                } else if (this.texCoordGeneration.getGenMode() == 2) {
                    vertexProgram = vertexProgram + "vec3 u = normalize( vec3(glModelViewMatrix * glVertex) ); \n";
                    vertexProgram = vertexProgram + "vec3 n = normalize( glNormalMatrix * glNormal ); \n";
                    vertexProgram = vertexProgram + "vec3 r = reflect( u, n ); \n";
                    vertexProgram = vertexProgram + "float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + (r.z+1.0)*(r.z+1.0)); \n";
                    vertexProgram = vertexProgram + "glTexCoord0.s = r.x/m + 0.5; \n";
                    vertexProgram = vertexProgram + "glTexCoord0.t = r.y/m + 0.5; \n";
                } else {
                    System.err.println("texCoordGeneration.getGenMode() not supported " + this.texCoordGeneration.getGenMode());
                }
                vertexProgram = vertexProgram + "}";
                fragmentProgram = fragmentProgram + "precision mediump float;\n";
                fragmentProgram = fragmentProgram + "uniform float transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + alphaTestUniforms;
                fragmentProgram = fragmentProgram + inString + " vec2 glTexCoord0;\n";
                fragmentProgram = fragmentProgram + "uniform sampler2D BaseMap;\n";
                fragmentProgram = fragmentProgram + fragColorDec;
                fragmentProgram = fragmentProgram + "void main( void ){\n ";
                fragmentProgram = fragmentProgram + "vec4 baseMap = " + texture2D + "( BaseMap, glTexCoord0.st );\n";
                fragmentProgram = fragmentProgram + alphaTestMethod;
                fragmentProgram = fragmentProgram + "baseMap.a *= transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + fragColorVar + " = baseMap;\n";
                fragmentProgram = fragmentProgram + "}";
            } else {
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = vertexProgram + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = vertexProgram + "uniform int ignoreVertexColors;\n";
                vertexProgram = vertexProgram + "uniform vec4 objectColor;\n";
                vertexProgram = vertexProgram + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = vertexProgram + outString + " vec4 glFrontColor;\n";
                vertexProgram = vertexProgram + "void main( void ){\n";
                vertexProgram = vertexProgram + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = vertexProgram + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = vertexProgram + "\tglFrontColor = objectColor;\n";
                vertexProgram = vertexProgram + "else\n";
                vertexProgram = vertexProgram + "\tglFrontColor = glColor;\n";
                vertexProgram = vertexProgram + "}";
                fragmentProgram = fragmentProgram + "precision mediump float;\n";
                fragmentProgram = fragmentProgram + "uniform float transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + inString + " vec4 glFrontColor;\n";
                fragmentProgram = fragmentProgram + fragColorDec;
                fragmentProgram = fragmentProgram + "void main( void ){\n";
                fragmentProgram = fragmentProgram + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = fragmentProgram + fragColorVar + ".a *= transparencyAlpha;\n";
                fragmentProgram = fragmentProgram + "}";
            }
            shaderProgram = new GLSLShaderProgram(){

                @Override
                public String toString() {
                    return "SimpleShaderAppearance " + this.getName();
                }
            };
            shaderProgram.setName("shaderkey = " + shaderKey);
            shaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
            vertexShaderSources.put(shaderProgram, vertexProgram);
            fragmentShaderSources.put(shaderProgram, fragmentProgram);
            if (hasTexture) {
                if (this.texCoordGeneration != null && (this.texCoordGeneration.getGenMode() == 0 || this.texCoordGeneration.getGenMode() == 1)) {
                    shaderProgram.setShaderAttrNames(new String[]{"BaseMap", "texCoordGenPlaneS", "texCoordGenPlaneT"});
                } else {
                    shaderProgram.setShaderAttrNames(new String[]{"BaseMap"});
                }
            }
            shaderPrograms.put(new Integer(shaderKey), shaderProgram);
        }
        if (this.isLive()) {
            this.setShaderProgram(null);
        }
        this.setShaderProgram(shaderProgram);
        this.vertexShaderSource = vertexShaderSources.get(shaderProgram);
        this.fragmentShaderSource = fragmentShaderSources.get(shaderProgram);
        if (hasTexture) {
            if (this.texCoordGeneration != null && (this.texCoordGeneration.getGenMode() == 0 || this.texCoordGeneration.getGenMode() == 1)) {
                Vector4f planeS = new Vector4f();
                this.texCoordGeneration.getPlaneS(planeS);
                Vector4f planeT = new Vector4f();
                this.texCoordGeneration.getPlaneT(planeT);
                String key = "planeS " + planeS + " planeT " + planeT;
                ShaderAttributeSet shaderAttributeSet = shaderAttributeSetCache.get(key);
                if (shaderAttributeSet == null) {
                    shaderAttributeSet = new ShaderAttributeSet();
                    shaderAttributeSet.put(new ShaderAttributeValue("BaseMap", new Integer(0)));
                    shaderAttributeSet.put(new ShaderAttributeValue("texCoordGenPlaneS", planeS));
                    shaderAttributeSet.put(new ShaderAttributeValue("texCoordGenPlaneT", planeT));
                    shaderAttributeSetCache.put(key, shaderAttributeSet);
                }
                this.setShaderAttributeSet(shaderAttributeSet);
            } else {
                if (baseMapShaderAttributeSet == null) {
                    baseMapShaderAttributeSet = new ShaderAttributeSet();
                    baseMapShaderAttributeSet.put(new ShaderAttributeValue("BaseMap", new Integer(0)));
                }
                this.setShaderAttributeSet(baseMapShaderAttributeSet);
            }
        } else {
            this.setShaderAttributeSet(null);
        }
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        this.rebuildShaders();
    }

    @Override
    public void setColoringAttributes(ColoringAttributes coloringAttributes) {
        super.setColoringAttributes(coloringAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTransparencyAttributes(TransparencyAttributes transparencyAttributes) {
        super.setTransparencyAttributes(transparencyAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setRenderingAttributes(RenderingAttributes renderingAttributes) {
        super.setRenderingAttributes(renderingAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setPolygonAttributes(PolygonAttributes polygonAttributes) {
        super.setPolygonAttributes(polygonAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setLineAttributes(LineAttributes lineAttributes) {
        super.setLineAttributes(lineAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setPointAttributes(PointAttributes pointAttributes) {
        super.setPointAttributes(pointAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTexture(Texture texture) {
        super.setTexture(texture);
        this.rebuildShaders();
    }

    @Override
    public void setTextureAttributes(TextureAttributes textureAttributes) {
        super.setTextureAttributes(textureAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        this.texCoordGeneration = texCoordGeneration;
        this.rebuildShaders();
    }

    @Override
    public void setTextureUnitState(TextureUnitState[] stateArray) {
        System.out.println("SimpleShaderAppearance with textureunitstates in use");
        super.setTextureUnitState(stateArray);
        this.rebuildShaders();
    }

    @Override
    public void setTextureUnitState(int index, TextureUnitState state) {
        System.out.println("SimpleShaderAppearance with textureunitstates in use");
        super.setTextureUnitState(index, state);
        this.rebuildShaders();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        SimpleShaderAppearance a = new SimpleShaderAppearance();
        a.duplicateNodeComponent(this);
        return a;
    }

    static {
        vertexShaderSources = new HashMap();
        fragmentShaderSources = new HashMap();
        baseMapShaderAttributeSet = null;
        shaderAttributeSetCache = new HashMap();
    }
}

