/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5DisplacementField;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;

public class SlicerTransformations {
    public static final String AFFINE_ATTR = "Transformation_Matrix";
    public static final int[] permXYZ = new int[]{2, 1, 0};
    public static final int[] perm = new int[]{1, 2, 3, 0};

    public static final <T extends NativeType<T> & RealType<T>> void saveDisplacementField(N5Writer n5Writer, String dataset, RandomAccessibleInterval<T> dfield, int[] blockSize, Compression compression, ExecutorService exec) {
        int[] vecBlkSz;
        if (blockSize.length >= dfield.numDimensions()) {
            vecBlkSz = blockSize;
        } else {
            vecBlkSz = new int[blockSize.length + 1];
            vecBlkSz[0] = (int)dfield.dimension(0);
            for (int i = 1; i < vecBlkSz.length; ++i) {
                vecBlkSz[i] = blockSize[i - 1];
            }
        }
        RandomAccessibleInterval dfieldPerm = Views.moveAxis(dfield, (int)0, (int)3);
        try {
            N5Utils.save((RandomAccessibleInterval)dfieldPerm, (N5Writer)n5Writer, (String)dataset, (int[])vecBlkSz, (Compression)compression, (ExecutorService)exec);
        }
        catch (N5Exception e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static final <T extends NativeType<T> & RealType<T>> RandomAccessibleInterval<T> dxyz2dzyx(RandomAccessibleInterval<T> df) {
        IntervalView dx = Views.hyperSlice(df, (int)0, (long)0L);
        IntervalView dy = Views.hyperSlice(df, (int)0, (long)1L);
        IntervalView dz = Views.hyperSlice(df, (int)0, (long)2L);
        IntervalView dxp = N5DisplacementField.permute((RandomAccessibleInterval)dx, (int[])permXYZ);
        IntervalView dyp = N5DisplacementField.permute((RandomAccessibleInterval)dy, (int[])permXYZ);
        IntervalView dzp = N5DisplacementField.permute((RandomAccessibleInterval)dz, (int[])permXYZ);
        RandomAccessibleInterval dfp = Views.stack((RandomAccessibleInterval[])new RandomAccessibleInterval[]{dxp, dyp, dzp});
        return N5DisplacementField.permute((RandomAccessibleInterval)dfp, (int[])perm);
    }

    public static final <T extends NativeType<T> & RealType<T>> void saveAffine(N5Writer n5Writer, String dataset, AffineGet affine) {
        try {
            double[][] mtx;
            if (affine instanceof AffineTransform3D) {
                AffineTransform3D a3d = (AffineTransform3D)affine;
                mtx = new double[4][4];
                a3d.toMatrix(mtx);
            } else if (affine instanceof AffineTransform2D) {
                AffineTransform2D a2d = (AffineTransform2D)affine;
                mtx = new double[3][3];
                a2d.toMatrix(mtx);
            } else {
                int nd = affine.numTargetDimensions();
                mtx = new double[nd][nd];
                for (int i = 0; i < nd; ++i) {
                    for (int j = 0; j < nd; ++j) {
                        mtx[i][j] = affine.get(i, j);
                    }
                }
            }
            n5Writer.setAttribute(dataset, AFFINE_ATTR, (Object)mtx);
        }
        catch (N5Exception n5Exception) {
            // empty catch block
        }
    }
}

