/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats;

import java.util.Arrays;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.type.numeric.RealType;

class SumConvolver
implements Runnable {
    private final RandomAccess<? extends RealType<?>> in;
    private final RandomAccess<? extends RealType<?>> out;
    private final int d;
    private final int width;
    private final double[] buffer;
    private final long length;

    static <T extends RealType<?>> LineConvolverFactory<T> factory(final long before, final long after) {
        return new LineConvolverFactory<T>(){

            public long getBorderBefore() {
                return before;
            }

            public long getBorderAfter() {
                return after;
            }

            public Runnable getConvolver(RandomAccess<? extends T> in, RandomAccess<? extends T> out, int d, long lineLength) {
                return new SumConvolver(before + 1L + after, in, out, d, lineLength);
            }

            public T preferredSourceType(T targetType) {
                return targetType;
            }
        };
    }

    public SumConvolver(long width, RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, int d, long length) {
        this.in = in;
        this.out = out;
        this.d = d;
        if (width >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Width of SumConvolver needs to be less than Integer.MAX - 8");
        }
        this.width = (int)width;
        this.buffer = new double[this.width];
        this.length = length;
    }

    @Override
    public void run() {
        double remaining;
        Arrays.fill(this.buffer, 0.0);
        double sumA = 0.0;
        for (int i = 1; i < this.width; ++i) {
            double value = ((RealType)this.in.get()).getRealDouble();
            this.in.fwd(this.d);
            this.buffer[i] = value;
            sumA += value;
        }
        for (remaining = (double)this.length; remaining > (double)this.width; remaining -= (double)this.width) {
            double sumB = 0.0;
            for (int i = 0; i < this.width; ++i) {
                double value = ((RealType)this.in.get()).getRealDouble();
                this.in.fwd(this.d);
                this.buffer[i] = value;
                ((RealType)this.out.get()).setReal((sumA -= this.buffer[i]) + (sumB += value));
                this.out.fwd(this.d);
            }
            sumA = sumB;
        }
        int i = 0;
        while ((double)i < remaining) {
            this.in.fwd(this.d);
            ((RealType)this.out.get()).setReal(sumA += ((RealType)this.in.get()).getRealDouble() - this.buffer[i]);
            this.out.fwd(this.d);
            ++i;
        }
    }
}

