/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.imglib2.util.Cast;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.ChannelSetting;

public final class GlobalSettings {
    private final ChannelSetting channelSetting;
    private final int numDimensions;
    private final List<Double> sigmas;
    private final List<Double> pixelSize;

    private GlobalSettings(ChannelSetting channelSetting, int numDimensions, List<Double> sigmas, List<Double> pixelSize) {
        this.channelSetting = channelSetting;
        this.numDimensions = numDimensions;
        this.sigmas = Collections.unmodifiableList(new ArrayList<Double>(sigmas));
        this.pixelSize = Collections.unmodifiableList(pixelSize == null ? this.ones(numDimensions) : new ArrayList<Double>(pixelSize));
    }

    public GlobalSettings(GlobalSettings globalSettings) {
        this(globalSettings.channelSetting, globalSettings.numDimensions, globalSettings.sigmas, globalSettings.pixelSize);
    }

    public static Builder default2d() {
        return (Builder)((Builder)((Builder)new Builder().channels(ChannelSetting.SINGLE)).dimensions(2)).sigmaRange(1.0, 16.0);
    }

    public static Builder default3d() {
        return (Builder)((Builder)((Builder)new Builder().channels(ChannelSetting.SINGLE)).dimensions(3)).sigmaRange(1.0, 8.0);
    }

    public ChannelSetting channelSetting() {
        return this.channelSetting;
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public List<Double> sigmas() {
        return this.sigmas;
    }

    public List<Double> pixelSize() {
        return this.pixelSize;
    }

    public double[] pixelSizeAsDoubleArray() {
        return this.pixelSize.stream().mapToDouble(x -> x).toArray();
    }

    private List<Double> ones(int numDimensions) {
        return IntStream.range(0, numDimensions).mapToObj(ignore -> 1.0).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.channelSetting, this.numDimensions, this.sigmas, this.pixelSize());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings settings = (GlobalSettings)obj;
        return this.channelSetting.equals(settings.channelSetting) && this.numDimensions == settings.numDimensions && this.sigmas.equals(settings.sigmas) && this.pixelSize().equals(settings.pixelSize());
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        private Builder() {
        }

        public GlobalSettings build() {
            return this.buildGlobalSettings();
        }
    }

    public static class AbstractBuilder<T> {
        private ChannelSetting channelSetting = ChannelSetting.SINGLE;
        private int numDimensions = 3;
        private List<Double> sigmas = Arrays.asList(1.0, 2.0, 4.0, 8.0);
        private List<Double> pixelSize = null;

        protected AbstractBuilder() {
        }

        public T channels(ChannelSetting channelSetting) {
            this.channelSetting = channelSetting;
            return (T)Cast.unchecked((Object)this);
        }

        public T dimensions(int numDimensions) {
            this.numDimensions = numDimensions;
            return (T)Cast.unchecked((Object)this);
        }

        public T sigmas(List<Double> sigmas) {
            this.sigmas = sigmas;
            return (T)Cast.unchecked((Object)this);
        }

        public T sigmas(double ... sigmas) {
            return this.sigmas(DoubleStream.of(sigmas).boxed().collect(Collectors.toList()));
        }

        public T pixelSize(List<Double> pixelSize) {
            this.pixelSize = pixelSize;
            return (T)Cast.unchecked((Object)this);
        }

        public T pixelSize(double ... pixelSize) {
            return this.pixelSize(DoubleStream.of(pixelSize).boxed().collect(Collectors.toList()));
        }

        public T sigmaRange(double minSigma, double maxSigma) {
            ArrayList<Double> sigmas = new ArrayList<Double>();
            for (double sigma = minSigma; sigma <= maxSigma; sigma *= 2.0) {
                sigmas.add(sigma);
            }
            this.sigmas(sigmas);
            return (T)Cast.unchecked((Object)this);
        }

        protected GlobalSettings buildGlobalSettings() {
            return new GlobalSettings(this.channelSetting, this.numDimensions, this.sigmas, this.pixelSize);
        }
    }
}

