/*
 * Decompiled with CFR 0.152.
 */
package volumeCalculator;

import ij.measure.Calibration;
import ij3d.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Tuple3f;

public class Volumes {
    private final String calibrationUnits;
    private final double volumeMultiplier;
    private int currentColorIndex = 0;
    private List<Double> volumes = new ArrayList<Double>();
    private List<Integer> voxelCounts = new ArrayList<Integer>();
    private List<Color3f> colors = new ArrayList<Color3f>();

    public Volumes(Calibration calibration) {
        this.calibrationUnits = calibration.getUnits();
        this.volumeMultiplier = calibration.pixelDepth * calibration.pixelHeight * calibration.pixelWidth;
    }

    public boolean addVolumeColor(Color chosenColor) {
        this.volumes.add(new Double(0.0));
        this.voxelCounts.add(new Integer(0));
        Color3f newColor = Utils.toColor3f((Color)chosenColor);
        for (Color3f color : this.colors) {
            if (!newColor.equals((Tuple3f)color)) continue;
            return false;
        }
        this.colors.add(Utils.toColor3f((Color)chosenColor));
        this.currentColorIndex = this.volumes.size() - 1;
        return true;
    }

    Color3f getSelectedColor() {
        return this.colors.get(this.currentColorIndex);
    }

    int getCurrentColorIndex() {
        return this.currentColorIndex;
    }

    void setCurrentColorIndex(int index) {
        this.currentColorIndex = index;
    }

    void updateVoxelCount(int colorIndex, int count) {
        if (colorIndex == 99) {
            return;
        }
        int voxelCount = this.voxelCounts.get(colorIndex) + count;
        this.voxelCounts.set(colorIndex, voxelCount);
        Double volume = this.volumes.get(colorIndex);
        this.volumes.set(colorIndex, (double)voxelCount * this.volumeMultiplier);
    }

    Double getVolumeAt(int colorIndex) {
        return this.volumes.get(colorIndex);
    }

    public String getCalibrationUnits() {
        return this.calibrationUnits;
    }

    Color3f getColorAt(int colorIndex) {
        return this.colors.get(colorIndex);
    }

    void clearVoxelCount(int colorIndex) {
        this.updateVoxelCount(colorIndex, -this.voxelCounts.get(colorIndex).intValue());
    }
}

