/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.utils;

import Jama.Matrix;
import ij.IJ;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;

public class Watershed {
    int[][] IM;
    ArrayList VERTEX = new ArrayList();
    ArrayList CELL = new ArrayList();
    ArrayList active_growth2 = new ArrayList();
    double[] CENTx;
    double[] CENTy;
    Matrix[] NEGB = new Matrix[8];
    int b_level;
    public int sx;
    public int sy;
    int sz;
    double Max_field;
    int n_basin;
    int n_vertex;
    double min_distance_between_vertices;
    int n_border_seeds;
    double A;
    double time;
    int[][] IM2;
    public int[][][] IMB;
    ImageProcessor image;

    public Watershed() {
        this.Max_field = 255.0;
        this.n_vertex = 0;
    }

    public Watershed(ImageProcessor imp) {
        int n = imp.getWidth();
        int m = imp.getHeight();
        this.Max_field = 255.0;
        this.n_vertex = 0;
        this.sx = n;
        this.sy = m;
        this.A = n * m;
        this.b_level = 0;
        this.IM2 = new int[this.sx + 1][this.sy + 1];
        this.IMB = new int[this.sx + 1][this.sy + 1][3];
        for (int i = 0; i < this.sx; ++i) {
            for (int j = 0; j < this.sy; ++j) {
                this.IM2[i][j] = Math.min(imp.getPixel(i, j), 254);
                this.IMB[i][j][0] = Math.min(imp.getPixel(i, j), 254);
            }
        }
        this.append_i2(0.0, 0.0, 0);
    }

    public void Flow_bound(int inc) {
        this.Flow_opt(this.b_level, this.b_level + inc);
        this.b_level += inc;
    }

    public void Flow(int init) {
        for (int i = 1; i < this.n_basin + 1; ++i) {
            double x = this.CENTx[i - 1];
            double y = this.CENTy[i - 1];
            this.append_i2(x, y, i);
        }
        this.Flow_opt(init, 255);
    }

    private void Flow_opt(int init, int stop_level) {
        boolean inc = false;
        boolean res = false;
        boolean res_loc = false;
        int max_iter = 0;
        for (int i = init; i < stop_level; ++i) {
            IJ.showStatus((String)("Watershed Finding bounds: " + (int)((double)i / (double)stop_level * 100.0) + "%"));
            double x = 0.0;
            ArrayList Vtmp = (ArrayList)this.active_growth2.get(i);
            int act_s = Vtmp.size();
            while (act_s > 0) {
                this.update_Wactive2(i);
                act_s = ((ArrayList)this.active_growth2.get(i)).size();
                ++max_iter;
            }
        }
        IJ.showStatus((String)"");
    }

    private int update_Wactive2(int level) {
        ArrayList lst = new ArrayList();
        lst = (ArrayList)((ArrayList)this.active_growth2.get(level)).clone();
        int stop = 1;
        int n = lst.size();
        ((ArrayList)this.active_growth2.get(level)).clear();
        int index = 0;
        for (int k = 0; k < n; ++k) {
            Matrix x = (Matrix)lst.get(k);
            int im = (int)x.get(0, 0);
            int jm = (int)x.get(0, 1);
            int basin = (int)x.get(0, 2);
            this.IM2[im][jm] = (basin + 1) * 1000;
            this.IMB[im][jm][0] = 255;
            this.neighbour(im, jm);
            for (int j = 0; j < 8; ++j) {
                int j0;
                Matrix negbi = this.NEGB[j];
                int i0 = (int)negbi.get(0, 1);
                if (!(this.IMB[i0][j0 = (int)negbi.get(0, 2)][2] < 499 & this.IM2[i0][j0] < 499)) continue;
                double[][] addedPoint = new double[][]{{i0, j0, basin}};
                ((ArrayList)this.active_growth2.get(Math.max(level, Math.min((int)negbi.get(0, 0), 255)))).add(new Matrix((double[][])addedPoint));
                if (Math.max(level, Math.min((int)negbi.get(0, 0), 255)) == 0) {
                    ++index;
                }
                if (this.IM2[i0][j0] >= 256) continue;
                this.A -= 1.0;
                this.IMB[i0][j0][2] = 500;
            }
        }
        return stop;
    }

    public void GetCenter(double[] u, double[] v) {
        this.CENTx = u;
        this.CENTy = v;
        this.n_basin = v.length;
    }

    private void append_i2(double x, double y, int k) {
        for (int i = 0; i < 256; ++i) {
            ArrayList row = new ArrayList();
            this.active_growth2.add(row);
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        r.add(new Integer(-1));
        this.CELL.add(r);
        ArrayList row = new ArrayList();
        if (k == 0) {
            int n_bseeds1 = 4;
            int n_edg = n_bseeds1 / 4 + 1;
            for (int i = 0; i < n_edg; ++i) {
                double[][] addedPoint1 = new double[][]{{i * this.sx / n_edg + 2, 4.0, 0.0}};
                int level = this.IM2[i * this.sx / n_edg + 2][4];
                Matrix MAT = new Matrix((double[][])addedPoint1);
                ((ArrayList)this.active_growth2.get(level)).add(MAT);
                double[][] addedPoint2 = new double[][]{{4.0, i * this.sy / n_edg + 2, 0.0}};
                level = this.IM2[4][i * this.sy / n_edg + 2];
                ((ArrayList)this.active_growth2.get(level)).add(new Matrix((double[][])addedPoint2));
                double[][] addedPoint3 = new double[][]{{i * this.sx / n_edg + 2, this.sy - 4, 0.0}};
                level = this.IM2[i * this.sx / n_edg + 2][this.sy - 4];
                ((ArrayList)this.active_growth2.get(level)).add(new Matrix((double[][])addedPoint3));
                double[][] addedPoint4 = new double[][]{{this.sx - 4, i * this.sy / n_edg + 2, 0.0}};
                level = this.IM2[this.sx - 4][i * this.sy / n_edg + 2];
                ((ArrayList)this.active_growth2.get(level)).add(new Matrix((double[][])addedPoint4));
                this.IMB[i * this.sx / n_edg + 2][4][2] = 500;
                this.IMB[4][i * this.sy / n_edg + 2][2] = 500;
                this.IMB[i * this.sx / n_edg + 2][this.sy - 4][2] = 500;
                this.IMB[this.sx - 4][i * this.sy / n_edg + 2][2] = 500;
            }
        } else {
            int level = Math.min(this.IM2[(int)x][(int)y], 255);
            double[][] addedPoint = new double[][]{{x, y, k}};
            ((ArrayList)this.active_growth2.get(level)).add(new Matrix((double[][])addedPoint));
            this.IMB[(int)x][(int)y][2] = 500;
        }
    }

    private void append_v(int x, int y, int[] LL) {
        int i;
        ArrayList r = new ArrayList();
        ArrayList<Integer> row = new ArrayList<Integer>();
        row.add(new Integer(x));
        row.add(new Integer(y));
        int Lsize = LL.length;
        for (i = 0; i < Lsize; ++i) {
            row.add(new Integer(LL[i]));
        }
        this.VERTEX.add(row);
        ++this.n_vertex;
        for (i = 0; i < Lsize; ++i) {
            if ((Integer)((ArrayList)this.CELL.get(LL[i] / 1000 - 1)).get(0) < 0) {
                r.add(new Integer(this.n_vertex - 1));
            } else {
                r = (ArrayList)this.CELL.get(LL[i] / 1000 - 1);
                r.add(new Integer(this.n_vertex - 1));
            }
            this.CELL.set(LL[i] / 1000 - 1, r);
            r.clear();
        }
    }

    private void neighbour(int i, int j) {
        if (i > 1 & j > 1 & i < this.sx - 1 & j < this.sy - 1) {
            double[][] addedPoint1 = new double[][]{{this.IM2[i - 1][j - 1], i - 1, j - 1}};
            this.NEGB[0] = new Matrix((double[][])addedPoint1);
            double[][] addedPoint2 = new double[][]{{this.IM2[i][j - 1], i, j - 1}};
            this.NEGB[1] = new Matrix((double[][])addedPoint2);
            double[][] addedPoint3 = new double[][]{{this.IM2[i + 1][j - 1], i + 1, j - 1}};
            this.NEGB[2] = new Matrix((double[][])addedPoint3);
            double[][] addedPoint4 = new double[][]{{this.IM2[i + 1][j], i + 1, j}};
            this.NEGB[3] = new Matrix((double[][])addedPoint4);
            double[][] addedPoint5 = new double[][]{{this.IM2[i + 1][j + 1], i + 1, j + 1}};
            this.NEGB[4] = new Matrix((double[][])addedPoint5);
            double[][] addedPoint6 = new double[][]{{this.IM2[i][j + 1], i, j + 1}};
            this.NEGB[5] = new Matrix((double[][])addedPoint6);
            double[][] addedPoint7 = new double[][]{{this.IM2[i - 1][j + 1], i - 1, j + 1}};
            this.NEGB[6] = new Matrix((double[][])addedPoint7);
            double[][] addedPoint8 = new double[][]{{this.IM2[i - 1][j], i - 1, j}};
            this.NEGB[7] = new Matrix((double[][])addedPoint8);
        } else {
            double[][] addedPoint1 = new double[][]{{263.0, i - 1, j - 1}};
            this.NEGB[0] = new Matrix((double[][])addedPoint1);
            double[][] addedPoint2 = new double[][]{{263.0, i, j - 1}};
            this.NEGB[1] = new Matrix((double[][])addedPoint2);
            double[][] addedPoint3 = new double[][]{{263.0, i + 1, j - 1}};
            this.NEGB[2] = new Matrix((double[][])addedPoint3);
            double[][] addedPoint4 = new double[][]{{263.0, i + 1, j}};
            this.NEGB[3] = new Matrix((double[][])addedPoint4);
            double[][] addedPoint5 = new double[][]{{263.0, i + 1, j + 1}};
            this.NEGB[4] = new Matrix((double[][])addedPoint5);
            double[][] addedPoint6 = new double[][]{{263.0, i, j + 1}};
            this.NEGB[5] = new Matrix((double[][])addedPoint6);
            double[][] addedPoint7 = new double[][]{{263.0, i - 1, j + 1}};
            this.NEGB[6] = new Matrix((double[][])addedPoint7);
            double[][] addedPoint8 = new double[][]{{263.0, i - 1, j}};
            this.NEGB[7] = new Matrix((double[][])addedPoint8);
        }
    }

    private int[] _sort(int ii, int jj) {
        ArrayList<Integer> row = new ArrayList<Integer>();
        int LI = this.IM2[ii][jj];
        if ((double)LI > this.Max_field) {
            row.add(new Integer(LI));
        }
        for (int i = 0; i < 8; ++i) {
            Matrix x = this.NEGB[i];
            if (!(x.get(0, 0) > this.Max_field + 20.0)) continue;
            int n = row.size();
            boolean add = true;
            for (int j = 0; j < n; ++j) {
                if ((int)x.get(0, 0) != (Integer)row.get(j)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            row.add(new Integer((int)x.get(0, 0)));
        }
        int[] Rrow = new int[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            Rrow[i] = (Integer)row.get(i);
        }
        Arrays.sort(Rrow);
        return Rrow;
    }
}

