/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.openconnectome;

import bdv.img.openconnectome.OpenConnectomeDataset;
import bdv.img.openconnectome.OpenConnectomeProject;
import java.io.Serializable;
import net.imglib2.realtransform.AffineTransform3D;

public class OpenConnectomeTokenInfo
implements Serializable {
    private static final long serialVersionUID = -560051267067033900L;
    public OpenConnectomeDataset dataset;
    public OpenConnectomeProject project;

    public long[][] getLevelDimensions(String mode) {
        int i;
        long[][] levelDimensions = new long[this.dataset.resolutions.length][3];
        double[][] offsets = this.getOffsets(mode);
        if (mode.equals("neariso")) {
            for (i = 0; i < this.dataset.resolutions.length; ++i) {
                levelDimensions[i] = (long[])this.dataset.neariso_imagesize.get(new Integer(this.dataset.resolutions[i]).toString()).clone();
            }
        } else {
            for (i = 0; i < this.dataset.resolutions.length; ++i) {
                levelDimensions[i] = (long[])this.dataset.imagesize.get(new Integer(this.dataset.resolutions[i]).toString()).clone();
            }
        }
        for (i = 0; i < this.dataset.resolutions.length; ++i) {
            long[] lArray = levelDimensions[i];
            lArray[2] = (long)((double)lArray[2] - offsets[i][2]);
        }
        return levelDimensions;
    }

    public int[][] getLevelCellDimensions() {
        int[][] levelCellDimensions = new int[this.dataset.cube_dimension.size()][];
        for (int i = 0; i < this.dataset.resolutions.length; ++i) {
            levelCellDimensions[i] = (int[])this.dataset.cube_dimension.get(new Integer(this.dataset.resolutions[i]).toString()).clone();
        }
        return levelCellDimensions;
    }

    public double[][] getLevelScales(String mode) {
        double[][] levelScales = new double[this.dataset.resolutions.length][];
        boolean neariso = mode.equals("neariso");
        for (int i = 0; i < this.dataset.resolutions.length; ++i) {
            long[] voxelres = neariso ? this.dataset.neariso_voxelres.get(new Integer(this.dataset.resolutions[i]).toString()) : this.dataset.voxelres.get(new Integer(this.dataset.resolutions[i]).toString());
            levelScales[i] = new double[]{voxelres[0], voxelres[1], voxelres[2]};
        }
        return levelScales;
    }

    public double[][] getOffsets(String mode) {
        double[][] offsets = new double[this.dataset.resolutions.length][3];
        if (mode.equals("neariso")) {
            for (int i = 0; i < this.dataset.resolutions.length; ++i) {
                offsets[i] = (double[])this.dataset.neariso_offset.get(new Integer(this.dataset.resolutions[i]).toString()).clone();
            }
        } else {
            for (int i = 0; i < this.dataset.resolutions.length; ++i) {
                offsets[i] = (double[])this.dataset.offset.get(new Integer(this.dataset.resolutions[i]).toString()).clone();
            }
        }
        return offsets;
    }

    public AffineTransform3D[] getLevelTransforms(String mode) {
        AffineTransform3D[] levelTransforms = new AffineTransform3D[this.dataset.resolutions.length];
        double[][] levelScales = this.getLevelScales(mode);
        for (int i = 0; i < this.dataset.resolutions.length; ++i) {
            double[] levelScale = levelScales[i];
            AffineTransform3D levelTransform = new AffineTransform3D();
            levelTransform.set(levelScale[0], 0, 0);
            levelTransform.set(levelScale[1], 1, 1);
            levelTransform.set(levelScale[2], 2, 2);
            levelTransform.set(-0.5 * (levelScale[0] - 1.0), 0, 3);
            levelTransform.set(-0.5 * (levelScale[1] - 1.0), 1, 3);
            levelTransform.set(0.5 * (levelScale[1] - 1.0), 2, 3);
            levelTransforms[i] = levelTransform;
        }
        return levelTransforms;
    }
}

