/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

public final class Bounds {
    private final double minBound;
    private final double maxBound;

    public Bounds(double minBound, double maxBound) {
        if (minBound > maxBound) {
            throw new IllegalArgumentException();
        }
        this.minBound = minBound;
        this.maxBound = maxBound;
    }

    public double getMinBound() {
        return this.minBound;
    }

    public double getMaxBound() {
        return this.maxBound;
    }

    public Bounds join(Bounds other) {
        double newMinBound = Math.min(this.minBound, other.minBound);
        double newMaxBound = Math.max(this.maxBound, other.maxBound);
        return new Bounds(newMinBound, newMaxBound);
    }

    public String toString() {
        return "Bounds[ " + this.minBound + ", " + this.maxBound + " ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bounds that = (Bounds)o;
        if (Double.compare(that.minBound, this.minBound) != 0) {
            return false;
        }
        return Double.compare(that.maxBound, this.maxBound) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minBound);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

