/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.converter.Converter;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.UnsignedShortType;

public class UnsignedShortLUTConverter<T extends AbstractIntegerType<T>>
implements Converter<T, UnsignedShortType>,
BiConsumer<T, UnsignedShortType> {
    private Map<T, Integer> lut;

    public UnsignedShortLUTConverter(Map<T, Integer> lut) {
        this.lut = lut;
    }

    public UnsignedShortLUTConverter(IterableInterval<T> img) {
        TreeSet<AbstractIntegerType> values = UnsignedShortLUTConverter.uniqueValues(img);
        this.lut = new HashMap<T, Integer>();
        int i = 0;
        for (AbstractIntegerType t : values) {
            this.lut.put(t, i++);
        }
    }

    public static <T extends AbstractIntegerType<T>> TreeSet<T> uniqueValues(IterableInterval<T> img) {
        TreeSet<Type> uniqueValues = new TreeSet<Type>();
        Cursor c = img.cursor();
        while (c.hasNext()) {
            uniqueValues.add(((AbstractIntegerType)c.next()).copy());
        }
        return uniqueValues;
    }

    @Override
    public void accept(T t, UnsignedShortType out) {
        this.convert(t, out);
    }

    public void convert(T t, UnsignedShortType output) {
        output.setInteger(this.lut.get(t).intValue());
    }
}

