/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import com.google.gson.Gson;
import java.awt.Component;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;
import org.janelia.saalfeldlab.n5.universe.translation.TranslatedN5Reader;

public class N5MetadataTranslationPanel {
    private static final String DEFAULT_TEXT = "include \"n5\";";
    private float fontScale = 1.0f;
    private JTextArea textArea;
    private Predicate<CanonicalMetadata> filter;

    public N5MetadataTranslationPanel() {
    }

    public N5MetadataTranslationPanel(float fontScale) {
        this.fontScale = fontScale;
    }

    public void setFilter(Predicate<CanonicalMetadata> filter) {
        this.filter = filter;
    }

    public TranslatedN5Reader getTranslatedN5(N5Reader n5, Gson gson) {
        TranslatedN5Reader translatedN5 = new TranslatedN5Reader(n5, gson, this.textArea.getText(), ".");
        if (translatedN5.getTranslation().getTranslationFunction().isValid()) {
            return translatedN5;
        }
        return null;
    }

    public Optional<TranslatedN5Reader> getTranslatedN5Optional(N5Reader n5, Gson gson) {
        if (this.isTranslationProvided()) {
            return Optional.ofNullable(this.getTranslatedN5(n5, gson));
        }
        return Optional.empty();
    }

    public boolean isTranslationProvided() {
        if (this.textArea == null) {
            return false;
        }
        String txt = this.textArea.getText();
        boolean textSet = !txt.isEmpty() && !txt.equals(DEFAULT_TEXT);
        return textSet;
    }

    public JPanel buildPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Translation specification"));
        this.textArea = new JTextArea();
        this.textArea.setFont(this.textArea.getFont().deriveFont(this.fontScale * 18.0f));
        this.textArea.setText(DEFAULT_TEXT);
        JScrollPane textView = new JScrollPane(this.textArea);
        panel.add((Component)textView, "Center");
        return panel;
    }
}

