/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.algorithm.tree.Forest;
import net.imglib2.algorithm.tree.TreeNode;

public class TreeUtils {
    public static <T extends TreeNode<T>> ArrayList<T> getLeafs(Forest<T> forest) {
        ArrayList<TreeNode> leafs = new ArrayList<TreeNode>();
        ArrayDeque<T> nodes = new ArrayDeque<T>(forest.roots());
        while (!nodes.isEmpty()) {
            TreeNode node = (TreeNode)nodes.remove();
            List children = node.getChildren();
            if (children.isEmpty()) {
                leafs.add(node);
                continue;
            }
            nodes.addAll(children);
        }
        return leafs;
    }

    public static <T extends TreeNode<T>> void forEach(Forest<T> forest, Consumer<T> op) {
        ArrayDeque<T> nodes = new ArrayDeque<T>(forest.roots());
        while (!nodes.isEmpty()) {
            TreeNode node = (TreeNode)nodes.remove();
            op.accept(node);
            List children = node.getChildren();
            if (children.isEmpty()) continue;
            nodes.addAll(children);
        }
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

