/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer;

import bdv.BigDataViewer;
import bdv.export.ProgressWriter;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.tools.InitializeViewerState;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.DisplayMode;
import bdv.viewer.ViewerOptions;
import bdv.viewer.VisibilityAndGrouping;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.XmlIoAbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.type.numeric.ARGBType;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.SelectedViewDescriptionListener;
import spim.fiji.spimdata.explorer.ViewSetupExplorer;
import spim.fiji.spimdata.explorer.ViewSetupExplorerInfoBox;
import spim.fiji.spimdata.explorer.ViewSetupTableModel;
import spim.fiji.spimdata.explorer.popup.ApplyTransformationPopup;
import spim.fiji.spimdata.explorer.popup.BDVPopup;
import spim.fiji.spimdata.explorer.popup.BakeManualTransformationPopup;
import spim.fiji.spimdata.explorer.popup.BoundingBoxPopup;
import spim.fiji.spimdata.explorer.popup.DetectInterestPointsPopup;
import spim.fiji.spimdata.explorer.popup.DisplayViewPopup;
import spim.fiji.spimdata.explorer.popup.FusionPopup;
import spim.fiji.spimdata.explorer.popup.InterestPointsExplorerPopup;
import spim.fiji.spimdata.explorer.popup.LabelPopUp;
import spim.fiji.spimdata.explorer.popup.MaxProjectPopup;
import spim.fiji.spimdata.explorer.popup.RegisterInterestPointsPopup;
import spim.fiji.spimdata.explorer.popup.RegistrationExplorerPopup;
import spim.fiji.spimdata.explorer.popup.RemoveDetectionsPopup;
import spim.fiji.spimdata.explorer.popup.RemoveTransformationPopup;
import spim.fiji.spimdata.explorer.popup.ReorientSamplePopup;
import spim.fiji.spimdata.explorer.popup.ResavePopup;
import spim.fiji.spimdata.explorer.popup.Separator;
import spim.fiji.spimdata.explorer.popup.SpecifyCalibrationPopup;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;
import spim.fiji.spimdata.explorer.popup.VisualizeDetectionsPopup;
import spim.fiji.spimdata.explorer.util.ColorStream;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class ViewSetupExplorerPanel<AS extends AbstractSpimData<?>, X extends XmlIoAbstractSpimData<?, AS>>
extends JPanel {
    static final ArrayList<ViewExplorerSetable> staticPopups = new ArrayList();
    private static final long serialVersionUID = -3767947754096099774L;
    protected JTable table;
    protected ViewSetupTableModel<AS> tableModel;
    protected ArrayList<SelectedViewDescriptionListener<AS>> listeners;
    protected AS data;
    protected ViewSetupExplorer<AS, X> explorer;
    final String xml;
    final X io;
    final boolean isMac;
    protected boolean colorMode = true;
    protected final HashSet<BasicViewDescription<? extends BasicViewSetup>> selectedRows;
    protected BasicViewDescription<? extends BasicViewSetup> firstSelectedVD;

    public ViewSetupExplorerPanel(ViewSetupExplorer<AS, X> explorer, AS data, String xml, X io) {
        BDVPopup bdvpopup;
        this.explorer = explorer;
        this.listeners = new ArrayList();
        this.data = data;
        this.xml = xml.replace("\\", "/").replace("//", "/").replace("/./", "/");
        this.io = io;
        this.isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        this.selectedRows = new HashSet();
        this.firstSelectedVD = null;
        this.initComponent();
        if (Hdf5ImageLoader.class.isInstance(data.getSequenceDescription().getImgLoader()) && (bdvpopup = ViewSetupExplorerPanel.bdvPopup()) != null) {
            bdvpopup.bdv = BigDataViewer.open(this.getSpimData(), (String)this.xml(), (ProgressWriter)IOFunctions.getProgressWriter(), (ViewerOptions)ViewerOptions.options());
            InitializeViewerState.initBrightness((double)0.001, (double)0.999, (AbstractViewerPanel)bdvpopup.bdv.getViewer(), (SetupAssignments)bdvpopup.bdv.getSetupAssignments());
            BDVPopup.initTransform(bdvpopup.bdv.getViewer());
            ViewSetupExplorerPanel.setFusedModeSimple(bdvpopup.bdv, data);
        }
    }

    public static BDVPopup bdvPopup() {
        for (ViewExplorerSetable s : staticPopups) {
            if (!BDVPopup.class.isInstance(s)) continue;
            return (BDVPopup)s;
        }
        return null;
    }

    public boolean colorMode() {
        return this.colorMode;
    }

    public BasicViewDescription<? extends BasicViewSetup> firstSelectedVD() {
        return this.firstSelectedVD;
    }

    public ViewSetupTableModel<AS> getTableModel() {
        return this.tableModel;
    }

    public AS getSpimData() {
        return this.data;
    }

    public String xml() {
        return this.xml;
    }

    public X io() {
        return this.io;
    }

    public ViewSetupExplorer<AS, X> explorer() {
        return this.explorer;
    }

    public void setSpimData(Object data) {
        this.data = (AbstractSpimData)data;
    }

    public void updateContent() {
        this.getTableModel().fireTableDataChanged();
        for (SelectedViewDescriptionListener<AS> l : this.listeners) {
            l.updateContent(this.data);
        }
    }

    public List<BasicViewDescription<? extends BasicViewSetup>> selectedRows() {
        ArrayList<BasicViewDescription<? extends BasicViewSetup>> list = new ArrayList<BasicViewDescription<? extends BasicViewSetup>>();
        list.addAll(this.selectedRows);
        Collections.sort(list);
        return list;
    }

    public List<ViewId> selectedRowsViewId() {
        ArrayList<ViewId> list = new ArrayList<ViewId>();
        list.addAll(this.selectedRows);
        Collections.sort(list);
        return list;
    }

    public void addListener(SelectedViewDescriptionListener<AS> listener) {
        this.listeners.add(listener);
        if (this.table.getSelectedRow() != -1) {
            listener.seletedViewDescription(this.tableModel.getElements().get(this.table.getSelectedRow()));
        }
    }

    public ArrayList<SelectedViewDescriptionListener<AS>> getListeners() {
        return this.listeners;
    }

    public void initComponent() {
        this.tableModel = new ViewSetupTableModel(this);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setSelectionMode(2);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
            this.table.getColumnModel().getColumn(column).setCellRenderer(centerRenderer);
        }
        this.table.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index = ViewSetupExplorerPanel.this.table.convertColumnIndexToModel(ViewSetupExplorerPanel.this.table.columnAtPoint(mouseEvent.getPoint()));
                if (index >= 0) {
                    int row = ViewSetupExplorerPanel.this.table.getSelectedRow();
                    ViewSetupExplorerPanel.this.tableModel.sortByColumn(index);
                    ViewSetupExplorerPanel.this.table.clearSelection();
                    ViewSetupExplorerPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        if (this.isMac) {
            this.addAppleA();
        }
        this.addColorMode();
        this.table.setPreferredScrollableViewportSize(new Dimension(750, 300));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(this.tableModel.registrationColumn()).setPreferredWidth(25);
        if (this.tableModel.interestPointsColumn() >= 0) {
            this.table.getColumnModel().getColumn(this.tableModel.interestPointsColumn()).setPreferredWidth(30);
        }
        this.setLayout(new BorderLayout());
        final JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (save.isEnabled()) {
                    ViewSetupExplorerPanel.this.saveXML();
                }
            }
        });
        final JButton info = new JButton("Info");
        info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (info.isEnabled()) {
                    ViewSetupExplorerPanel.this.showInfoBox();
                }
            }
        });
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.add((Component)info, "West");
        buttons.add((Component)save, "East");
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)new JLabel("XML: " + this.xml), "West");
        header.add((Component)buttons, "East");
        this.add((Component)header, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.addPopupMenu(this.table);
    }

    protected ListSelectionListener getSelectionListener() {
        return new ListSelectionListener(){
            int lastRow = -1;

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                BDVPopup b = ViewSetupExplorerPanel.bdvPopup();
                if (ViewSetupExplorerPanel.this.table.getSelectedRowCount() != 1) {
                    this.lastRow = -1;
                    for (int i = 0; i < ViewSetupExplorerPanel.this.listeners.size(); ++i) {
                        ViewSetupExplorerPanel.this.listeners.get(i).seletedViewDescription(null);
                    }
                    ViewSetupExplorerPanel.this.selectedRows.clear();
                    ViewSetupExplorerPanel.this.firstSelectedVD = null;
                    for (int row : ViewSetupExplorerPanel.this.table.getSelectedRows()) {
                        if (ViewSetupExplorerPanel.this.firstSelectedVD == null) {
                            ViewSetupExplorerPanel.this.firstSelectedVD = ViewSetupExplorerPanel.this.tableModel.getElements().get(row);
                        }
                        ViewSetupExplorerPanel.this.selectedRows.add(ViewSetupExplorerPanel.this.tableModel.getElements().get(row));
                    }
                } else {
                    int row = ViewSetupExplorerPanel.this.table.getSelectedRow();
                    if (row != this.lastRow && row >= 0 && row < ViewSetupExplorerPanel.this.tableModel.getRowCount()) {
                        this.lastRow = row;
                        BasicViewDescription<BasicViewSetup> vd = ViewSetupExplorerPanel.this.tableModel.getElements().get(row);
                        for (int i = 0; i < ViewSetupExplorerPanel.this.listeners.size(); ++i) {
                            ViewSetupExplorerPanel.this.listeners.get(i).seletedViewDescription(vd);
                        }
                        ViewSetupExplorerPanel.this.selectedRows.clear();
                        ViewSetupExplorerPanel.this.selectedRows.add(vd);
                        ViewSetupExplorerPanel.this.firstSelectedVD = vd;
                    }
                }
                if (b != null && b.bdv != null) {
                    ViewSetupExplorerPanel.updateBDV(b.bdv, ViewSetupExplorerPanel.this.colorMode, ViewSetupExplorerPanel.this.data, ViewSetupExplorerPanel.this.firstSelectedVD, ViewSetupExplorerPanel.this.selectedRows);
                }
            }
        };
    }

    public static void updateBDV(BigDataViewer bdv, boolean colorMode, AbstractSpimData<?> data, BasicViewDescription<? extends BasicViewSetup> firstVD, Collection<? extends BasicViewDescription<? extends BasicViewSetup>> selectedRows) {
        ViewSetupExplorerPanel.setFusedModeSimple(bdv, data);
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        if (firstVD == null) {
            firstVD = selectedRows.iterator().next();
        }
        TimePoint firstTP = firstVD.getTimePoint();
        bdv.getViewer().setTimepoint(ViewSetupExplorerPanel.getBDVTimePointIndex(firstTP, data));
        boolean[] active = new boolean[data.getSequenceDescription().getViewSetupsOrdered().size()];
        for (BasicViewDescription<? extends BasicViewSetup> basicViewDescription : selectedRows) {
            if (basicViewDescription.getTimePointId() != firstTP.getId()) continue;
            active[ViewSetupExplorerPanel.getBDVSourceIndex((BasicViewSetup)basicViewDescription.getViewSetup(), data)] = true;
        }
        if (selectedRows.size() > 1 && colorMode) {
            ViewSetupExplorerPanel.colorSources(bdv.getSetupAssignments().getConverterSetups(), 0L);
        } else {
            ViewSetupExplorerPanel.whiteSources(bdv.getSetupAssignments().getConverterSetups());
        }
        ViewSetupExplorerPanel.setVisibleSources(bdv.getViewer().getVisibilityAndGrouping(), active);
    }

    public static void setFusedModeSimple(BigDataViewer bdv, AbstractSpimData<?> data) {
        if (bdv == null) {
            return;
        }
        if (bdv.getViewer().getVisibilityAndGrouping().getDisplayMode() != DisplayMode.FUSED) {
            boolean[] active = new boolean[data.getSequenceDescription().getViewSetupsOrdered().size()];
            active[0] = true;
            ViewSetupExplorerPanel.setVisibleSources(bdv.getViewer().getVisibilityAndGrouping(), active);
            bdv.getViewer().getVisibilityAndGrouping().setDisplayMode(DisplayMode.FUSED);
        }
    }

    public static void colorSources(List<ConverterSetup> cs, long j) {
        for (int i = 0; i < cs.size(); ++i) {
            cs.get(i).setColor(new ARGBType(ColorStream.get((long)i + j)));
        }
    }

    public static void whiteSources(List<ConverterSetup> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            cs.get(i).setColor(new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)0)));
        }
    }

    public static void setVisibleSources(VisibilityAndGrouping vag, boolean[] active) {
        for (int i = 0; i < active.length; ++i) {
            vag.setSourceActive(i, active[i]);
        }
    }

    public static int getBDVTimePointIndex(TimePoint t, AbstractSpimData<?> data) {
        List list = data.getSequenceDescription().getTimePoints().getTimePointsOrdered();
        for (int i = 0; i < list.size(); ++i) {
            if (((TimePoint)list.get(i)).getId() != t.getId()) continue;
            return i;
        }
        return 0;
    }

    public static int getBDVSourceIndex(BasicViewSetup vs, AbstractSpimData<?> data) {
        List list = data.getSequenceDescription().getViewSetupsOrdered();
        for (int i = 0; i < list.size(); ++i) {
            if (((BasicViewSetup)list.get(i)).getId() != vs.getId()) continue;
            return i;
        }
        return 0;
    }

    public HashSet<BasicViewDescription<? extends BasicViewSetup>> getSelectedRows() {
        return this.selectedRows;
    }

    public void showInfoBox() {
        new ViewSetupExplorerInfoBox<AS>(this.data, this.xml);
    }

    public void saveXML() {
        try {
            this.io.save(this.data, this.xml);
            for (SelectedViewDescriptionListener<AS> l : this.listeners) {
                l.save();
            }
            if (SpimData2.class.isInstance(this.data)) {
                ViewInterestPoints vip = ((SpimData2)((Object)this.data)).getViewInterestPoints();
                for (ViewInterestPointLists vipl : vip.getViewInterestPoints().values()) {
                    for (String label : vipl.getHashMap().keySet()) {
                        InterestPointList ipl = vipl.getInterestPointList(label);
                        if (ipl.getInterestPoints() == null) {
                            ipl.loadInterestPoints();
                        }
                        ipl.saveInterestPoints();
                        if (ipl.getCorrespondingInterestPoints() == null) {
                            ipl.loadCorrespondingInterestPoints();
                        }
                        ipl.saveCorrespondingInterestPoints();
                    }
                }
            }
            IOFunctions.println("Saved XML '" + this.xml + "'.");
        }
        catch (SpimDataException e) {
            IOFunctions.println("Failed to save XML '" + this.xml + "': " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    protected void addPopupMenu(JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        for (ViewExplorerSetable item : staticPopups) {
            popupMenu.add(item.setViewExplorer(this));
        }
        table.setComponentPopupMenu(popupMenu);
    }

    protected void addColorMode() {
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == 'c' || arg0.getKeyChar() == 'C') {
                    ViewSetupExplorerPanel.this.colorMode = !ViewSetupExplorerPanel.this.colorMode;
                    System.out.println("colormode");
                    BDVPopup p = ViewSetupExplorerPanel.bdvPopup();
                    if (p != null && p.bdv != null && p.bdv.getViewerFrame().isVisible()) {
                        ViewSetupExplorerPanel.updateBDV(p.bdv, ViewSetupExplorerPanel.this.colorMode, ViewSetupExplorerPanel.this.data, null, ViewSetupExplorerPanel.this.selectedRows);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
    }

    protected void addAppleA() {
        this.table.addKeyListener(new KeyListener(){
            boolean appleKeyDown = false;

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (this.appleKeyDown && arg0.getKeyChar() == 'a') {
                    ViewSetupExplorerPanel.this.table.selectAll();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 157) {
                    this.appleKeyDown = false;
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 157) {
                    this.appleKeyDown = true;
                }
            }
        });
    }

    static {
        IOFunctions.printIJLog = true;
        staticPopups.add(new LabelPopUp(" Displaying"));
        staticPopups.add(new BDVPopup());
        staticPopups.add(new DisplayViewPopup());
        staticPopups.add(new MaxProjectPopup());
        staticPopups.add(new Separator());
        staticPopups.add(new LabelPopUp(" Processing"));
        staticPopups.add(new DetectInterestPointsPopup());
        staticPopups.add(new RegisterInterestPointsPopup());
        staticPopups.add(new BoundingBoxPopup());
        staticPopups.add(new FusionPopup());
        staticPopups.add(new Separator());
        staticPopups.add(new LabelPopUp(" Calibration/Transformations"));
        staticPopups.add(new RegistrationExplorerPopup());
        staticPopups.add(new SpecifyCalibrationPopup());
        staticPopups.add(new ApplyTransformationPopup());
        staticPopups.add(new BakeManualTransformationPopup());
        staticPopups.add(new RemoveTransformationPopup());
        staticPopups.add(new ReorientSamplePopup());
        staticPopups.add(new Separator());
        staticPopups.add(new LabelPopUp(" Interest Points"));
        staticPopups.add(new InterestPointsExplorerPopup());
        staticPopups.add(new VisualizeDetectionsPopup());
        staticPopups.add(new RemoveDetectionsPopup());
        staticPopups.add(new Separator());
        staticPopups.add(new LabelPopUp(" Modifications"));
        staticPopups.add(new ResavePopup());
    }
}

