/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import ij.gui.GenericDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.resave.Generic_Resave_HDF5;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.plugin.resave.Resave_HDF5;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;

public class ExportSpimData2HDF5
implements ImgExport {
    private List<TimePoint> newTimepoints;
    private List<ViewSetup> newViewSetups;
    private Generic_Resave_HDF5.Parameters params;
    private SpimData2 spimData;
    private Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo;
    private HashMap<ViewId, Partition> viewIdToPartition;
    private final ProgressWriter progressWriter = new ProgressWriterIJ();

    @Override
    public boolean finish() {
        System.out.println("finish()");
        String path = this.params.getSeqFile().getAbsolutePath();
        try {
            new XmlIoSpimData2("").save(this.spimData, path);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + path + "'.");
            return false;
        }
        catch (SpimDataException e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + path + "'.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setXMLData(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups) {
        System.out.println("setXMLData()");
        this.newTimepoints = newTimepoints;
        this.newViewSetups = newViewSetups;
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        System.out.println("queryParameters()");
        if (this.newTimepoints == null || this.newViewSetups == null) {
            IOFunctions.println("new timepoints and new viewsetup list not set yet ... cannot continue");
            return false;
        }
        this.perSetupExportMipmapInfo = Resave_HDF5.proposeMipmaps(this.newViewSetups);
        String fn = LoadParseQueryXML.defaultXMLfilename;
        if (fn.endsWith(".xml")) {
            fn = fn.substring(0, fn.length() - ".xml".length());
        }
        int i = 0;
        while (new File(Generic_Resave_HDF5.lastExportPath = String.format("%s-f%d.xml", fn, i)).exists()) {
            ++i;
        }
        int firstviewSetupId = this.newViewSetups.get(0).getId();
        this.params = Generic_Resave_HDF5.getParameters(this.perSetupExportMipmapInfo.get(firstviewSetupId), true, this.getDescription(), is16bit);
        if (this.params == null) {
            System.out.println("abort ");
            return false;
        }
        Pair<SpimData2, HashMap<ViewId, Partition>> init = ExportSpimData2HDF5.initSpimData(this.newTimepoints, this.newViewSetups, this.params, this.perSetupExportMipmapInfo);
        this.spimData = (SpimData2)((Object)init.getA());
        this.viewIdToPartition = (HashMap)init.getB();
        return true;
    }

    protected static Pair<SpimData2, HashMap<ViewId, Partition>> initSpimData(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups, Generic_Resave_HDF5.Parameters params, Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo) {
        SequenceDescription seq = new SequenceDescription(new TimePoints(newTimepoints), newViewSetups, null, null);
        HashMap<ViewDescription, ViewRegistration> regMap = new HashMap<ViewDescription, ViewRegistration>();
        for (ViewDescription vDesc : seq.getViewDescriptions().values()) {
            regMap.put(vDesc, new ViewRegistration(vDesc.getTimePointId(), vDesc.getViewSetupId()));
        }
        ViewRegistrations viewRegistrations = new ViewRegistrations(regMap);
        ViewInterestPoints viewsInterestPoints = new ViewInterestPoints(new HashMap<ViewId, ViewInterestPointLists>());
        File basePath = params.getSeqFile().getParentFile();
        ArrayList hdf5Partitions = null;
        HashMap<ViewDescription, Partition> viewIdToPartition = new HashMap<ViewDescription, Partition>();
        if (params.getSplit()) {
            String basename = params.getHDF5File().getAbsolutePath();
            if (basename.endsWith(".h5")) {
                basename = basename.substring(0, basename.length() - ".h5".length());
            }
            hdf5Partitions = Partition.split(newTimepoints, newViewSetups, (int)params.getTimepointsPerPartition(), (int)params.getSetupsPerPartition(), (String)basename);
            block1: for (ViewDescription viewDescription : seq.getViewDescriptions().values()) {
                for (Partition p : hdf5Partitions) {
                    if (!p.contains((ViewId)viewDescription)) continue;
                    viewIdToPartition.put(viewDescription, p);
                    continue block1;
                }
            }
            WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (ArrayList)hdf5Partitions, (File)params.getHDF5File());
        } else {
            HashMap<Integer, Integer> timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
            for (TimePoint timePoint : newTimepoints) {
                timepointIdSequenceToPartition.put(timePoint.getId(), timePoint.getId());
            }
            HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
            for (ViewSetup setup : newViewSetups) {
                setupIdSequenceToPartition.put(setup.getId(), setup.getId());
            }
            Partition partition = new Partition(params.getHDF5File().getAbsolutePath(), timepointIdSequenceToPartition, setupIdSequenceToPartition);
            for (ViewDescription vDesc : seq.getViewDescriptions().values()) {
                viewIdToPartition.put(vDesc, partition);
            }
        }
        seq.setImgLoader((BasicImgLoader)new Hdf5ImageLoader(params.getHDF5File(), hdf5Partitions, (AbstractSequenceDescription)seq, false));
        SpimData2 spimData = new SpimData2(basePath, seq, viewRegistrations, viewsInterestPoints, new BoundingBoxes());
        return new ValuePair((Object)spimData, viewIdToPartition);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        System.out.println("exportImage1()");
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    public static <T extends RealType<T>> double[] updateAndGetMinMax(RandomAccessibleInterval<T> img, Generic_Resave_HDF5.Parameters params) {
        double max;
        double min;
        if (params == null || params.getConvertChoice() == 0 || Double.isNaN(params.getMin()) || Double.isNaN(params.getMin())) {
            float[] minmax = FusionHelper.minMax(img);
            min = minmax[0];
            max = minmax[1];
            min = Math.max(0.0, min - (min + max) / 2.0 * 0.1);
            max += (min + max) / 2.0 * 0.1;
            if (params != null) {
                params.setMin(min);
                params.setMax(max);
            }
        } else {
            min = params.getMin();
            max = params.getMax();
        }
        IOFunctions.println("Min intensity for 16bit conversion: " + min);
        IOFunctions.println("Max intensity for 16bit conversion: " + max);
        return new double[]{min, max};
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<UnsignedShortType> convert(RandomAccessibleInterval<T> img, Generic_Resave_HDF5.Parameters params) {
        double[] minmax = ExportSpimData2HDF5.updateAndGetMinMax(img, params);
        RealUnsignedShortConverter converter = new RealUnsignedShortConverter(minmax[0], minmax[1]);
        return new ConvertedRandomAccessibleInterval(img, (Converter)converter, UnsignedShortType::new);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        System.out.println("exportImage2()");
        Object ushortimg = !UnsignedShortType.class.isInstance(Util.getTypeFromInterval(img)) ? ExportSpimData2HDF5.convert(img, this.params) : img;
        Partition partition = this.viewIdToPartition.get(new ViewId(tp.getId(), vs.getId()));
        ExportMipmapInfo mipmapInfo = this.perSetupExportMipmapInfo.get(vs.getId());
        boolean writeMipmapInfo = true;
        boolean deflate = this.params.getDeflate();
        SubTaskProgressWriter progressWriter = new SubTaskProgressWriter(this.progressWriter, 0.0, 1.0);
        int numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        WriteSequenceToHdf5.writeViewToHdf5PartitionFile(ushortimg, (Partition)partition, (int)tp.getId(), (int)vs.getId(), (ExportMipmapInfo)mipmapInfo, (boolean)true, (boolean)deflate, null, null, (int)numThreads, (ProgressWriter)progressWriter);
        ViewRegistration vr = this.spimData.getViewRegistrations().getViewRegistration(new ViewId(tp.getId(), vs.getId()));
        double scale = bb.getDownSampling();
        AffineTransform3D m = new AffineTransform3D();
        m.set(scale, 0.0, 0.0, (double)bb.min(0), 0.0, scale, 0.0, (double)bb.min(1), 0.0, 0.0, scale, (double)bb.min(2));
        ViewTransformAffine vt = new ViewTransformAffine("fusion bounding box", m);
        vr.getTransformList().clear();
        vr.getTransformList().add(vt);
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        System.out.println("queryAdditionalParameters()");
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        System.out.println("parseAdditionalParameters()");
        return true;
    }

    @Override
    public ImgExport newInstance() {
        System.out.println("newInstance()");
        BoundingBoxGUI.defaultPixelType = 1;
        return new ExportSpimData2HDF5();
    }

    @Override
    public String getDescription() {
        System.out.println("getDescription()");
        return "Save as new XML Project (HDF5)";
    }
}

