/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration;

import java.text.NumberFormat;
import java.util.ArrayList;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.process.interestpointregistration.Detection;

public class RANSAC {
    public static Pair<String, Double> computeRANSAC(ArrayList<PointMatchGeneric<Detection>> correspondenceCandidates, ArrayList<PointMatchGeneric<Detection>> inlierList, Model<?> model, double maxEpsilon, double minInlierRatio, double minNumberInlierFactor, int numIterations) {
        int minNumCorrespondences;
        int numCorrespondences = correspondenceCandidates.size();
        if (numCorrespondences < (minNumCorrespondences = Math.max(model.getMinNumMatches(), (int)Math.round((double)model.getMinNumMatches() * minNumberInlierFactor)))) {
            return new ValuePair((Object)("Not enough correspondences found " + numCorrespondences + ", should be at least " + minNumCorrespondences), (Object)Double.NaN);
        }
        ArrayList<PointMatchGeneric<LinkedPoint<Detection>>> candidates = new ArrayList<PointMatchGeneric<LinkedPoint<Detection>>>();
        ArrayList inliers = new ArrayList();
        for (PointMatchGeneric<Detection> correspondence : correspondenceCandidates) {
            Detection detectionA = correspondence.getPoint1();
            Detection detectionB = correspondence.getPoint2();
            LinkedPoint<Detection> pA = new LinkedPoint<Detection>(detectionA.getL(), detectionA.getW(), detectionA);
            LinkedPoint<Detection> pB = new LinkedPoint<Detection>(detectionB.getL(), detectionB.getW(), detectionB);
            double weight = correspondence.getWeight();
            candidates.add(new PointMatchGeneric<LinkedPoint<Detection>>(pA, pB, weight));
        }
        boolean modelFound = false;
        try {
            modelFound = model.filterRansac(candidates, inliers, numIterations, maxEpsilon, minInlierRatio);
        }
        catch (NotEnoughDataPointsException e) {
            return new ValuePair((Object)e.toString(), (Object)Double.NaN);
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        double ratio = (double)inliers.size() / (double)candidates.size();
        if (modelFound && inliers.size() >= minNumCorrespondences) {
            for (PointMatch pointMatch : inliers) {
                PointMatchGeneric pm = (PointMatchGeneric)pointMatch;
                Detection detectionA = (Detection)((Object)((LinkedPoint)((Object)pm.getPoint1())).getLinkedObject());
                Detection detectionB = (Detection)((Object)((LinkedPoint)((Object)pm.getPoint2())).getLinkedObject());
                inlierList.add(new PointMatchGeneric<Detection>(detectionA, detectionB));
            }
            return new ValuePair((Object)("Remaining inliers after RANSAC: " + inliers.size() + " of " + candidates.size() + " (" + nf.format(ratio) + ") with average error " + model.getCost()), (Object)model.getCost());
        }
        if (modelFound) {
            return new ValuePair((Object)("Model found but not enough remaining inliers (" + inliers.size() + "/" + minNumCorrespondences + ") after RANSAC of " + candidates.size()), (Object)Double.NaN);
        }
        return new ValuePair((Object)("NO Model found after RANSAC of " + candidates.size()), (Object)Double.NaN);
    }
}

