/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;

public class ModelessQuestions
extends Dialog
implements ActionListener {
    protected static final int LABEL = 1;
    protected static final int CHECKBOX = 2;
    protected static final int RADIO = 3;
    protected static final int TEXTFIELD = 4;
    ArrayList<QuestionComponent> components;
    ImagePlus imagePlus;
    Hashtable<String, CheckboxGroup> checkboxGroups;
    ArrayList<Button> completingButtons = new ArrayList();
    int buttonPressed = -1;

    public ModelessQuestions(String title, ImagePlus imagePlus) {
        super((Frame)imagePlus.getWindow(), title, false);
        this.checkboxGroups = new Hashtable();
        this.components = new ArrayList();
        this.imagePlus = imagePlus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAnswers() {
        if (this.completingButtons.size() == 0) {
            IJ.error((String)"You must add some buttons to the ModelessQuestions object before calling waitForAnswers");
            return;
        }
        this.layOutDialog();
        try {
            System.out.println("About to synchronize");
            ModelessQuestions modelessQuestions = this;
            synchronized (modelessQuestions) {
                System.out.println("About to show");
                this.setVisible(true);
                System.out.println("About to wait");
                this.wait();
                System.out.println("Finished waiting");
            }
            System.out.println("After sychronized.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void layOutDialog() {
        this.setLayout(new BorderLayout());
        Panel questionPanel = new Panel();
        questionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        block4: for (QuestionComponent q : this.components) {
            switch (q.type) {
                case 4: {
                    c.gridx = 0;
                    c.gridwidth = 1;
                    c.anchor = 22;
                    questionPanel.add((Component)new Label(q.key), c);
                    c.gridx = 1;
                    c.anchor = 21;
                    questionPanel.add(q.component, c);
                    ++c.gridy;
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    c.gridx = 0;
                    c.gridwidth = 2;
                    questionPanel.add(q.component, c);
                    ++c.gridy;
                    continue block4;
                }
            }
            IJ.error((String)"BUG: Unkown component type.");
        }
        this.add((Component)questionPanel, "Center");
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        for (Button b : this.completingButtons) {
            buttonPanel.add((Component)b, c);
            ++c.gridx;
        }
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        System.out.println("In close(), about to synchronize");
        ModelessQuestions modelessQuestions = this;
        synchronized (modelessQuestions) {
            System.out.println("  In close(), about to notify()");
            this.notify();
        }
        System.out.println("In close(), after synchronized");
        this.setVisible(false);
        this.dispose();
    }

    public void addLabel(String text) {
        Label l = new Label(text);
        QuestionComponent q = new QuestionComponent(1, null, text, l);
        this.components.add(q);
    }

    public void addTextField(String defaultText, int columns, String label) {
        TextField tf = new TextField(defaultText, columns);
        QuestionComponent q = new QuestionComponent(4, null, label, tf);
        this.components.add(q);
    }

    public void addRadio(String groupName, String label) {
        if (!this.checkboxGroups.containsKey(groupName)) {
            this.checkboxGroups.put(groupName, new CheckboxGroup());
        }
        CheckboxGroup cbg = this.checkboxGroups.get(groupName);
        Checkbox cb = new Checkbox(label, false, cbg);
        QuestionComponent q = new QuestionComponent(3, groupName, label, cb);
        this.components.add(q);
    }

    public void addCheckbox(String label) {
        Checkbox cb = new Checkbox(label, false);
        QuestionComponent q = new QuestionComponent(2, null, label, cb);
        this.components.add(q);
    }

    public void addCompletingButton(String key, String text) {
        Button newButton = new Button(text);
        newButton.addActionListener(this);
        this.completingButtons.add(newButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.completingButtons.size(); ++i) {
            if (source != this.completingButtons.get(i)) continue;
            this.buttonPressed = i;
        }
        this.close();
    }

    public int getCompletingButtonIndex() {
        return this.buttonPressed;
    }

    public class QuestionComponent {
        int type;
        String group;
        String key;
        Component component;

        public QuestionComponent(int type, String group, String key, Component component) {
            this.type = type;
            this.group = group;
            this.key = key;
            this.component = component;
        }
    }
}

