/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import vib.InterpolatedImage;

public class NaiveResampler {
    private static int getPixel(byte[] b, int index) {
        return b[index] & 0xFF;
    }

    public static ImagePlus resample(ImagePlus image, int factorX, int factorY, int factorZ) {
        Accumulator accu = null;
        int type = image.getType();
        if (image.getProcessor().isColorLut()) {
            if (type == 0 || type == 3) {
                accu = new MaxLikelihood(255);
            } else if (type == 1) {
                accu = new MaxLikelihood(65535);
            }
        } else {
            accu = type == 4 ? new IntAverager() : new Averager();
        }
        return NaiveResampler.resample(image, factorX, factorY, factorZ, accu);
    }

    public static ImagePlus resample(ImagePlus image, int factor) {
        return NaiveResampler.resample(image, factor, factor, factor);
    }

    public static ImagePlus resampleMinEnt(ImagePlus image, int factorX, int factorY, int factorZ) {
        return NaiveResampler.resample(image, factorX, factorY, factorZ, new MinEntropy(image));
    }

    public static ImagePlus resampleMinEnt(ImagePlus image, int factor) {
        return NaiveResampler.resampleMinEnt(image, factor, factor, factor);
    }

    public static ImagePlus resample(ImagePlus image, int factorX, int factorY, int factorZ, Accumulator accu) {
        int type = image.getType();
        ImageStack stack = image.getStack();
        int w = image.getWidth();
        int h = image.getHeight();
        int d = stack.getSize();
        ImageStack result = new ImageStack(w / factorX, h / factorY, stack.getColorModel());
        for (int z = 0; z < d; z += factorZ) {
            int k;
            int kfactor = z + factorZ < d ? factorZ : d - z;
            Object slices = null;
            Object slicesShort = null;
            Object slicesInt = null;
            if (type == 0 || type == 3) {
                slices = new byte[kfactor][];
                for (k = 0; k < kfactor; ++k) {
                    slices[k] = (byte[])stack.getProcessor(z + k + 1).getPixels();
                }
            } else if (type == 1) {
                slicesShort = new short[kfactor][];
                for (k = 0; k < kfactor; ++k) {
                    slicesShort[k] = (short[])stack.getProcessor(z + k + 1).getPixels();
                }
            } else if (type == 4) {
                slicesInt = new int[kfactor][];
                for (k = 0; k < kfactor; ++k) {
                    slicesInt[k] = (int[])stack.getProcessor(z + k + 1).getPixels();
                }
            } else {
                IJ.error((String)"Resample only currently works on 8 bit and 16 bit images.");
                return null;
            }
            byte[] newSlice = null;
            short[] newSliceShort = null;
            int[] newSliceInt = null;
            int pointsInNewSlice = (1 + (w - 1) / factorX) * (1 + (h - 1) / factorY);
            if (type == 0 || type == 3) {
                newSlice = new byte[pointsInNewSlice];
            } else if (type == 1) {
                newSliceShort = new short[pointsInNewSlice];
            } else if (type == 4) {
                newSliceInt = new int[pointsInNewSlice];
            }
            for (int y = 0; y < h; y += factorY) {
                for (int x = 0; x < w; x += factorX) {
                    int k2;
                    int j;
                    int i;
                    int ifactor = x + factorX < w ? factorX : w - x;
                    int jfactor = y + factorY < h ? factorY : h - y;
                    accu.reset();
                    if (type == 0 || type == 3) {
                        for (i = 0; i < ifactor; ++i) {
                            for (j = 0; j < jfactor; ++j) {
                                for (k2 = 0; k2 < kfactor; ++k2) {
                                    accu.add(NaiveResampler.getPixel(slices[k2], x + i + w * (y + j)));
                                }
                            }
                        }
                        newSlice[x / factorX + w / factorX * (y / factorY)] = (byte)accu.get();
                        continue;
                    }
                    if (type == 1) {
                        for (i = 0; i < ifactor; ++i) {
                            for (j = 0; j < jfactor; ++j) {
                                for (k2 = 0; k2 < kfactor; ++k2) {
                                    accu.add(slicesShort[k2][x + i + w * (y + j)]);
                                }
                            }
                        }
                        newSliceShort[x / factorX + w / factorX * (y / factorY)] = (short)accu.get();
                        continue;
                    }
                    if (type != 4) continue;
                    for (i = 0; i < ifactor; ++i) {
                        for (j = 0; j < jfactor; ++j) {
                            for (k2 = 0; k2 < kfactor; ++k2) {
                                accu.add(slicesInt[k2][x + i + w * (y + j)]);
                            }
                        }
                    }
                    newSliceInt[x / factorX + w / factorX * (y / factorY)] = accu.get();
                }
                IJ.showProgress((int)(z * h + y + 1), (int)(h * d));
            }
            if (type == 0 || type == 3) {
                result.addSlice(null, (Object)newSlice);
                continue;
            }
            if (type == 1) {
                result.addSlice(null, (Object)newSliceShort);
                continue;
            }
            if (type != 4) continue;
            result.addSlice(null, (Object)newSliceInt);
        }
        ImagePlus res = new ImagePlus(image.getTitle() + " resampled", result);
        if (AmiraParameters.isAmiraMesh(image)) {
            AmiraParameters p = new AmiraParameters(image);
            p.setParameters(res);
        }
        Calibration cal = image.getCalibration().copy();
        cal.pixelWidth *= (double)image.getWidth() / (double)res.getWidth();
        cal.pixelHeight *= (double)image.getHeight() / (double)res.getHeight();
        cal.pixelDepth *= (double)image.getStack().getSize() / (double)res.getStack().getSize();
        res.setCalibration(cal);
        return res;
    }

    public static class MinEntropy
    implements Accumulator {
        int[] histogram;
        int currentValue;

        public MinEntropy(ImagePlus image) {
            this(new InterpolatedImage(image));
        }

        public MinEntropy(InterpolatedImage ii) {
            block7: {
                InterpolatedImage.Iterator iter;
                int type;
                block6: {
                    this.currentValue = -1;
                    type = ii.image.getType();
                    if (type == 0 || type == 3) {
                        this.histogram = new int[256];
                    } else if (type == 1) {
                        this.histogram = new int[65536];
                    } else {
                        IJ.error((String)"MinEntropy only works on 8bit or 16bit gray images.");
                        return;
                    }
                    iter = ii.iterator();
                    if (type != 0 && type != 3) break block6;
                    while (iter.next() != null) {
                        int n = ii.getNoInterpol(iter.i, iter.j, iter.k);
                        this.histogram[n] = this.histogram[n] + 1;
                    }
                    break block7;
                }
                if (type != 1) break block7;
                while (iter.next() != null) {
                    short s = ii.getNoInterpolShort(iter.i, iter.j, iter.k);
                    this.histogram[s] = this.histogram[s] + 1;
                }
            }
        }

        @Override
        public void reset() {
            this.currentValue = -1;
        }

        @Override
        public void add(int value) {
            if (this.currentValue < 0 || this.histogram[value] < this.histogram[this.currentValue]) {
                this.currentValue = value;
            }
        }

        @Override
        public int get() {
            return this.currentValue;
        }
    }

    public static class MaxLikelihood
    implements Accumulator {
        int[] histo;
        int[] empty;
        int max;
        int indexOfHighest = -1;
        int highest = -1;

        MaxLikelihood(int max) {
            this.max = max;
            this.histo = new int[max + 1];
            this.empty = new int[max + 1];
        }

        MaxLikelihood() {
            this(255);
        }

        @Override
        public void reset() {
            this.highest = -1;
            this.indexOfHighest = -1;
            System.arraycopy(this.empty, 0, this.histo, 0, this.max + 1);
        }

        @Override
        public void add(int value) {
            int n = value;
            this.histo[n] = this.histo[n] + 1;
            if (this.histo[value] > this.highest) {
                this.highest = this.histo[value];
                this.indexOfHighest = value;
            }
        }

        @Override
        public int get() {
            return this.indexOfHighest;
        }

        public String toString() {
            String result = "";
            for (int i = 0; i <= this.max; ++i) {
                if (i > 0) {
                    result = result + " ";
                }
                result = result + this.histo[i];
            }
            result = result + ": " + this.get();
            return result;
        }
    }

    public static class IntAverager
    implements Accumulator {
        long count;
        long cumulR;
        long cumulG;
        long cumulB;

        @Override
        public void reset() {
            this.cumulB = 0L;
            this.cumulG = 0L;
            this.cumulR = 0L;
            this.count = 0L;
        }

        @Override
        public void add(int value) {
            ++this.count;
            this.cumulR += (long)((value & 0xFF0000) >> 16);
            this.cumulG += (long)((value & 0xFF00) >> 8);
            this.cumulB += (long)(value & 0xFF);
        }

        @Override
        public int get() {
            return (int)((this.cumulR / this.count << 16) + (this.cumulG / this.count << 8) + this.cumulB / this.count);
        }
    }

    public static class Averager
    implements Accumulator {
        long count;
        long cumul;

        @Override
        public void reset() {
            this.count = 0L;
            this.cumul = 0L;
        }

        @Override
        public void add(int value) {
            this.cumul += (long)value;
            ++this.count;
        }

        @Override
        public int get() {
            return (int)(this.cumul / this.count);
        }
    }

    private static interface Accumulator {
        public void reset();

        public void add(int var1);

        public int get();
    }
}

