/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.Junction;
import de.biomedical_imaging.ij.steger.Junctions;
import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Options;
import de.biomedical_imaging.ij.steger.OverlapOption;
import de.biomedical_imaging.ij.steger.Position;
import de.biomedical_imaging.ij.steger.SlopeOverlapResolver;
import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;

public class LineDetector {
    boolean isDarkLine = false;
    boolean doCorrectPosition = false;
    boolean doEstimateWidth = false;
    boolean doExtendLine = false;
    private Options opts = null;
    private Junctions junctions;
    private Lines lines;
    Set<Integer> alreadyProcessedJunctionPoints;
    boolean bechatty = false;

    public Lines detectLines(ImageProcessor ip, double sigma, double upperThresh, double lowerThresh, double minLength, double maxLength, boolean isDarkLine, boolean doCorrectPosition, boolean doEstimateWidth, boolean doExtendLine) {
        return this.detectLines(ip, sigma, upperThresh, lowerThresh, minLength, maxLength, isDarkLine, doCorrectPosition, doEstimateWidth, doExtendLine, OverlapOption.NONE);
    }

    public Lines detectLines(ImageProcessor ip, double sigma, double upperThresh, double lowerThresh, double minLength, double maxLength, boolean isDarkLine, boolean doCorrectPosition, boolean doEstimateWidth, boolean doExtendLine, OverlapOption overlapOption) {
        this.isDarkLine = isDarkLine;
        this.doCorrectPosition = doCorrectPosition;
        this.doEstimateWidth = doEstimateWidth;
        this.doExtendLine = doExtendLine;
        this.junctions = new Junctions(ip.getSliceNumber());
        this.lines = this.get_lines(sigma, upperThresh, lowerThresh, minLength, maxLength, ip.getHeight(), ip.getWidth(), ip, this.junctions, overlapOption);
        return this.lines;
    }

    private void assignLinesToJunctions(Lines lines, Junctions junctions) {
        for (Junction j : junctions) {
            j.lineCont1 = (Line)lines.get(j.cont1);
            j.lineCont2 = (Line)lines.get(j.cont2);
        }
    }

    public Options getUsedParamters() {
        return this.opts;
    }

    public Junctions getJunctions() {
        return this.junctions;
    }

    private void addAdditionalJunctionPointsAndLines(Lines lines, Junctions junctions) {
        for (int i = 0; i < junctions.size(); ++i) {
            boolean isClosedContour;
            Junction splitPoint = (Junction)junctions.get(i);
            this.log("Process Splitpoint " + splitPoint.getLine1().getID() + "-" + splitPoint.getLine2().getID() + " Pos: " + splitPoint.pos);
            if (this.alreadyProcessedJunctionPoints.contains(i)) continue;
            Junctions junctionsWithTheSamePosition = new Junctions(junctions.getFrame());
            this.alreadyProcessedJunctionPoints.add(i);
            junctionsWithTheSamePosition.add(splitPoint);
            for (int j = i + 1; j < junctions.size(); ++j) {
                if (this.alreadyProcessedJunctionPoints.contains(j)) continue;
                Junction junc2 = (Junction)junctions.get(j);
                if (!((double)Math.abs(junc2.x - splitPoint.x) < 0.01) || !((double)Math.abs(junc2.y - splitPoint.y) < 0.01)) continue;
                this.alreadyProcessedJunctionPoints.add(j);
                junctionsWithTheSamePosition.add(junc2);
            }
            ArrayList<Line> connectedWithProcessedLine = new ArrayList<Line>();
            ArrayList<Integer> connectedWithProcessedIndex = new ArrayList<Integer>();
            for (Junction junc : junctionsWithTheSamePosition) {
                connectedWithProcessedLine.add(junc.getLine2());
                connectedWithProcessedIndex.add(junc.cont2);
            }
            for (int j = 0; j < connectedWithProcessedLine.size(); ++j) {
                for (int k = j + 1; k < connectedWithProcessedLine.size(); ++k) {
                    Line l1 = (Line)connectedWithProcessedLine.get(j);
                    Line l2 = (Line)connectedWithProcessedLine.get(k);
                    Junction junc = new Junction();
                    junc.lineCont1 = l1;
                    junc.lineCont2 = l2;
                    junc.x = splitPoint.x;
                    junc.y = splitPoint.y;
                    junc.cont1 = (Integer)connectedWithProcessedIndex.get(j);
                    junc.cont2 = (Integer)connectedWithProcessedIndex.get(k);
                    junc.pos = l1.getStartOrdEndPosition(junc.x, junc.y);
                    junctions.add(junc);
                    this.log("Connect " + junc.getLine1().getID() + "-" + junc.getLine2().getID() + " Pos: " + junc.pos);
                    this.alreadyProcessedJunctionPoints.add(junctions.size() - 1);
                }
            }
            Line l1 = splitPoint.getLine1();
            int pos = splitPoint.pos;
            boolean bl = isClosedContour = l1.col[0] == l1.col[l1.num - 1] && l1.row[0] == l1.row[l1.num - 1];
            if (isClosedContour) {
                l1.setContourClass(LinesUtil.contour_class.cont_closed);
                l1.setContourClass(this.reconstructContourClass(l1, l1.getStartOrdEndPosition(splitPoint.x, splitPoint.y)));
            }
            this.log("Pos: " + pos + " num: " + l1.num);
            if (pos == 0 || pos == l1.num - 1 || isClosedContour) continue;
            int keepLength = pos + 1;
            float[] keepAsymmetry = new float[keepLength];
            float[] keepIntensity = new float[keepLength];
            float[] keepAngle = new float[keepLength];
            float[] keepWidth_l = new float[keepLength];
            float[] keepWidth_r = new float[keepLength];
            float[] keepCol = new float[keepLength];
            float[] keepRow = new float[keepLength];
            float[] keepResponse = new float[keepLength];
            int splitSize = l1.num - pos;
            float[] splitAsymmetry = new float[splitSize];
            float[] splitIntensity = new float[splitSize];
            float[] splitAngle = new float[splitSize];
            float[] splitWidth_l = new float[splitSize];
            float[] splitWidth_r = new float[splitSize];
            float[] splitCol = new float[splitSize];
            float[] splitRow = new float[splitSize];
            float[] splitResponse = new float[splitSize];
            if (this.doEstimateWidth) {
                if (this.doCorrectPosition) {
                    System.arraycopy(l1.asymmetry, 0, keepAsymmetry, 0, keepLength);
                    System.arraycopy(l1.asymmetry, pos, splitAsymmetry, 0, splitSize);
                    System.arraycopy(l1.intensity, 0, keepIntensity, 0, keepLength);
                    System.arraycopy(l1.intensity, pos, splitIntensity, 0, splitSize);
                }
                System.arraycopy(l1.angle, 0, keepAngle, 0, keepLength);
                System.arraycopy(l1.angle, pos, splitAngle, 0, splitSize);
                System.arraycopy(l1.width_l, 0, keepWidth_l, 0, keepLength);
                System.arraycopy(l1.width_l, pos, splitWidth_l, 0, splitSize);
                System.arraycopy(l1.width_r, 0, keepWidth_r, 0, keepLength);
                System.arraycopy(l1.width_r, pos, splitWidth_r, 0, splitSize);
            }
            System.arraycopy(l1.col, 0, keepCol, 0, keepLength);
            System.arraycopy(l1.col, pos, splitCol, 0, splitSize);
            System.arraycopy(l1.row, 0, keepRow, 0, keepLength);
            System.arraycopy(l1.row, pos, splitRow, 0, splitSize);
            System.arraycopy(l1.response, 0, keepResponse, 0, keepLength);
            System.arraycopy(l1.response, pos, splitResponse, 0, splitSize);
            Line lNew = new Line();
            lNew.angle = splitAngle;
            lNew.asymmetry = splitAsymmetry;
            lNew.col = splitCol;
            lNew.row = splitRow;
            lNew.response = splitResponse;
            lNew.intensity = splitIntensity;
            lNew.width_l = splitWidth_l;
            lNew.width_r = splitWidth_r;
            lNew.num = splitSize;
            lNew.setContourClass(l1.getContourClass());
            lNew.setFrame(l1.getFrame());
            lines.add(lNew);
            int newID = lNew.getID();
            HashSet<Integer> lineIds = new HashSet<Integer>();
            for (Junction junc : junctionsWithTheSamePosition) {
                lineIds.add(junc.getLine1().getID());
                lineIds.add(junc.getLine2().getID());
            }
            Iterator idIt = lineIds.iterator();
            while (idIt.hasNext()) {
                int id = (Integer)idIt.next();
                int connectWithLineID = lines.getIndexByID(id);
                Line connectWith = (Line)lines.get(connectWithLineID);
                Junction j = new Junction();
                j.cont1 = lines.size() - 1;
                j.cont2 = connectWithLineID;
                j.lineCont1 = lNew;
                j.lineCont2 = connectWith;
                j.x = splitPoint.x;
                j.y = splitPoint.y;
                j.pos = lNew.getStartOrdEndPosition(splitPoint.x, splitPoint.y);
                junctions.add(j);
                this.log("Connect " + j.getLine1().getID() + "-" + j.getLine2().getID() + " Pos: " + j.pos);
                this.alreadyProcessedJunctionPoints.add(junctions.size() - 1);
            }
            for (int j = 0; j < junctions.size(); ++j) {
                Junction junc2 = (Junction)junctions.get(j);
                if (junc2.cont1 == splitPoint.cont1 && junc2.pos > splitPoint.pos) {
                    this.log("Update From " + junc2.getLine1().getID() + "-" + junc2.getLine2().getID() + " Pos: " + junc2.pos);
                    junc2.cont1 = lines.getIndexByID(newID);
                    junc2.lineCont1 = lNew;
                    junc2.pos -= splitPoint.pos;
                    this.log("Update To " + junc2.getLine1().getID() + "-" + junc2.getLine2().getID() + " Pos: " + junc2.pos);
                }
                double[] min = this.minDistance(junc2.getLine2(), junc2.x, junc2.y);
                if (junc2.cont2 != splitPoint.cont1 || (int)min[1] <= splitPoint.pos) continue;
                junc2.cont2 = lines.getIndexByID(newID);
                junc2.lineCont2 = lNew;
            }
            l1.angle = keepAngle;
            l1.asymmetry = keepAsymmetry;
            l1.col = keepCol;
            l1.row = keepRow;
            l1.response = keepResponse;
            l1.intensity = keepIntensity;
            l1.width_l = keepWidth_l;
            l1.width_r = keepWidth_r;
            l1.num = keepLength;
            this.log("Set Splitpoint Position from " + splitPoint.pos);
            splitPoint.pos = l1.getStartOrdEndPosition(splitPoint.x, splitPoint.y);
            this.log("Set Splitpoint Position to " + splitPoint.pos);
            lines.set(splitPoint.cont1, l1);
        }
    }

    private Junctions fixJunctions(Lines lines, Junctions junctions) {
        for (Junction junction : junctions) {
            float help = junction.x;
            junction.x = junction.y;
            junction.y = help;
        }
        Junctions newJunctions = new Junctions(junctions.getFrame());
        ArrayList<Point2D.Float> processedJunctions = new ArrayList<Point2D.Float>();
        for (int i = 0; i < junctions.size(); ++i) {
            int j;
            int j2;
            Junction junc = (Junction)junctions.get(i);
            Line mainLine = null;
            int mainLineIndex = -1;
            int mainLinePos = -1;
            ArrayList<Line> secondaryLines = new ArrayList<Line>();
            ArrayList<Integer> secondaryLineIndex = new ArrayList<Integer>();
            ArrayList<Integer> secondaryLinePos = new ArrayList<Integer>();
            if (processedJunctions.contains(new Point2D.Float(junc.x, junc.y))) continue;
            processedJunctions.add(new Point2D.Float(junc.x, junc.y));
            for (j2 = 0; j2 < lines.size(); ++j2) {
                Line l = (Line)lines.get(j2);
                double[] mindist = this.minDistance(l, junc.x, junc.y);
                if (!(mindist[0] < 0.1)) continue;
                if (mindist[1] == 0.0 || mindist[1] == (double)(l.num - 1)) {
                    secondaryLines.add(l);
                    secondaryLineIndex.add(j2);
                    secondaryLinePos.add((int)mindist[1]);
                    continue;
                }
                if (mainLine != null) {
                    if (mainLine.getID() == l.getID()) continue;
                    this.log("\u00c4h, zwei Hauptlininen geht nich..." + mainLine.getID() + " x " + junc.x + " y " + junc.y);
                    this.log("\u00c4h, zwei Hauptlininen geht nich..." + l.getID() + " x " + junc.x + " y " + junc.y);
                }
                mainLine = l;
                mainLineIndex = j2;
                mainLinePos = (int)mindist[1];
            }
            if (mainLine != null) {
                for (j2 = 0; j2 < secondaryLines.size(); ++j2) {
                    Junction newJunc = new Junction();
                    newJunc.cont1 = mainLineIndex;
                    newJunc.cont2 = (Integer)secondaryLineIndex.get(j2);
                    newJunc.x = junc.x;
                    newJunc.y = junc.y;
                    newJunc.pos = mainLinePos;
                    newJunctions.add(newJunc);
                    this.log("NewJunc Mainline: " + ((Line)lines.get(newJunc.cont1)).getID() + "-" + ((Line)lines.get(newJunc.cont2)).getID() + " pos " + newJunc.pos + " num " + ((Line)lines.get((int)newJunc.cont1)).num);
                }
                continue;
            }
            HashSet<Integer> uniqueIDs = new HashSet<Integer>();
            ArrayList uniqueLines = new ArrayList();
            ArrayList uniqueLineIndex = new ArrayList();
            ArrayList uniqueLinePos = new ArrayList();
            for (j = 0; j < secondaryLines.size(); ++j) {
                if (uniqueIDs.contains(((Line)secondaryLines.get(j)).getID())) continue;
                uniqueIDs.add(((Line)secondaryLines.get(j)).getID());
                uniqueLines.add(secondaryLines.get(j));
                uniqueLineIndex.add(secondaryLineIndex.get(j));
                uniqueLinePos.add(secondaryLinePos.get(j));
            }
            for (j = 0; j < uniqueLines.size(); ++j) {
                for (int k = j + 1; k < uniqueLines.size(); ++k) {
                    Junction newJunc = new Junction();
                    newJunc.cont1 = (Integer)uniqueLineIndex.get(j);
                    newJunc.cont2 = (Integer)uniqueLineIndex.get(k);
                    newJunc.x = junc.x;
                    newJunc.y = junc.y;
                    newJunc.pos = (Integer)uniqueLinePos.get(j);
                    newJunctions.add(newJunc);
                    this.log("NewJunc Second: " + ((Line)lines.get(newJunc.cont1)).getID() + "-" + ((Line)lines.get(newJunc.cont2)).getID() + " pos " + newJunc.pos + " num " + ((Line)lines.get((int)newJunc.cont1)).num);
                    this.alreadyProcessedJunctionPoints.add(newJunctions.size() - 1);
                }
            }
        }
        return newJunctions;
    }

    private LinesUtil.contour_class reconstructContourClass(Line l, int pos) {
        boolean hasJunctionAtEndpoint;
        LinesUtil.contour_class currentClass = l.getLineClass();
        boolean hasJunctionAtStartpoint = pos == 0;
        boolean bl = hasJunctionAtEndpoint = pos == l.num - 1;
        if (currentClass == LinesUtil.contour_class.cont_no_junc && hasJunctionAtStartpoint) {
            return LinesUtil.contour_class.cont_start_junc;
        }
        if (currentClass == LinesUtil.contour_class.cont_no_junc && hasJunctionAtEndpoint) {
            return LinesUtil.contour_class.cont_end_junc;
        }
        if (currentClass == LinesUtil.contour_class.cont_start_junc && hasJunctionAtEndpoint) {
            return LinesUtil.contour_class.cont_both_junc;
        }
        if (currentClass == LinesUtil.contour_class.cont_end_junc && hasJunctionAtStartpoint) {
            return LinesUtil.contour_class.cont_both_junc;
        }
        if (currentClass == LinesUtil.contour_class.cont_closed && (hasJunctionAtEndpoint || hasJunctionAtStartpoint)) {
            return LinesUtil.contour_class.cont_both_junc;
        }
        return currentClass;
    }

    private double[] minDistance(Line l, float x, float y) {
        double min = Double.MAX_VALUE;
        double index = -1.0;
        for (int i = 0; i < l.num; ++i) {
            double d = Math.sqrt(Math.pow(l.col[i] - x, 2.0) + Math.pow(l.row[i] - y, 2.0));
            if (!(d < min)) continue;
            min = d;
            index = i;
        }
        double[] ret = new double[]{min, index};
        return ret;
    }

    private void deleteJunctions(Lines contours, Junctions junctions, Line c) {
        this.deleteJunctions(contours, junctions, c, OverlapOption.NONE);
    }

    private void deleteJunctions(Lines contours, Junctions junctions, Line c, OverlapOption overlapOption) {
        ArrayList<Junction> remove = new ArrayList<Junction>();
        for (Junction junction : junctions) {
            if (overlapOption == OverlapOption.SLOPE) {
                if (junction.cont1 != c.getID() && junction.cont2 != c.getID()) continue;
                this.log("Removing junction between line IDs" + junction.cont1 + " and " + junction.cont2);
                remove.add(junction);
                continue;
            }
            if (((Line)contours.get(junction.cont1)).getID() != c.getID() && ((Line)contours.get(junction.cont2)).getID() != c.getID()) continue;
            this.log("Removing junction between line idx " + junction.cont1 + " and " + junction.cont2);
            remove.add(junction);
        }
        for (Junction junction : remove) {
            junctions.remove(junction);
        }
    }

    private void fixContours(Lines contours, Junctions junctions) {
        ArrayList<Line> remove = new ArrayList<Line>();
        for (Line contour : contours) {
            if (contour.num == 1) {
                this.deleteJunctions(contours, junctions, contour);
                remove.add(contour);
            }
            contour.setContourClass(LinesUtil.contour_class.cont_no_junc);
        }
        for (Line c : remove) {
            contours.remove(c);
        }
        if (contours.size() >= 2 && ((Line)contours.get(0)).getID() == ((Line)contours.get(contours.size() - 1)).getID()) {
            contours.remove(contours.size() - 1);
        }
    }

    private void pruneContours(Lines contours, Junctions junctions, double minLength, double maxLength, OverlapOption overlapOption) {
        ArrayList<Line> remove = new ArrayList<Line>();
        this.log("Pruning lines:");
        for (Line c : contours) {
            if (c.estimateLength() < minLength || maxLength > 0.0 && c.estimateLength() > maxLength) {
                this.log("Removing line " + c.getID() + " of length " + c.estimateLength());
                this.deleteJunctions(contours, junctions, c, overlapOption);
                remove.add(c);
                continue;
            }
            this.log("Keeping line " + c.getID() + " of length " + c.estimateLength());
        }
        for (Line c : remove) {
            contours.remove(c);
        }
    }

    private Lines get_lines(double sigma, double high, double low, double minLength, double maxLength, int rows, int cols, ImageProcessor in_img, Junctions resultJunction, OverlapOption overlapOption) {
        int i;
        Lines contours = new Lines(in_img.getSliceNumber());
        int num_cont = 0;
        this.opts = new Options(-1.0, -1.0, -1.0, this.isDarkLine ? 2 : 1, -1.0, -1.0, this.doCorrectPosition, this.doEstimateWidth, this.doExtendLine, false, false, false, overlapOption);
        this.opts.sigma = sigma;
        this.opts.high = high;
        this.opts.low = low;
        this.check_sigma(this.opts.sigma, cols, rows);
        this.opts.minLength = minLength;
        this.opts.maxLength = maxLength;
        SlopeOverlapResolver resolver = null;
        switch (overlapOption) {
            default: {
                break;
            }
            case SLOPE: {
                resolver = new SlopeOverlapResolver();
            }
        }
        float[] imgpxls = new float[cols * rows];
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j2 = 0; j2 < cols; ++j2) {
                imgpxls[i2 * cols + j2] = in_img.getf(j2, i2);
            }
        }
        FloatProcessor image = new FloatProcessor(cols, rows, imgpxls);
        MutableInt hnum_cont = new MutableInt(num_cont);
        float[] imgpxls2 = (float[])image.getPixels();
        Position p = new Position();
        p.detect_lines(imgpxls2, cols, rows, contours, hnum_cont, this.opts.sigma, this.opts.low, this.opts.high, this.opts.mode, this.opts.width, this.opts.correct, this.opts.extend, resultJunction);
        num_cont = hnum_cont.getValue();
        this.fixContours(contours, resultJunction);
        this.alreadyProcessedJunctionPoints = new HashSet<Integer>();
        resultJunction = this.fixJunctions(contours, resultJunction);
        this.assignLinesToJunctions(contours, resultJunction);
        this.addAdditionalJunctionPointsAndLines(contours, resultJunction);
        Collections.sort(resultJunction);
        this.junctions = resultJunction;
        for (i = 0; i < contours.size(); ++i) {
            ((Line)contours.get(i)).setContourClass(LinesUtil.contour_class.cont_no_junc);
        }
        for (i = 0; i < contours.size(); ++i) {
            boolean isClosedContour;
            boolean bl = isClosedContour = ((Line)contours.get((int)i)).col[0] == ((Line)contours.get((int)i)).col[((Line)contours.get((int)i)).num - 1] && ((Line)contours.get((int)i)).row[0] == ((Line)contours.get((int)i)).row[((Line)contours.get((int)i)).num - 1];
            if (!isClosedContour) continue;
            ((Line)contours.get(i)).setContourClass(LinesUtil.contour_class.cont_closed);
        }
        for (i = 0; i < this.junctions.size(); ++i) {
            Junction j = (Junction)this.junctions.get(i);
            j.getLine1().setContourClass(this.reconstructContourClass(j.getLine1(), j.pos));
            float x = j.getLine1().getXCoordinates()[j.pos];
            float y = j.getLine1().getYCoordinates()[j.pos];
            j.getLine2().setContourClass(this.reconstructContourClass(j.getLine2(), j.getLine2().getStartOrdEndPosition(x, y)));
        }
        if (resolver != null) {
            contours = resolver.resolve(contours, this.junctions, this.bechatty);
        }
        if (minLength != 0.0 || maxLength != 0.0) {
            this.pruneContours(contours, this.junctions, minLength, maxLength, overlapOption);
        }
        return contours;
    }

    private void log(String s) {
        if (this.bechatty) {
            IJ.log((String)s);
        }
    }

    private void check_sigma(double sigma, int width, int height) {
        int min_dim;
        int n = min_dim = width < height ? width : height;
        if (sigma < 0.4) {
            IJ.error((String)"Sigma out of range:", (String)"< 0.4");
        }
        if (LinesUtil.MASK_SIZE(3.82922419517181, sigma) >= min_dim) {
            IJ.error((String)"Sigma out of range:", (String)"too large for image size");
        }
    }
}

