/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class SwingTools {
    public static JTabbedPane tab(Component component, String title, String tooltip, int width, int height, Container addTo) {
        JPanel tab = new JPanel();
        tab.setLayout(new BorderLayout());
        tab.add((Component)SwingTools.scrollPane(component, width, height, null), "Center");
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab(title, null, tab, tooltip);
        tabbed.setPreferredSize(new Dimension(width, height));
        if (addTo != null) {
            addTo.add(tabbed);
        }
        return tabbed;
    }

    public static JScrollPane scrollPane(Component component, int width, int height, Container addTo) {
        JScrollPane scroll = new JScrollPane(component);
        scroll.getViewport().setBackground(component.getBackground());
        if (width > -1 && height > -1) {
            scroll.setPreferredSize(new Dimension(width, height));
        }
        if (addTo != null) {
            addTo.add(scroll);
        }
        return scroll;
    }

    public static JPanel label(String text, Container addTo) {
        JLabel label = new JLabel(text, 2);
        JPanel panel = SwingTools.horizontalPanel();
        panel.add(label);
        panel.add(Box.createHorizontalGlue());
        if (addTo != null) {
            addTo.add(panel);
        }
        return panel;
    }

    public static JPanel boxLayoutPanel(int alignment) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, alignment));
        return panel;
    }

    public static JPanel horizontalPanel() {
        return SwingTools.boxLayoutPanel(0);
    }

    public static JPanel verticalPanel() {
        return SwingTools.boxLayoutPanel(1);
    }

    public static JButton button(String title, String toolTip, ActionListener listener, Container addTo) {
        JButton button = new JButton(title);
        button.setToolTipText(toolTip);
        button.addActionListener(listener);
        if (addTo != null) {
            addTo.add(button);
        }
        return button;
    }

    public static JPanel labelComponent(String text, JComponent component, Container addTo) {
        JPanel panel = SwingTools.horizontalPanel();
        JLabel label = new JLabel(text, 2);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(component);
        if (addTo != null) {
            addTo.add(panel);
        }
        return panel;
    }

    public static JPanel labelComponentRigid(String text, JComponent component) {
        JPanel panel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        panel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel label = new JLabel(text, 2);
        gb.setConstraints(label, c);
        panel.add(label);
        Component box = Box.createRigidArea(new Dimension(10, 0));
        c.gridx = 1;
        gb.setConstraints(box, c);
        panel.add(box);
        c.gridx = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        gb.setConstraints(component, c);
        panel.add(component);
        return panel;
    }

    public static JTextPane scrolledText(int width, int height, String text, DocumentListener listener, Container addTo) {
        JTextPane component = new JTextPane();
        component.getDocument().addDocumentListener(listener);
        if (text != null) {
            component.setText(text);
        }
        component.setSelectionStart(0);
        component.setSelectionEnd(0);
        SwingTools.scrollPane(component, width, height, addTo);
        return component;
    }

    public static JTextPane scrolledText(int width, int height, Iterable<String> list, DocumentListener listener, Container addTo) {
        StringBuilder builder = new StringBuilder();
        for (String text : list) {
            builder.append(text + "\n");
        }
        return SwingTools.scrolledText(width, height, builder.toString(), listener, addTo);
    }

    public static void addAccelerator(final Component source, JComponent container, final ActionListener listener, int key, int modifiers) {
        container.getInputMap(2).put(KeyStroke.getKeyStroke(key, modifiers), source);
        if (container.getActionMap().get(source) != null) {
            return;
        }
        container.getActionMap().put(source, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!source.isEnabled()) {
                    return;
                }
                ActionEvent event = new ActionEvent(source, 0, "Accelerator");
                listener.actionPerformed(event);
            }
        });
    }

    public static boolean showQuestion(Component owner, String title, String question) {
        return JOptionPane.showConfirmDialog(owner, question, title, 2, 3) == 0;
    }

    public static boolean showYesNoQuestion(Component owner, String title, String question) {
        return JOptionPane.showConfirmDialog(owner, question, title, 0, 3) == 0;
    }

    public static void showMessageBox(Component owner, String message, int type) {
        SwingTools.invokeOnEDT(() -> {
            String title = type == 0 ? "Error" : (type == 2 ? "Warning" : "Information");
            JOptionPane.showMessageDialog(owner, message, title, type);
        });
    }

    public static String getChoice(Component owner, List<String> list, String question, String title) {
        Object[] array = list.toArray(new String[list.size()]);
        JOptionPane pane = new JOptionPane(question, 3, 2, null, array);
        pane.createDialog(owner, title).setVisible(true);
        return (String)pane.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForFakeDialog(String title, Component component) {
        JDialog fakeDialog = new JDialog((Dialog)null, title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
                super.dispose();
            }
        };
        fakeDialog.getContentPane().add(component);
        fakeDialog.pack();
        try {
            JDialog jDialog = fakeDialog;
            synchronized (jDialog) {
                fakeDialog.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static int defaultFontSize() {
        try {
            return UIManager.getDefaults().getFont("TextPane.font").getSize();
        }
        catch (NullPointerException ignored) {
            return 12;
        }
    }

    public static void invokeOnEDT(Runnable job) {
        if (SwingUtilities.isEventDispatchThread()) {
            job.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(job);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

