/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.BehaviorRetained;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.FogRetained;
import org.scijava.java3d.IllegalSceneGraphException;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.LightRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.SoundRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.VirtualUniverse;

class BoundingLeafRetained
extends LeafRetained {
    static final int REGION_CHANGED = 1;
    static final Integer REGION_CHANGED_MESSAGE = new Integer(1);
    Bounds region = null;
    Bounds transformedRegion = null;
    BoundingLeafRetained mirrorBoundingLeaf;
    ArrayList users = new ArrayList();
    int targetThreads = 4224;
    int transformTargetThreads = 4160;

    BoundingLeafRetained() {
        this.nodeType = 25;
    }

    void createBoundingLeaf() {
        this.nodeType = 25;
        this.mirrorBoundingLeaf = new BoundingLeafRetained();
    }

    void initRegion(Bounds region) {
        this.region = region != null ? (Bounds)region.clone() : null;
        if (this.staticTransform != null) {
            this.region.transform(this.staticTransform.transform);
        }
    }

    void setRegion(Bounds region) {
        this.initRegion(region);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = this.mirrorBoundingLeaf.targetThreads;
        createMessage.type = 23;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = REGION_CHANGED_MESSAGE;
        createMessage.args[2] = region != null ? (Bounds)region.clone() : null;
        createMessage.args[3] = this.mirrorBoundingLeaf.users.toArray();
        VirtualUniverse.mc.processMessage(createMessage);
    }

    Bounds getRegion() {
        Bounds b = null;
        if (this.region != null) {
            b = (Bounds)this.region.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BoundingLeafRetained0"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BoundingLeafRetained1"));
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorBoundingLeaf, 5);
            s.notifyThreads |= 0x2000;
        }
        this.mirrorBoundingLeaf.localToVworld = new Transform3D[1][];
        this.mirrorBoundingLeaf.localToVworldIndex = new int[1][];
        this.mirrorBoundingLeaf.localToVworld[0] = this.localToVworld[0];
        this.mirrorBoundingLeaf.localToVworldIndex[0] = this.localToVworldIndex[0];
        this.mirrorBoundingLeaf.parent = this.parent;
        if (this.region != null) {
            this.mirrorBoundingLeaf.region = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion.transform(this.mirrorBoundingLeaf.getCurrentLocalToVworld());
        } else {
            this.mirrorBoundingLeaf.region = null;
            this.mirrorBoundingLeaf.transformedRegion = null;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorBoundingLeaf, 5);
        }
        this.mirrorBoundingLeaf.switchState = s.switchStates.get(0);
        super.markAsLive();
    }

    synchronized void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        Bounds b = (Bounds)objs[2];
        if ((component & 1) != 0) {
            this.mirrorBoundingLeaf.region = b;
            if (b != null) {
                this.mirrorBoundingLeaf.transformedRegion = (Bounds)b.clone();
                Transform3D t = this.mirrorBoundingLeaf.getCurrentLocalToVworld();
                this.mirrorBoundingLeaf.transformedRegion.transform(b, t);
            } else {
                this.mirrorBoundingLeaf.transformedRegion = null;
            }
        }
    }

    synchronized void addUser(LeafRetained node) {
        this.users.add(node);
        if (node.nodeType == 1 || node.nodeType == 2 || node.nodeType == 27 || node instanceof FogRetained || node instanceof LightRetained) {
            this.transformTargetThreads |= 0x80;
        } else if (node instanceof BehaviorRetained) {
            this.transformTargetThreads |= 0x100;
            this.targetThreads |= 0x100;
        } else if (node instanceof SoundRetained || node.nodeType == 15) {
            this.transformTargetThreads |= 0x200;
        }
    }

    synchronized void removeUser(LeafRetained u) {
        this.users.remove(this.users.indexOf(u));
        this.transformTargetThreads = 4096;
        this.targetThreads = 4224;
        for (int i = 0; i < this.users.size(); ++i) {
            LeafRetained node = (LeafRetained)this.users.get(i);
            if (node.nodeType == 1 || node.nodeType == 2 || node.nodeType == 27 || node instanceof FogRetained || node instanceof LightRetained) {
                this.transformTargetThreads |= 0x80;
                continue;
            }
            if (node.nodeType == 17) {
                this.transformTargetThreads |= 0x100;
                this.targetThreads |= 0x100;
                continue;
            }
            if (!(node instanceof SoundRetained) && node.nodeType != 15) continue;
            this.transformTargetThreads |= 0x200;
        }
    }

    void updateImmediateTransformChange() {
        Transform3D t = this.getCurrentLocalToVworld();
        if (this.region != null) {
            this.transformedRegion.transform(this.region, t);
        }
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive();
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorBoundingLeaf, 5);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorBoundingLeaf, 5);
            s.notifyThreads |= 0x2000;
        }
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        this.region.transform(xform.transform);
    }
}

