/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.ImageComponentRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;

public abstract class ImageComponent
extends NodeComponent {
    public static final int FORMAT_RGB = 1;
    public static final int FORMAT_RGBA = 2;
    public static final int FORMAT_RGB8 = 1;
    public static final int FORMAT_RGBA8 = 2;
    public static final int FORMAT_RGB5 = 3;
    public static final int FORMAT_RGB5_A1 = 4;
    public static final int FORMAT_RGB4 = 5;
    public static final int FORMAT_RGBA4 = 6;
    public static final int FORMAT_LUM4_ALPHA4 = 7;
    public static final int FORMAT_LUM8_ALPHA8 = 8;
    public static final int FORMAT_R3_G3_B2 = 9;
    public static final int FORMAT_CHANNEL8 = 10;
    static final int FORMAT_TOTAL = 10;
    public static final int ALLOW_SIZE_READ = 0;
    public static final int ALLOW_FORMAT_READ = 1;
    public static final int ALLOW_IMAGE_READ = 2;
    public static final int ALLOW_IMAGE_WRITE = 3;
    private static final int[] readCapabilities = new int[]{0, 2, 1};

    ImageComponent() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ImageComponent(int format, int width, int height) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ImageComponentRetained)this.retained).processParams(format, width, height, 1);
    }

    public ImageComponent(int format, int width, int height, boolean byReference, boolean yUp) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).processParams(format, width, height, 1);
    }

    public int getWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent0"));
        }
        return ((ImageComponentRetained)this.retained).getWidth();
    }

    public int getHeight() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent1"));
        }
        return ((ImageComponentRetained)this.retained).getHeight();
    }

    public int getFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2"));
        }
        return ((ImageComponentRetained)this.retained).getFormat();
    }

    public boolean isByReference() {
        return ((ImageComponentRetained)this.retained).isByReference();
    }

    public void setYUp(boolean yUp) {
        this.checkForLiveOrCompiled();
        if (((ImageComponentRetained)this.retained).getImageClass() == ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalStateException("ImageComponent4");
        }
        ((ImageComponentRetained)this.retained).setYUp(yUp);
    }

    public boolean isYUp() {
        return ((ImageComponentRetained)this.retained).isYUp();
    }

    public ImageClass getImageClass() {
        return ((ImageComponentRetained)this.retained).getImageClass();
    }

    public static enum ImageClass {
        BUFFERED_IMAGE,
        RENDERED_IMAGE,
        NIO_IMAGE_BUFFER;

    }
}

