/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility.geom;

import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public class GeomUtils {
    public static Pair<RealPoint, Double> smallestEnclosingSphere(List<RealPoint> pts) {
        RealPoint p = null;
        RealPoint q = null;
        double maxSqrDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < pts.size(); ++i) {
            for (int j = i + 1; j < pts.size(); ++j) {
                double d = GeomUtils.squaredDistance((RealLocalizable)pts.get(i), (RealLocalizable)pts.get(j));
                if (!(d < maxSqrDist)) continue;
                maxSqrDist = d;
                p = pts.get(i);
                q = pts.get(j);
            }
        }
        RealPoint center = new RealPoint(p.numDimensions());
        for (int d = 0; d < p.numDimensions(); ++d) {
            center.setPosition(0.5 * p.getDoublePosition(d) + 0.5 * q.getDoublePosition(d), d);
        }
        return new ValuePair((Object)center, (Object)maxSqrDist);
    }

    public static final void scale(RealPoint p, double scale) {
        for (int i = 0; i < p.numDimensions(); ++i) {
            p.setPosition(p.getDoublePosition(i) * scale, i);
        }
    }

    public static final double squaredDistance(RealLocalizable position1, RealLocalizable position2) {
        double dist = 0.0;
        int n = position1.numDimensions();
        for (int d = 0; d < n; ++d) {
            double pos = position2.getDoublePosition(d) - position1.getDoublePosition(d);
            dist += pos * pos;
        }
        return dist;
    }

    public static final double squaredDistance(double[] position1, double[] position2) {
        double dist = 0.0;
        int n = position1.length;
        for (int d = 0; d < n; ++d) {
            double pos = position2[d] - position1[d];
            dist += pos * pos;
        }
        return dist;
    }

    public static AffineTransform2D fromScalesAngle(double ... p) {
        return GeomUtils.fromScalesAngle(p[0], p[1], p[2]);
    }

    public static AffineTransform2D fromScalesAngle(double sx, double sy, double tht) {
        AffineTransform2D t = new AffineTransform2D();
        double cosTht = Math.cos(tht);
        double sinTht = Math.sin(tht);
        t.set(new double[]{sx * cosTht, -sx * sinTht, 0.0, sy * sinTht, sy * cosTht, 0.0});
        return t;
    }

    public static double[] scalesAngle(AffineTransform2D t) {
        double a = t.get(0, 0);
        double b = t.get(0, 1);
        double c = t.get(1, 0);
        double d = t.get(1, 1);
        double sa = a >= 0.0 ? 1.0 : -1.0;
        double sd = d >= 0.0 ? 1.0 : -1.0;
        double mab = Math.sqrt(a * a + b * b);
        double mcd = Math.sqrt(c * c + d * d);
        double sx = sa * mab;
        double sy = sd * mcd;
        double tht = Math.atan2(-b, a);
        return new double[]{sx, sy, tht};
    }

    public static double[] scalesAngle(AffineTransform2D t, double[] center) {
        double a = t.get(0, 0);
        double b = t.get(0, 1);
        double c = t.get(1, 0);
        double d = t.get(1, 1);
        double sa = 1.0;
        double sd = 1.0;
        double mab = Math.sqrt(a * a + b * b);
        double mcd = Math.sqrt(c * c + d * d);
        double sx = 1.0 * mab;
        double sy = 1.0 * mcd;
        double tht = Math.atan2(-b, a);
        return new double[]{sx, sy, tht};
    }

    public static double[] evals2d(AffineGet a) {
        double m = GeomUtils.trace2d(a) / 2.0;
        double p = GeomUtils.det2d(a);
        double d = Math.sqrt(m * m - p);
        return new double[]{m + d, m - d};
    }

    public static double det2d(AffineGet a) {
        return a.get(0, 0) * a.get(1, 1) - a.get(1, 0) * a.get(0, 1);
    }

    public static double trace2d(AffineGet a) {
        return a.get(0, 0) + a.get(1, 1);
    }

    public static AffineTransform2D centeredRotation(double tht, double[] c) {
        AffineTransform2D t = new AffineTransform2D();
        t.translate(new double[]{-c[0], -c[1]});
        t.rotate(tht);
        t.translate(c);
        return t;
    }

    public static AffineTransform2D centeredSimilarity(double tht, double scale, double[] c) {
        AffineTransform2D t = new AffineTransform2D();
        t.translate(new double[]{-c[0], -c[1]});
        t.rotate(tht);
        t.scale(scale);
        t.translate(c);
        return t;
    }
}

