/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.fft;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.fft.CreateOutputFFTMethods;
import net.imagej.ops.filter.fft.FFTMethodsOpC;
import net.imagej.ops.filter.pad.PadInputFFTMethods;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FFT.class, priority=100.0)
public class FFTMethodsOpF<T extends RealType<T>, C extends ComplexType<C>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<C>>
implements Ops.Filter.FFT {
    @Parameter(required=false)
    private long[] borderSize = null;
    @Parameter(required=false)
    private boolean fast = true;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> obf;
    @Parameter(required=false)
    private C fftType;
    private BinaryFunctionOp<RandomAccessibleInterval<T>, Dimensions, RandomAccessibleInterval<T>> padOp;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval<C>> createOp;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<C>> fftMethodsOp;

    @Override
    public void initialize() {
        super.initialize();
        if (this.fftType == null) {
            this.fftType = (ComplexType)this.ops().create().nativeType(ComplexFloatType.class);
        }
        this.padOp = Functions.binary(this.ops(), PadInputFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.fast});
        this.createOp = Functions.unary(this.ops(), CreateOutputFFTMethods.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.fftType, this.fast});
        this.fftMethodsOp = (UnaryComputerOp)Computers.nullary(this.ops(), FFTMethodsOpC.class, RandomAccessibleInterval.class, new Object[]{RandomAccessibleInterval.class});
    }

    @Override
    public RandomAccessibleInterval<C> calculate(RandomAccessibleInterval<T> input) {
        long[] paddedSize = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
        for (int d = 0; d < ((RandomAccessibleInterval)this.in()).numDimensions(); ++d) {
            paddedSize[d] = ((RandomAccessibleInterval)this.in()).dimension(d);
            if (this.borderSize == null) continue;
            int n = d;
            paddedSize[n] = paddedSize[n] + this.borderSize[d];
        }
        FinalDimensions paddedDimensions = new FinalDimensions(paddedSize);
        RandomAccessibleInterval<C> output = this.createOp.calculate((Dimensions)paddedDimensions);
        RandomAccessibleInterval<T> paddedInput = this.padOp.calculate(input, (Dimensions)paddedDimensions);
        this.fftMethodsOp.compute(paddedInput, output);
        return output;
    }
}

