/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.concurrent.Callable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;

class InitPhaseCal<B extends BooleanType<B>, T extends RealType<T>>
implements Callable<Void> {
    private final double[] actualValues;
    private final RandomAccess<B> raIn;
    private final int infinite;
    private final int[] dimensSizes;
    private final int[] positions;
    private final double[] calibration;

    public InitPhaseCal(double[] actualValues, RandomAccessibleInterval<B> raIn, int[] dimensSizes, int[] positions, double[] calibration) {
        this.actualValues = actualValues;
        this.raIn = raIn.randomAccess();
        int inf = 0;
        for (int i = 0; i < dimensSizes.length; ++i) {
            inf = (int)((double)inf + calibration[i] * calibration[i] * (double)dimensSizes[i] * (double)dimensSizes[i]);
        }
        this.infinite = inf;
        this.dimensSizes = dimensSizes;
        this.positions = positions;
        this.calibration = calibration;
    }

    @Override
    public Void call() throws Exception {
        int[] temp;
        int x;
        this.positions[0] = 0;
        this.raIn.setPosition(this.positions);
        this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = !((BooleanType)this.raIn.get()).get() ? 0.0 : (double)this.infinite;
        for (x = 1; x < this.dimensSizes[0]; ++x) {
            this.positions[0] = x;
            this.raIn.setPosition(this.positions);
            if (!((BooleanType)this.raIn.get()).get()) {
                this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = 0.0;
                continue;
            }
            temp = (int[])this.positions.clone();
            temp[0] = x - 1;
            this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = this.actualValues[IntervalIndexer.positionToIndex((int[])temp, (int[])this.dimensSizes)] + this.calibration[0];
        }
        for (x = this.dimensSizes[0] - 2; x >= 0; --x) {
            this.positions[0] = x;
            temp = (int[])this.positions.clone();
            temp[0] = x + 1;
            if (!(this.actualValues[IntervalIndexer.positionToIndex((int[])temp, (int[])this.dimensSizes)] < this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)])) continue;
            this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = this.calibration[0] + this.actualValues[IntervalIndexer.positionToIndex((int[])temp, (int[])this.dimensSizes)];
        }
        return null;
    }
}

