/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.labeling;

import java.util.Collection;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.map.Maps;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Labeling.Merge.class, priority=100.0)
public class MergeLabeling<L, I extends IntegerType<I>, B extends BooleanType<B>>
extends AbstractBinaryHybridCF<ImgLabeling<L, I>, ImgLabeling<L, I>, ImgLabeling<L, I>>
implements Contingent,
Ops.Labeling.Merge {
    @Parameter(required=false)
    private RandomAccessibleInterval<B> mask;
    private UnaryFunctionOp<Interval, ImgLabeling<L, I>> imgLabelingCreator;

    @Override
    public void initialize() {
        this.imgLabelingCreator = Functions.unary(this.ops(), Ops.Create.ImgLabeling.class, ImgLabeling.class, this.in(), new Object[0]);
    }

    @Override
    public boolean conforms() {
        if (this.out() == null) {
            return true;
        }
        return Intervals.equalDimensions((Interval)((Interval)this.in()), (Interval)((Interval)this.out()));
    }

    @Override
    public void compute(ImgLabeling<L, I> input1, ImgLabeling<L, I> input2, ImgLabeling<L, I> output) {
        if (this.mask != null) {
            IterableRegion iterable = Regions.iterable(this.mask);
            IterableInterval sample = Regions.sample((IterableInterval)iterable.inside(), output);
            RandomAccess randomAccess = input1.randomAccess();
            RandomAccess randomAccess2 = input2.randomAccess();
            Cursor cursor = sample.cursor();
            while (cursor.hasNext()) {
                LabelingType outLabeling = (LabelingType)cursor.next();
                randomAccess.setPosition((Localizable)cursor);
                outLabeling.addAll((Collection)randomAccess.get());
                randomAccess2.setPosition((Localizable)cursor);
                outLabeling.addAll((Collection)randomAccess2.get());
            }
        } else {
            Maps.map(input1, input2, output, new AbstractBinaryComputerOp<LabelingType<L>, LabelingType<L>, LabelingType<L>>(){

                @Override
                public void compute(LabelingType<L> input1, LabelingType<L> input2, LabelingType<L> output) {
                    output.addAll(input1);
                    output.addAll(input2);
                }
            });
        }
    }

    @Override
    public ImgLabeling<L, I> createOutput(ImgLabeling<L, I> input1, ImgLabeling<L, I> input2) {
        return this.imgLabelingCreator.calculate((Interval)input1);
    }
}

