/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.correlate;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.plugins.commands.correlate.Correlation3x3Operation;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Smooth", weight=1.0, accelerator="shift ^S")}, headless=true, attrs={@Attr(name="no-legacy")})
public class SmoothDataValues
extends ContextCommand {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        Dataset input = this.imageDisplayService.getActiveDataset(this.display);
        RealRect selection = this.overlayService.getSelectionBounds(this.display);
        double[] kernel = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        Correlation3x3Operation operation = new Correlation3x3Operation(input, selection, kernel);
        operation.run();
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }
}

