/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class CellLocalizableByDimCursor<T extends Type<T>>
extends CellLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    final ArrayLocalizableByDimCursor<FakeType> cursor;
    protected final int numCells;
    protected final int[] numCellsDim;
    protected final int[] cellPosition;
    protected final int[] cellEnd;
    protected final int[] step;
    protected final int[] cellStep;
    int numNeighborhoodCursors = 0;
    final int[] tmp;

    public CellLocalizableByDimCursor(CellContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.numCells = container.getNumCells();
        this.numCellsDim = container.getNumCellsDim();
        this.cellPosition = new int[this.numDimensions];
        this.cellEnd = new int[this.numDimensions];
        this.step = new int[this.numDimensions];
        this.cellStep = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.cursor = ArrayLocalizableByDimCursor.createLinearByDimCursor(this.numCellsDim);
        this.cursor.setPosition(new int[container.getNumDimensions()]);
        Array.createAllocationSteps(this.numCellsDim, this.cellStep);
        this.reset();
    }

    @Override
    protected void getCellData(int cell) {
        if (cell == this.lastCell) {
            return;
        }
        this.lastCell = cell;
        this.cellInstance = this.container.getCell(cell);
        this.cellMaxI = this.cellInstance.getNumPixels();
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        for (int d = 0; d < this.numDimensions; ++d) {
            this.cellEnd[d] = this.cellOffset[d] + this.cellDimensions[d];
        }
        this.cellInstance.getSteps(this.step);
        this.type.updateContainer(this);
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("CellLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] offset, int[] size) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, offset, size);
        }
        System.out.println("CellLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI - 1) {
            this.type.incIndex();
            for (int d = 0; d < this.numDimensions; ++d) {
                if (this.position[d] >= this.cellDimensions[d] + this.cellOffset[d] - 1) continue;
                int n = d;
                this.position[n] = this.position[n] + 1;
                for (int e = 0; e < d; ++e) {
                    this.position[e] = this.cellOffset[e];
                }
                break;
            }
        } else if (this.cell < this.numCells - 1) {
            ++this.cell;
            this.type.updateIndex(0);
            this.getCellData(this.cell);
            for (int d = 0; d < this.numDimensions; ++d) {
                this.position[d] = this.cellOffset[d];
            }
            this.container.getCellPosition(this.position, this.cellPosition);
            this.cursor.setPosition(this.cellPosition);
        } else {
            this.lastCell = -1;
            this.type.updateIndex(this.cellMaxI);
            this.cell = this.numCells;
        }
    }

    @Override
    public void reset() {
        if (this.cellEnd == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.position[0] = -1;
        this.cellPosition[0] = 0;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
            this.cellPosition[d] = 0;
        }
        this.cursor.setPosition(this.cellPosition);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd(int dim) {
        if (this.position[dim] + 1 < this.cellEnd[dim]) {
            this.type.incIndex(this.step[dim]);
            int n = dim;
            this.position[n] = this.position[n] + 1;
        } else {
            this.cursor.fwd(dim);
            if (this.cellPosition[dim] < this.numCellsDim[dim] - 2) {
                int n = dim;
                this.cellPosition[n] = this.cellPosition[n] + 1;
                this.cell += this.cellStep[dim];
                this.type.decIndex((this.position[dim] - this.cellOffset[dim]) * this.step[dim]);
                this.getCellData(this.cell);
                int n2 = dim;
                this.position[n2] = this.position[n2] + 1;
            } else {
                int n = dim;
                this.cellPosition[n] = this.cellPosition[n] + 1;
                this.cell += this.cellStep[dim];
                this.getCellData(this.cell);
                int n3 = dim;
                this.position[n3] = this.position[n3] + 1;
                this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
            }
        }
    }

    @Override
    public void move(int steps, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + steps;
        if (this.position[dim] < this.cellEnd[dim] && this.position[dim] >= this.cellOffset[dim]) {
            this.type.incIndex(this.step[dim] * steps);
        } else {
            this.setPosition(this.position[dim], dim);
        }
    }

    @Override
    public void moveRel(int[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.move(vector[d], d);
        }
    }

    @Override
    public void moveTo(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int dist = position[d] - this.getPosition(d);
            if (dist == 0) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void bck(int dim) {
        if (this.position[dim] - 1 >= this.cellOffset[dim]) {
            this.type.decIndex(this.step[dim]);
            int n = dim;
            this.position[n] = this.position[n] - 1;
        } else {
            this.cursor.bck(dim);
            if (this.cellPosition[dim] == this.numCellsDim[dim] - 1 && this.numCells != 1) {
                int n = dim;
                this.cellPosition[n] = this.cellPosition[n] - 1;
                this.cell -= this.cellStep[dim];
                this.getCellData(this.cell);
                int n2 = dim;
                this.position[n2] = this.position[n2] - 1;
                this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
            } else {
                int n = dim;
                this.cellPosition[n] = this.cellPosition[n] - 1;
                this.cell -= this.cellStep[dim];
                this.type.decIndex((this.position[dim] - this.cellOffset[dim]) * this.step[dim]);
                this.getCellData(this.cell);
                this.type.incIndex((this.cellDimensions[dim] - 1) * this.step[dim]);
                int n3 = dim;
                this.position[n3] = this.position[n3] - 1;
            }
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
        this.container.getCellPosition(position, this.cellPosition);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(position));
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        this.cellPosition[dim] = this.container.getCellPosition(position, dim);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition[dim], dim);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
    }

    @Override
    public void close() {
        this.cursor.close();
        if (!this.isClosed) {
            this.lastCell = -1;
            this.isClosed = true;
        }
    }
}

