/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class PlanarLocalizablePlaneCursor<T extends Type<T>>
extends PlanarLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    private int xIndex;
    private int yIndex;
    private int xSize;
    private int ySize;
    private int pos;
    private int maxPos;
    private final int[] sliceSteps;
    private int width;
    private int planeSize;

    public PlanarLocalizablePlaneCursor(PlanarContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type, false);
        this.sliceSteps = new int[this.numDimensions + 1];
        if (this.sliceSteps.length > 2) {
            this.sliceSteps[2] = 1;
            for (int i = 3; i < this.sliceSteps.length; ++i) {
                int j = i - 1;
                this.sliceSteps[i] = this.dimensions[j] * this.sliceSteps[j];
            }
        }
        this.width = image.getDimension(0);
        this.planeSize = this.width * image.getDimension(1);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.maxPos;
    }

    @Override
    public void fwd() {
        ++this.pos;
        boolean needUpdate = false;
        int n = this.xIndex;
        this.position[n] = this.position[n] + 1;
        if (this.position[n] == this.xSize) {
            this.position[this.xIndex] = 0;
            switch (this.xIndex) {
                case 0: {
                    this.type.decIndex(this.width - 1);
                    break;
                }
                case 1: {
                    this.type.decIndex(this.planeSize - 1);
                    break;
                }
                default: {
                    this.sliceIndex -= this.sliceSteps[this.xIndex + 1] - 1;
                    needUpdate = true;
                }
            }
            int n2 = this.yIndex;
            this.position[n2] = this.position[n2] + 1;
            switch (this.yIndex) {
                case 0: {
                    this.type.incIndex();
                    break;
                }
                case 1: {
                    this.type.incIndex(this.width);
                    break;
                }
                default: {
                    this.sliceIndex += this.sliceSteps[this.yIndex];
                    needUpdate = true;
                    break;
                }
            }
        } else {
            switch (this.xIndex) {
                case 0: {
                    this.type.incIndex();
                    break;
                }
                case 1: {
                    this.type.incIndex(this.width);
                    break;
                }
                default: {
                    this.sliceIndex += this.sliceSteps[this.xIndex];
                    needUpdate = true;
                }
            }
        }
        if (needUpdate) {
            this.type.updateContainer(this);
        }
    }

    @Override
    public void reset(int planeDimA, int planeDimB, int[] dimensionPositions) {
        this.xIndex = planeDimA;
        this.yIndex = planeDimB;
        int[] dimPos = (int[])dimensionPositions.clone();
        dimPos[planeDimA] = 0;
        dimPos[planeDimB] = 0;
        this.setPosition(dimPos);
        this.xSize = this.image.getDimension(planeDimA);
        this.ySize = this.image.getDimension(planeDimB);
        this.maxPos = this.xSize * this.ySize;
        this.pos = 0;
        this.isClosed = false;
        switch (planeDimA) {
            case 0: {
                this.type.decIndex();
                break;
            }
            case 1: {
                this.type.decIndex(-this.width);
                break;
            }
            default: {
                this.sliceIndex -= this.sliceSteps[planeDimA];
            }
        }
        this.position[planeDimA] = -1;
    }

    @Override
    public void reset(int planeDimA, int planeDimB) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(planeDimA, planeDimB, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] p) {
        for (int d = 0; d < this.numDimensions; ++d) {
            p[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    private void setPosition(int[] position) {
        int d;
        this.type.updateIndex(this.container.getIndex(position));
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
        this.sliceIndex = 0;
        for (d = 2; d < this.numDimensions; ++d) {
            this.sliceIndex += position[d] * this.sliceSteps[d];
        }
        this.type.updateContainer(this);
    }
}

