/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.ImageProperties;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.vector.Dimensionality;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.util.Util;

public class Image<T extends Type<T>>
implements ImageProperties,
Dimensionality,
Collection<T> {
    protected final ArrayList<Cursor<T>> cursors;
    final ContainerFactory containerFactory;
    final Container<T> container;
    final ImageFactory<T> imageFactory;
    final T type;
    static final AtomicLong i = new AtomicLong();
    static final AtomicLong j = new AtomicLong();
    protected String name;
    protected final float[] calibration;
    protected Display<T> display;

    private Image(Container<T> container, ImageFactory<T> imageFactory, int[] dim, String name) {
        this.name = name == null || name.length() == 0 ? "image" + i.getAndIncrement() : name;
        if (dim == null || dim.length < 1) {
            System.err.print("Cannot instantiate Image, dimensions are null. Creating a 1D image of size 1.");
            dim = new int[]{1};
        }
        for (int i = 0; i < dim.length; ++i) {
            if (dim[i] > 0) continue;
            System.err.print("Warning: Image dimension " + (i + 1) + " does not make sense: size=" + dim[i] + ". Replacing it by 1.");
            dim[i] = 1;
        }
        this.cursors = new ArrayList();
        this.containerFactory = imageFactory.getContainerFactory();
        this.imageFactory = imageFactory;
        this.type = this.createType();
        this.container = container == null ? this.containerFactory.createContainer(dim, this.type) : container;
        this.setDefaultDisplay();
        this.calibration = new float[this.getContainer().getNumDimensions()];
        for (int d = 0; d < this.getContainer().getNumDimensions(); ++d) {
            this.calibration[d] = 1.0f;
        }
    }

    public Image(Container<T> container, T type) {
        this(container, type, null);
    }

    public Image(Container<T> container, T type, String name) {
        this(container, new ImageFactory<T>(type, container.getFactory()), container.getDimensions(), name);
    }

    protected Image(ImageFactory<T> imageFactory, int[] dim, String name) {
        this(null, imageFactory, dim, name);
    }

    public Image<T> createNewImage(int[] dimensions, String name) {
        Image<T> newImage = this.imageFactory.createImage(dimensions, name);
        if (newImage.getNumDimensions() == this.getNumDimensions()) {
            newImage.setCalibration(this.getCalibration());
        }
        return newImage;
    }

    public Image<T> createNewImage(int[] dimensions) {
        return this.createNewImage(dimensions, null);
    }

    public Image<T> createNewImage(String name) {
        return this.createNewImage(this.getContainer().getDimensions(), name);
    }

    public Image<T> createNewImage() {
        return this.createNewImage(this.getContainer().getDimensions(), null);
    }

    public float[] getCalibration() {
        return (float[])this.calibration.clone();
    }

    public float getCalibration(int dim) {
        return this.calibration[dim];
    }

    public void setCalibration(float[] calibration) {
        for (int d = 0; d < this.getContainer().getNumDimensions(); ++d) {
            this.calibration[d] = calibration[d];
        }
    }

    public void setCalibration(float calibration, int dim) {
        this.calibration[dim] = calibration;
    }

    public Container<T> getContainer() {
        return this.container;
    }

    public T createType() {
        return this.imageFactory.createType();
    }

    public Cursor<T> createCursor() {
        Cursor<T> cursor = this.container.createCursor(this);
        this.addCursor(cursor);
        return cursor;
    }

    public LocalizableCursor<T> createLocalizableCursor() {
        LocalizableCursor<T> cursor = this.container.createLocalizableCursor(this);
        this.addCursor(cursor);
        return cursor;
    }

    public LocalizablePlaneCursor<T> createLocalizablePlaneCursor() {
        LocalizablePlaneCursor<T> cursor = this.container.createLocalizablePlaneCursor(this);
        this.addCursor(cursor);
        return cursor;
    }

    public LocalizableByDimCursor<T> createLocalizableByDimCursor() {
        LocalizableByDimCursor<T> cursor = this.container.createLocalizableByDimCursor(this);
        this.addCursor(cursor);
        return cursor;
    }

    public LocalizableByDimCursor<T> createLocalizableByDimCursor(OutOfBoundsStrategyFactory<T> factory) {
        LocalizableByDimCursor<T> cursor = this.container.createLocalizableByDimCursor(this, factory);
        this.addCursor(cursor);
        return cursor;
    }

    public Interpolator<T> createInterpolator(InterpolatorFactory<T> factory) {
        return factory.createInterpolator(this);
    }

    public void setDefaultDisplay() {
        this.display = this.type.getDefaultDisplay(this);
    }

    public Display<T> getDisplay() {
        return this.display;
    }

    public void setDisplay(Display<T> display) {
        this.display = display;
    }

    public static final synchronized long createUniqueId() {
        return j.getAndIncrement();
    }

    public void close() {
        this.closeAllCursors();
        this.container.close();
    }

    public int[] createPositionArray() {
        return new int[this.getNumDimensions()];
    }

    @Override
    public int getNumDimensions() {
        return this.getContainer().getNumDimensions();
    }

    @Override
    public int[] getDimensions() {
        return this.getContainer().getDimensions();
    }

    @Override
    public int getNumPixels() {
        return this.getContainer().getNumPixels();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Image '" + this.getName() + "', dim=" + Util.printCoordinates(this.getContainer().getDimensions());
    }

    @Override
    public void getDimensions(int[] dimensions) {
        for (int i = 0; i < this.getContainer().getNumDimensions(); ++i) {
            dimensions[i] = this.getContainer().getDimension(i);
        }
    }

    @Override
    public int getDimension(int dim) {
        return this.getContainer().getDimension(dim);
    }

    public Image<T> clone() {
        Image<T> clone = this.createNewImage();
        Cursor<T> c1 = this.createCursor();
        Cursor<T> c2 = clone.createCursor();
        while (c1.hasNext()) {
            c1.fwd();
            c2.fwd();
            c2.getType().set(c1.getType());
        }
        c1.close();
        c2.close();
        return clone;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public ImageFactory<T> getImageFactory() {
        return this.imageFactory;
    }

    public void removeAllCursors() {
        this.closeAllCursors();
        this.cursors.clear();
    }

    public void closeAllCursors() {
        for (Cursor<T> i : this.cursors) {
            i.close();
        }
    }

    public void getCursors(Collection<Cursor<T>> collection) {
        collection.addAll(this.cursors);
    }

    public ArrayList<Cursor<T>> getCursors() {
        return new ArrayList<Cursor<T>>(this.cursors);
    }

    public ArrayList<Cursor<T>> getActiveCursors() {
        ArrayList<Cursor<T>> activeCursors = new ArrayList<Cursor<T>>();
        for (Cursor<T> i : this.cursors) {
            if (!i.isActive()) continue;
            activeCursors.add(i);
        }
        return activeCursors;
    }

    protected synchronized void addCursor(Cursor<T> c) {
        this.cursors.add(c);
    }

    protected synchronized void removeCursor(Cursor<T> c) {
        c.close();
        this.cursors.remove(c);
    }

    public int getNumCursors() {
        return this.cursors.size();
    }

    public int getNumActiveCursors() {
        int active = 0;
        for (Cursor<T> i : this.cursors) {
            if (!i.isActive()) continue;
            ++active;
        }
        return active;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException("Image.add(): not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Image.addAll(): not supported.");
    }

    @Override
    public void clear() {
        T zeroValue = this.createType();
        for (Type type : this) {
            type.set(zeroValue);
        }
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Image.contains(): not supported.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Image.containsAll(): not supported.");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.createCursor();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Image.remove(): not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Image.removeAll(): not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Image.retainAll(): not supported.");
    }

    @Override
    public int size() {
        return this.getNumPixels();
    }

    @Override
    public T[] toArray() {
        Type[] pixels = this.createType().createArray1D(this.getNumPixels());
        ArrayLocalizableCursor<FakeType> cursor1 = ArrayLocalizableCursor.createLinearCursor(this.getDimensions());
        LocalizableByDimCursor<T> cursor2 = this.createLocalizableByDimCursor();
        int i = 0;
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.moveTo(cursor1);
            pixels[i++] = cursor2.getType().copy();
        }
        cursor1.close();
        cursor2.close();
        return pixels;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException("Image.toArray<E>(): not supported, use T[] toArray or T[] toArray( T[] a ) instead.");
    }
}

