/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.ComplexType;

public class ComplexTypePowerSpectrumDisplay<T extends ComplexType<T>>
extends Display<T> {
    public ComplexTypePowerSpectrumDisplay(Image<T> img) {
        super(img);
    }

    @Override
    public void setMinMax() {
        Cursor c = this.img.createCursor();
        if (!c.hasNext()) {
            this.min = -3.4028234663852886E38;
            this.max = 3.4028234663852886E38;
            return;
        }
        c.fwd();
        this.min = this.max = (double)this.getComplexDisplayValue((ComplexType)c.getType());
        while (c.hasNext()) {
            c.fwd();
            double value = this.getComplexDisplayValue((ComplexType)c.getType());
            if (value > this.max) {
                this.max = value;
                continue;
            }
            if (!(value < this.min)) continue;
            this.min = value;
        }
        c.close();
    }

    protected float getComplexDisplayValue(T c) {
        return c.getPowerFloat();
    }

    @Override
    public float get32Bit(T c) {
        return this.getComplexDisplayValue(c);
    }

    @Override
    public float get32BitNormed(T c) {
        return this.normFloat(this.getComplexDisplayValue(c));
    }

    @Override
    public byte get8BitSigned(T c) {
        return (byte)Math.round(this.normFloat(this.getComplexDisplayValue(c)) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T c) {
        return (short)Math.round(this.normFloat(this.getComplexDisplayValue(c)) * 255.0f);
    }
}

