/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.fxwidgets;

import javafx.event.Event;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;

public class UpperLowerSynchronizer {
    private SliderLabelSynchronizer lowerSync;
    private SliderLabelSynchronizer upperSync;

    public UpperLowerSynchronizer(Slider lowerSlider, TextField lowerTextField, Slider upperSlider, TextField upperTextField) {
        this.lowerSync = new SliderLabelSynchronizer(lowerSlider, lowerTextField);
        this.upperSync = new SliderLabelSynchronizer(upperSlider, upperTextField);
        this.lowerSync.setValue(0.0);
        this.upperSync.setValue(1.0);
    }

    public void setUpperValue(double value) {
        if (value <= this.lowerSync.getValue()) {
            value = this.lowerSync.getValue() + 0.01;
        }
        this.upperSync.setValue(value);
    }

    public void setLowerValue(double value) {
        if (value >= this.upperSync.getValue()) {
            value = this.upperSync.getValue() - 0.01;
        }
        this.lowerSync.setValue(value);
    }

    public double getLowerValue() {
        return this.lowerSync.getValue();
    }

    public double getUpperValue() {
        return this.upperSync.getValue();
    }

    public boolean isEvent(Event event) {
        return this.upperSync.isEvent(event) || this.lowerSync.isEvent(event);
    }

    public void update(Event event) {
        if (this.upperSync.isEvent(event)) {
            this.upperSync.update(event);
            if (this.upperSync.getValue() <= this.lowerSync.getValue()) {
                this.upperSync.setValue(this.lowerSync.getValue() + 0.01);
            }
        } else if (this.lowerSync.isEvent(event)) {
            this.lowerSync.update(event);
            if (this.lowerSync.getValue() >= this.upperSync.getValue()) {
                this.lowerSync.setValue(this.upperSync.getValue() - 0.01);
            }
        }
    }

    public void setUpperTooltip(String tooltipMessage) {
        this.upperSync.setTooltip(tooltipMessage);
    }

    public void setLowerTooltip(String tooltipMessage) {
        this.lowerSync.setTooltip(tooltipMessage);
    }
}

