/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.tracking.lap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultWeightedEdge;
import sc.fiji.filamentdetector.model.Filament;

public class FilamentGraphSegmentSplitter {
    private final List<Filament> segmentStarts;
    private final List<Filament> segmentEnds;
    private final List<List<Filament>> segmentMiddles;

    public FilamentGraphSegmentSplitter(Graph<Filament, DefaultWeightedEdge> graph, boolean findMiddlePoints) {
        ConnectivityInspector connectivity = new ConnectivityInspector(graph);
        List connectedSets = connectivity.connectedSets();
        Comparator<Filament> framecomparator = Filament.frameComparator;
        this.segmentStarts = new ArrayList<Filament>(connectedSets.size());
        this.segmentEnds = new ArrayList<Filament>(connectedSets.size());
        this.segmentMiddles = findMiddlePoints ? new ArrayList<List<Filament>>(connectedSets.size()) : Collections.emptyList();
        for (Set set : connectedSets) {
            if (set.size() < 2) continue;
            ArrayList list = new ArrayList(set);
            Collections.sort(list, framecomparator);
            this.segmentEnds.add((Filament)list.remove(list.size() - 1));
            this.segmentStarts.add((Filament)list.remove(0));
            if (!findMiddlePoints) continue;
            this.segmentMiddles.add(list);
        }
    }

    public List<Filament> getSegmentEnds() {
        return this.segmentEnds;
    }

    public List<List<Filament>> getSegmentMiddles() {
        return this.segmentMiddles;
    }

    public List<Filament> getSegmentStarts() {
        return this.segmentStarts;
    }
}

