/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.ShortType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType16BitSignedInteger
extends AbstractContextual
implements DataType<ShortType> {
    private final ShortType type = new ShortType();

    @Override
    public ShortType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "16-bit int";
    }

    @Override
    public String longName() {
        return "16-bit signed integer";
    }

    @Override
    public String description() {
        return "A integer data type ranging between -32768 and 32767";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(ShortType dest) {
        dest.set((short)Short.MIN_VALUE);
    }

    @Override
    public void upperBound(ShortType dest) {
        dest.set((short)Short.MAX_VALUE);
    }

    @Override
    public int bitCount() {
        return 16;
    }

    @Override
    public ShortType createVariable() {
        return new ShortType();
    }

    @Override
    public void cast(ShortType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, ShortType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(ShortType val) {
        return val.get();
    }

    @Override
    public long asLong(ShortType val) {
        return val.get();
    }

    @Override
    public void setDouble(ShortType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(ShortType val, long v) {
        if (v < -32768L) {
            val.set((short)Short.MIN_VALUE);
        } else if (v > 32767L) {
            val.set((short)Short.MAX_VALUE);
        } else {
            val.set((short)v);
        }
    }
}

