/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.Arrays;

public class SRM_
implements PlugInFilter {
    ImagePlus image;
    final float g = 256.0f;
    protected float Q = 25.0f;
    protected float delta;
    protected float factor;
    protected float logDelta;
    float[] average;
    int[] count;
    int[] regionIndex;
    int[] nextNeighbor;
    int[] neighborBucket;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 129;
    }

    public void run(ImageProcessor ip) {
        boolean do3D;
        boolean isStack = this.image.getStackSize() > 1;
        GenericDialog gd = new GenericDialog("SRM");
        gd.addNumericField("Q", (double)this.Q, 2);
        gd.addCheckbox("showAverages", true);
        if (isStack) {
            gd.addCheckbox("3d", true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.Q = (float)gd.getNextNumber();
        boolean showAverages = gd.getNextBoolean();
        boolean bl = do3D = isStack ? gd.getNextBoolean() : false;
        if (do3D) {
            this.srm3D(showAverages).show();
        } else {
            this.srm2D(ip, showAverages).show();
        }
    }

    protected ImagePlus srm3D(boolean showAverages) {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int d = this.image.getStackSize();
        this.delta = 1.0f / (float)(6 * w * h * d);
        this.factor = 32768.0f / this.Q;
        this.logDelta = 2.0f * (float)Math.log(6 * w * h * d);
        IJ.showStatus((String)"Initializing regions");
        this.initializeRegions3D(w, h, d);
        IJ.showStatus((String)"Initializing neighbors");
        this.initializeNeighbors3D(w, h, d);
        IJ.showStatus((String)"Merging neighbors");
        this.mergeAllNeighbors3D(w, h);
        IJ.showStatus((String)"Making stack");
        ImageStack stack = new ImageStack(w, h);
        if (showAverages) {
            for (int k = 0; k < d; ++k) {
                int off = k * w * h;
                float[] p = new float[w * h];
                for (int i = 0; i < w * h; ++i) {
                    p[i] = this.average[this.getRegionIndex(i + off)];
                }
                stack.addSlice(null, (ImageProcessor)new FloatProcessor(w, h, p, null));
            }
        } else {
            int regionCount = this.consolidateRegions();
            if (regionCount > 65536) {
                IJ.showMessage((String)("Found " + regionCount + " regions, which does not fit in 16-bit."));
            }
            for (int k = 0; k < d; ++k) {
                ShortProcessor ip;
                int i;
                Object[] p;
                int off = k * w * h;
                if (regionCount > 256) {
                    p = new short[w * h];
                    for (i = 0; i < p.length; ++i) {
                        p[i] = (short)this.regionIndex[i + off];
                    }
                    ip = new ShortProcessor(w, h, p, null);
                } else {
                    p = new byte[w * h];
                    for (i = 0; i < p.length; ++i) {
                        p[i] = (byte)this.regionIndex[i + off];
                    }
                    ip = new ByteProcessor(w, h, (byte[])p, null);
                }
                stack.addSlice(null, (ImageProcessor)ip);
            }
        }
        IJ.showStatus((String)"");
        String title = this.image.getTitle() + " (SRM3D Q=" + this.Q + ")";
        return new ImagePlus(title, stack);
    }

    protected ImagePlus srm2D(ImageProcessor ip, boolean showAverages) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        this.delta = 1.0f / (float)(6 * w * h);
        this.factor = 32768.0f / this.Q;
        this.logDelta = 2.0f * (float)Math.log(6 * w * h);
        byte[] pixel = (byte[])ip.getPixels();
        this.initializeRegions2D(pixel, ip.getWidth(), ip.getHeight());
        this.initializeNeighbors2D(pixel, w, h);
        this.mergeAllNeighbors2D(w);
        if (showAverages) {
            for (int i = 0; i < this.average.length; ++i) {
                this.average[i] = this.average[this.getRegionIndex(i)];
            }
            ip = new FloatProcessor(w, h, this.average, null);
        } else {
            int regionCount = this.consolidateRegions();
            if (regionCount > 256) {
                if (regionCount > 65536) {
                    IJ.showMessage((String)("Found " + regionCount + " regions, which does not fit in 16-bit."));
                }
                short[] pixel16 = new short[w * h];
                for (int i = 0; i < pixel16.length; ++i) {
                    pixel16[i] = (short)this.regionIndex[i];
                }
                ip = new ShortProcessor(w, h, pixel16, null);
            } else {
                pixel = new byte[w * h];
                for (int i = 0; i < pixel.length; ++i) {
                    pixel[i] = (byte)this.regionIndex[i];
                }
                ip = new ByteProcessor(w, h, pixel, null);
            }
        }
        String title = this.image.getTitle() + " (SRM Q=" + this.Q + ")";
        return new ImagePlus(title, ip);
    }

    void initializeRegions2D(byte[] pixel, int w, int h) {
        this.average = new float[w * h];
        this.count = new int[w * h];
        this.regionIndex = new int[w * h];
        for (int i = 0; i < this.average.length; ++i) {
            this.average[i] = pixel[i] & 0xFF;
            this.count[i] = 1;
            this.regionIndex[i] = i;
        }
    }

    void initializeRegions3D(int w, int h, int d) {
        this.average = new float[w * h * d];
        this.count = new int[w * h * d];
        this.regionIndex = new int[w * h * d];
        for (int j = 0; j < d; ++j) {
            byte[] pixel = (byte[])this.image.getStack().getProcessor(j + 1).getPixels();
            int offset = j * w * h;
            for (int i = 0; i < w * h; ++i) {
                this.average[offset + i] = pixel[i] & 0xFF;
                this.count[offset + i] = 1;
                this.regionIndex[offset + i] = offset + i;
            }
        }
    }

    protected void addNeighborPair(int neighborIndex, byte[] pixel, int i1, int i2) {
        int difference = Math.abs((pixel[i1] & 0xFF) - (pixel[i2] & 0xFF));
        this.nextNeighbor[neighborIndex] = this.neighborBucket[difference];
        this.neighborBucket[difference] = neighborIndex;
    }

    void initializeNeighbors2D(byte[] pixel, int w, int h) {
        this.nextNeighbor = new int[2 * w * h];
        this.neighborBucket = new int[256];
        Arrays.fill(this.neighborBucket, -1);
        for (int j = h - 1; j >= 0; --j) {
            for (int i = w - 1; i >= 0; --i) {
                int index = i + w * j;
                int neighborIndex = 2 * index;
                if (j < h - 1) {
                    this.addNeighborPair(neighborIndex + 1, pixel, index, index + w);
                }
                if (i >= w - 1) continue;
                this.addNeighborPair(neighborIndex, pixel, index, index + 1);
            }
        }
    }

    protected void addNeighborPair(int neighborIndex, byte[] pixel, byte[] nextPixel, int i) {
        int difference = Math.abs((pixel[i] & 0xFF) - (nextPixel[i] & 0xFF));
        this.nextNeighbor[neighborIndex] = this.neighborBucket[difference];
        this.neighborBucket[difference] = neighborIndex;
    }

    void initializeNeighbors3D(int w, int h, int d) {
        this.nextNeighbor = new int[3 * w * h * d];
        this.neighborBucket = new int[256];
        Arrays.fill(this.neighborBucket, -1);
        byte[] nextPixel = null;
        for (int k = d - 1; k >= 0; --k) {
            byte[] pixel = (byte[])this.image.getStack().getProcessor(k + 1).getPixels();
            for (int j = h - 1; j >= 0; --j) {
                for (int i = w - 1; i >= 0; --i) {
                    int index = i + w * j;
                    int neighborIndex = 3 * (index + k * w * h);
                    if (nextPixel != null) {
                        this.addNeighborPair(neighborIndex + 2, pixel, nextPixel, index);
                    }
                    if (j < h - 1) {
                        this.addNeighborPair(neighborIndex + 1, pixel, index, index + w);
                    }
                    if (i >= w - 1) continue;
                    this.addNeighborPair(neighborIndex, pixel, index, index + 1);
                }
            }
            nextPixel = pixel;
        }
    }

    int getRegionIndex(int i) {
        i = this.regionIndex[i];
        while (i < 0) {
            i = this.regionIndex[-1 - i];
        }
        return i;
    }

    boolean predicate(int i1, int i2) {
        float difference = this.average[i1] - this.average[i2];
        float log1 = (float)Math.log(1 + this.count[i1]) * (256.0f < (float)this.count[i1] ? 256.0f : (float)this.count[i1]);
        float log2 = (float)Math.log(1 + this.count[i2]) * (256.0f < (float)this.count[i2] ? 256.0f : (float)this.count[i2]);
        return difference * difference < 0.1f * this.factor * ((log1 + this.logDelta) / (float)this.count[i1] + (log2 + this.logDelta) / (float)this.count[i2]);
    }

    void mergeAllNeighbors2D(int w) {
        for (int i = 0; i < this.neighborBucket.length; ++i) {
            int neighborIndex = this.neighborBucket[i];
            while (neighborIndex >= 0) {
                int i1 = neighborIndex / 2;
                int i2 = i1 + (0 == (neighborIndex & 1) ? 1 : w);
                if (this.predicate(i1 = this.getRegionIndex(i1), i2 = this.getRegionIndex(i2))) {
                    this.mergeRegions(i1, i2);
                }
                neighborIndex = this.nextNeighbor[neighborIndex];
            }
        }
    }

    void mergeAllNeighbors3D(int w, int h) {
        for (int i = 0; i < this.neighborBucket.length; ++i) {
            int neighborIndex = this.neighborBucket[i];
            IJ.showProgress((int)i, (int)this.neighborBucket.length);
            while (neighborIndex >= 0) {
                int i1 = neighborIndex / 3;
                int i2 = i1 + (0 == neighborIndex % 3 ? 1 : (1 == neighborIndex % 3 ? w : w * h));
                if ((i1 = this.getRegionIndex(i1)) != (i2 = this.getRegionIndex(i2)) && this.predicate(i1, i2)) {
                    this.mergeRegions(i1, i2);
                }
                neighborIndex = this.nextNeighbor[neighborIndex];
            }
        }
        IJ.showProgress((int)this.neighborBucket.length, (int)this.neighborBucket.length);
    }

    void mergeRegions(int i1, int i2) {
        if (i1 == i2) {
            return;
        }
        int mergedCount = this.count[i1] + this.count[i2];
        float mergedAverage = (this.average[i1] * (float)this.count[i1] + this.average[i2] * (float)this.count[i2]) / (float)mergedCount;
        if (i1 > i2) {
            this.average[i2] = mergedAverage;
            this.count[i2] = mergedCount;
            this.regionIndex[i1] = -1 - i2;
        } else {
            this.average[i1] = mergedAverage;
            this.count[i1] = mergedCount;
            this.regionIndex[i2] = -1 - i1;
        }
    }

    int consolidateRegions() {
        int count = 0;
        for (int i = 0; i < this.regionIndex.length; ++i) {
            this.regionIndex[i] = this.regionIndex[i] < 0 ? this.regionIndex[-1 - this.regionIndex[i]] : count++;
        }
        return count;
    }
}

