/*
 * Decompiled with CFR 0.152.
 */
package com.seisw.util.geom;

import com.seisw.util.geom.Clip;
import com.seisw.util.geom.Point2D;
import com.seisw.util.geom.Poly;
import com.seisw.util.geom.PolySimple;
import com.seisw.util.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PolyDefault
implements Poly {
    private boolean m_IsHole = false;
    protected List<Poly> m_List = new ArrayList<Poly>();

    public PolyDefault() {
        this(false);
    }

    public PolyDefault(boolean isHole) {
        this.m_IsHole = isHole;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolyDefault)) {
            return false;
        }
        PolyDefault that = (PolyDefault)obj;
        if (this.m_IsHole != that.m_IsHole) {
            return false;
        }
        return this.m_List.equals(that.m_List);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_List.hashCode();
        return result;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public void clear() {
        this.m_List.clear();
    }

    @Override
    public void add(double x, double y) {
        this.add(new Point2D(x, y));
    }

    @Override
    public void add(Point2D p) {
        if (this.m_List.size() == 0) {
            this.m_List.add(new PolySimple());
        }
        this.m_List.get(0).add(p);
    }

    @Override
    public void add(Poly p) {
        if (this.m_List.size() > 0 && this.m_IsHole) {
            throw new IllegalStateException("Cannot add polys to something designated as a hole.");
        }
        this.m_List.add(p);
    }

    @Override
    public boolean isEmpty() {
        return this.m_List.isEmpty();
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.m_List.size() == 0) {
            return new Rectangle2D();
        }
        if (this.m_List.size() == 1) {
            Poly ip = this.getInnerPoly(0);
            return ip.getBounds();
        }
        throw new UnsupportedOperationException("getBounds not supported on complex poly.");
    }

    @Override
    public Poly getInnerPoly(int polyIndex) {
        return this.m_List.get(polyIndex);
    }

    @Override
    public int getNumInnerPoly() {
        return this.m_List.size();
    }

    @Override
    public int getNumPoints() {
        return this.m_List.get(0).getNumPoints();
    }

    @Override
    public double getX(int index) {
        return this.m_List.get(0).getX(index);
    }

    @Override
    public double getY(int index) {
        return this.m_List.get(0).getY(index);
    }

    @Override
    public boolean isHole() {
        if (this.m_List.size() > 1) {
            throw new IllegalStateException("Cannot call on a poly made up of more than one poly.");
        }
        return this.m_IsHole;
    }

    @Override
    public void setIsHole(boolean isHole) {
        if (this.m_List.size() > 1) {
            throw new IllegalStateException("Cannot call on a poly made up of more than one poly.");
        }
        this.m_IsHole = isHole;
    }

    @Override
    public boolean isContributing(int polyIndex) {
        return this.m_List.get(polyIndex).isContributing(0);
    }

    @Override
    public void setContributing(int polyIndex, boolean contributes) {
        if (this.m_List.size() != 1) {
            throw new IllegalStateException("Only applies to polys of size 1");
        }
        this.m_List.get(polyIndex).setContributing(0, contributes);
    }

    @Override
    public Poly intersection(Poly p) {
        return Clip.intersection(p, this, this.getClass());
    }

    @Override
    public Poly union(Poly p) {
        return Clip.union(p, this, this.getClass());
    }

    @Override
    public Poly xor(Poly p) {
        return Clip.xor(p, this, this.getClass());
    }

    @Override
    public Poly difference(Poly p) {
        return Clip.difference(this, p, this.getClass());
    }

    @Override
    public double getArea() {
        double area = 0.0;
        int i = 0;
        while (i < this.getNumInnerPoly()) {
            Poly p = this.getInnerPoly(i);
            double tarea = p.getArea() * (p.isHole() ? -1.0 : 1.0);
            area += tarea;
            ++i;
        }
        return area;
    }

    void print() {
        int i = 0;
        while (i < this.m_List.size()) {
            Poly p = this.getInnerPoly(i);
            System.out.println("InnerPoly(" + i + ").hole=" + p.isHole());
            int j = 0;
            while (j < p.getNumPoints()) {
                System.out.println(String.valueOf(p.getX(j)) + "  " + p.getY(j));
                ++j;
            }
            ++i;
        }
    }
}

