/*
 * Decompiled with CFR 0.152.
 */
package register_virtual_stack;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import mpicbg.models.CoordinateTransform;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.TransformMesh;
import mpicbg.trakem2.transform.TransformMeshMapping;
import register_virtual_stack.Register_Virtual_Stack_MT;

public class Transform_Virtual_Stack_MT
implements PlugIn {
    public static String sourceDirectory = "";
    public static String outputDirectory = "";
    public static String transformsDirectory = "";
    public static boolean interpolate = true;

    public void run(String arg) {
        String transf_dir;
        String target_dir;
        GenericDialogPlus gd = new GenericDialogPlus("Transform Virtual Stack");
        gd.addDirectoryField("Source directory", sourceDirectory, 50);
        gd.addDirectoryField("Output directory", outputDirectory, 50);
        gd.addDirectoryField("Transforms directory", transformsDirectory, 50);
        gd.addCheckbox("interpolate", interpolate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        sourceDirectory = gd.getNextString();
        outputDirectory = gd.getNextString();
        transformsDirectory = gd.getNextString();
        interpolate = gd.getNextBoolean();
        String source_dir = sourceDirectory;
        if (null == source_dir) {
            return;
        }
        if (!(source_dir = source_dir.replace('\\', '/')).endsWith("/")) {
            source_dir = source_dir + "/";
        }
        if (null == (target_dir = outputDirectory)) {
            return;
        }
        if (!(target_dir = target_dir.replace('\\', '/')).endsWith("/")) {
            target_dir = target_dir + "/";
        }
        if (null == (transf_dir = transformsDirectory)) {
            return;
        }
        if (!(transf_dir = transf_dir.replace('\\', '/')).endsWith("/")) {
            transf_dir = transf_dir + "/";
        }
        Transform_Virtual_Stack_MT.exec(source_dir, target_dir, transf_dir, interpolate);
    }

    public static boolean exec(String source_dir, String target_dir, String transf_dir, boolean interpolate) {
        Object[] src_names = new File(source_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int idot = name.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return ".tif.jpg.png.gif.tiff.jpeg.bmp.pgm.ima.dm3.dm4".contains(name.substring(idot).toLowerCase());
            }
        });
        Arrays.sort(src_names);
        String ext_xml = ".xml";
        Object[] transf_names = new File(transf_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int idot = name.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return ".xml".contains(name.substring(idot).toLowerCase());
            }
        });
        Arrays.sort(transf_names);
        if (transf_names.length != src_names.length) {
            IJ.error((String)"The number of source and transform files must be equal!");
            return false;
        }
        mpicbg.trakem2.transform.CoordinateTransform[] transform = new mpicbg.trakem2.transform.CoordinateTransform[transf_names.length];
        for (int i = 0; i < transf_names.length; ++i) {
            transform[i] = Transform_Virtual_Stack_MT.readCoordinateTransform(transf_dir + (String)transf_names[i]);
            if (transform[i] != null) continue;
            IJ.error((String)("Error when reading transform from file: " + transf_dir + (String)transf_names[i]));
            return false;
        }
        IJ.showStatus((String)"Calculating transformed images...");
        if (!Register_Virtual_Stack_MT.createResults(source_dir, (String[])src_names, target_dir, null, transform, interpolate)) {
            IJ.log((String)"Error when creating transformed images");
            return false;
        }
        return true;
    }

    public static boolean exec(String source_dir, String target_dir, String transf_dir, int first, int last, boolean interpolate) {
        Object[] src_names = new File(source_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int idot = name.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return ".tif.jpg.png.gif.tiff.jpeg.bmp.pgm.ima.dm3.dm4".contains(name.substring(idot).toLowerCase());
            }
        });
        Arrays.sort(src_names);
        String ext_xml = ".xml";
        Object[] transf_names = new File(transf_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int idot = name.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return ".xml".contains(name.substring(idot).toLowerCase());
            }
        });
        Arrays.sort(transf_names);
        if (transf_names.length != src_names.length) {
            IJ.error((String)"The number of source and transform files must be equal!");
            return false;
        }
        if (first < 0 || first > last || last >= src_names.length) {
            IJ.log((String)("Error: wrong indexes (" + first + "<->" + last + ")"));
            return false;
        }
        mpicbg.trakem2.transform.CoordinateTransform[] transform = new mpicbg.trakem2.transform.CoordinateTransform[transf_names.length];
        for (int i = 0; i < transf_names.length; ++i) {
            transform[i] = Transform_Virtual_Stack_MT.readCoordinateTransform(transf_dir + (String)transf_names[i]);
            if (transform[i] != null) continue;
            IJ.error((String)("Error when reading transform from file: " + transf_dir + (String)transf_names[i]));
            return false;
        }
        src_names = (String[])Arrays.copyOfRange(src_names, first, last);
        transform = Arrays.copyOfRange(transform, first, last);
        IJ.showStatus((String)"Calculating transformed images...");
        if (!Register_Virtual_Stack_MT.createResults(source_dir, (String[])src_names, target_dir, null, transform, interpolate)) {
            IJ.log((String)"Error when creating transformed images");
            return false;
        }
        return true;
    }

    public static mpicbg.trakem2.transform.CoordinateTransform readCoordinateTransform(String filename) {
        CoordinateTransformList ctl = new CoordinateTransformList();
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                int index = -1;
                index = line.indexOf("class=");
                if (index == -1) continue;
                int index2 = line.indexOf("\"", (index += 5) + 2);
                String ct_class = line.substring(index + 2, index2);
                mpicbg.trakem2.transform.CoordinateTransform ct = (mpicbg.trakem2.transform.CoordinateTransform)Class.forName(ct_class).newInstance();
                int index3 = line.indexOf("=", index2 + 1);
                int index4 = line.indexOf("\"", index3 + 2);
                String data = line.substring(index3 + 2, index4);
                ct.init(data);
                ctl.add((CoordinateTransform)ct);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
        }
        catch (InstantiationException e) {
            IJ.error((String)("Instantiation exception" + e));
        }
        catch (IllegalAccessException e) {
            IJ.error((String)("Illegal access exception" + e));
        }
        catch (ClassNotFoundException e) {
            IJ.error((String)("Class not found exception" + e));
        }
        return ctl;
    }

    public static ImagePlus applyCoordinateTransform(ImagePlus imp, mpicbg.trakem2.transform.CoordinateTransform transform, int meshResolution, boolean interpolate, int[] worldOrigin) {
        if (null == imp || null == transform || null == worldOrigin) {
            IJ.error((String)"Error: missing parameter! An image, a coordinate transform and a rectangle (to store world info) are needed.");
            return null;
        }
        TransformMesh mesh = new TransformMesh((CoordinateTransform)transform, meshResolution, (double)imp.getWidth(), (double)imp.getHeight());
        TransformMeshMapping mapping = new TransformMeshMapping(mesh);
        Rectangle worldBounds = mesh.getBoundingBox();
        worldOrigin[0] = worldBounds.x;
        worldOrigin[1] = worldBounds.y;
        imp.getProcessor().setValue(0.0);
        ImageProcessor ip2 = interpolate ? mapping.createMappedImageInterpolated(imp.getProcessor()) : mapping.createMappedImage(imp.getProcessor());
        ImagePlus result = new ImagePlus(imp.getTitle(), ip2);
        result.setCalibration(imp.getCalibration());
        return result;
    }
}

