/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;

final class DirectASS
extends ActiveSetSolver {
    DirectASS(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected void performIteration() {
        PrimitiveDenseStore tmpXL;
        if (this.isDebug()) {
            this.log("\nPerformIteration {}", 1 + this.countIterations());
            this.log(this.toActivatorString(), new Object[0]);
        }
        this.getConstraintToInclude();
        this.setConstraintToInclude(-1);
        int[] incl = this.getIncluded();
        int[] excl = this.getExcluded();
        boolean solved = false;
        int numbConstr = this.countIterationConstraints();
        int numbVars = this.countVariables();
        PrimitiveDenseStore iterX = this.getIterationX();
        PrimitiveDenseStore iterL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(numbConstr, 1L);
        PrimitiveDenseStore soluL = this.getSolutionL();
        if (numbConstr < numbVars && (solved = this.isSolvableQ())) {
            if ((long)numbConstr == 0L) {
                iterX.fillMatching(this.getInvQC());
            } else {
                MatrixStore<Double> iterA = this.getIterationA();
                MatrixStore<Double> iterB = this.getIterationB();
                MatrixStore<Double> iterC = this.getIterationC();
                MatrixStore<Double> tmpInvQAT = this.getSolutionQ(iterA.transpose());
                ElementsSupplier<Double> tmpS = tmpInvQAT.premultiply(iterA);
                if (this.isDebug()) {
                    BasicLogger.debug("Negated Schur complement: " + Arrays.toString(incl), tmpS.get());
                }
                if (solved = this.computeGeneral(tmpS)) {
                    this.getSolutionGeneral(this.getInvQC().premultiply(iterA).operateOnMatching((BinaryFunction<Double>)PrimitiveFunction.SUBTRACT, iterB), iterL);
                    if (this.isDebug()) {
                        this.log("Relative error {} in solution for L={}", Double.NaN, iterL);
                    }
                    ElementsSupplier<Double> tmpRHS = iterL.premultiply(iterA.transpose()).operateOnMatching(iterC, (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT);
                    this.getSolutionQ(tmpRHS, iterX);
                }
            }
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(numbVars + numbConstr, 1L)))) {
            iterX.fillMatching((Access1D<?>)tmpXL.logical().limits(numbVars, 1).get());
            iterL.fillMatching((Access1D<?>)tmpXL.logical().offsets(numbVars, 0).get());
        }
        soluL.fillAll(0.0);
        if (solved) {
            int i;
            for (i = 0; i < this.countEqualityConstraints(); ++i) {
                soluL.set((long)i, iterL.doubleValue((long)i));
            }
            for (i = 0; i < incl.length; ++i) {
                soluL.set((long)(this.countEqualityConstraints() + incl[i]), iterL.doubleValue((long)(this.countEqualityConstraints() + i)));
            }
        }
        this.handleIterationResults(solved, iterX, incl, excl);
    }
}

