/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.OjAlgoUtils;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.type.IndexSelector;

abstract class SimplexTableau
implements SimplexSolver.AlgorithmStore,
Access2D<Double> {
    private final int[] myBasis;
    private transient Mutate2D myConstraintsBody = null;
    private transient Mutate1D myConstraintsRHS = null;
    private final int myNumberOfConstraints;
    private final int myNumberOfProblemVariables;
    private final int myNumberOfSlackVariables;
    private transient Mutate1D myObjective = null;
    private final IndexSelector mySelector;

    protected static SimplexTableau make(int numberOfConstraints, int numberOfProblemVariables, int numberOfSlackVariables) {
        int numbRows = numberOfConstraints + 2;
        int numbCols = numberOfProblemVariables + numberOfSlackVariables + numberOfConstraints + 1;
        int totCount = numbRows * numbCols;
        if ((long)totCount <= OjAlgoUtils.ENVIRONMENT.getCacheElements(8L)) {
            return new DenseTableau(numberOfConstraints, numberOfProblemVariables, numberOfSlackVariables);
        }
        return new SparseTableau(numberOfConstraints, numberOfProblemVariables, numberOfSlackVariables);
    }

    protected SimplexTableau(int numberOfConstraints, int numberOfProblemVariables, int numberOfSlackVariables) {
        this.myNumberOfConstraints = numberOfConstraints;
        this.myNumberOfProblemVariables = numberOfProblemVariables;
        this.myNumberOfSlackVariables = numberOfSlackVariables;
        this.mySelector = new IndexSelector(this.countVariables());
        this.myBasis = BasicArray.makeIncreasingRange(-numberOfConstraints, numberOfConstraints);
    }

    protected final Mutate2D constraintsBody() {
        if (this.myConstraintsBody == null) {
            this.myConstraintsBody = this.newConstraintsBody();
        }
        return this.myConstraintsBody;
    }

    protected final Mutate1D constraintsRHS() {
        if (this.myConstraintsRHS == null) {
            this.myConstraintsRHS = this.newConstraintsRHS();
        }
        return this.myConstraintsRHS;
    }

    protected int countArtificialVariables() {
        return this.myNumberOfConstraints;
    }

    protected int countBasicArtificials() {
        int retVal = 0;
        int tmpLength = this.myBasis.length;
        for (int i = 0; i < tmpLength; ++i) {
            if (this.myBasis[i] >= 0) continue;
            ++retVal;
        }
        return retVal;
    }

    protected final int countBasisDeficit() {
        return this.countConstraints() - this.mySelector.countIncluded();
    }

    protected int countConstraints() {
        return this.myNumberOfConstraints;
    }

    protected int countProblemVariables() {
        return this.myNumberOfProblemVariables;
    }

    protected int countSlackVariables() {
        return this.myNumberOfSlackVariables;
    }

    protected int countVariables() {
        return this.myNumberOfProblemVariables + this.myNumberOfSlackVariables;
    }

    protected int countVariablesTotally() {
        return this.myNumberOfProblemVariables + this.myNumberOfSlackVariables + this.myNumberOfConstraints;
    }

    protected int getBasis(int basisIndex) {
        return this.myBasis[basisIndex];
    }

    protected final int[] getExcluded() {
        return this.mySelector.getExcluded();
    }

    protected final int[] getIncluded() {
        return this.mySelector.getIncluded();
    }

    protected abstract int getOvercapacity();

    protected boolean isBasicArtificials() {
        int tmpLength = this.myBasis.length;
        for (int i = 0; i < tmpLength; ++i) {
            if (this.myBasis[i] >= 0) continue;
            return true;
        }
        return false;
    }

    protected final Mutate1D objective() {
        if (this.myObjective == null) {
            this.myObjective = this.newObjective();
        }
        return this.myObjective;
    }

    protected abstract void pivot(IterationPoint var1);

    protected abstract Array1D<Double> sliceConstraintsRHS();

    protected abstract Access1D<Double> sliceDualVariables();

    protected abstract Access1D<Double> sliceTableauColumn(int var1);

    protected abstract Access1D<Double> sliceTableauRow(int var1);

    protected abstract DenseTableau toDense();

    protected void update(IterationPoint point) {
        int tmpNew;
        int pivotRow = point.row;
        int pivotCol = point.col;
        int tmpOld = this.myBasis[pivotRow];
        if (tmpOld >= 0) {
            this.mySelector.exclude(tmpOld);
        }
        if ((tmpNew = pivotCol) >= 0) {
            this.mySelector.include(tmpNew);
        }
        this.myBasis[pivotRow] = pivotCol;
    }

    int[] getBasis() {
        return (int[])this.myBasis.clone();
    }

    abstract Mutate2D newConstraintsBody();

    abstract Mutate1D newConstraintsRHS();

    abstract Mutate1D newObjective();

    static final class SparseTableau
    extends SimplexTableau {
        private double myInfeasibility = PrimitiveMath.ZERO;
        private final Array1D<Double> myObjectiveWeights;
        private final DenseArray<Double> myPhase1Weights;
        private final Array1D<Double> myRHS;
        private final SparseArray<Double>[] myRows;
        private double myValue = PrimitiveMath.ZERO;

        SparseTableau(int numberOfConstraints, int numberOfProblemVariables, int numberOfSlackVariables) {
            super(numberOfConstraints, numberOfProblemVariables, numberOfSlackVariables);
            int totNumbVars = this.countVariablesTotally();
            DenseArray.Factory<Double> denseFactory = Primitive64Array.FACTORY;
            SparseArray.SparseFactory sparseFactory = (SparseArray.SparseFactory)((SparseArray.SparseFactory)SparseArray.factory(denseFactory, totNumbVars).initial(3L)).limit(totNumbVars);
            Array1D.Factory<Double> factory1D = Array1D.factory(denseFactory);
            this.myRows = new SparseArray[numberOfConstraints];
            for (int r = 0; r < numberOfConstraints; ++r) {
                this.myRows[r] = sparseFactory.make();
            }
            this.myRHS = factory1D.makeZero(numberOfConstraints);
            this.myObjectiveWeights = factory1D.makeZero(totNumbVars);
            this.myPhase1Weights = (DenseArray)denseFactory.makeZero(totNumbVars);
        }

        @Override
        public long countColumns() {
            return (long)this.countVariablesTotally() + 1L;
        }

        @Override
        public long countRows() {
            return (long)this.countConstraints() + 2L;
        }

        @Override
        public double doubleValue(long row, long col) {
            int myNumberOfConstraints = this.countConstraints();
            int myNumberOfVariables = this.countVariables();
            if (row < (long)myNumberOfConstraints) {
                if (col < (long)(myNumberOfVariables + myNumberOfConstraints)) {
                    return this.myRows[(int)row].doubleValue(col);
                }
                return this.myRHS.doubleValue(row);
            }
            if (row == (long)myNumberOfConstraints) {
                if (col < (long)(myNumberOfVariables + myNumberOfConstraints)) {
                    return this.myObjectiveWeights.doubleValue(col);
                }
                return this.myValue;
            }
            if (col < (long)(myNumberOfVariables + myNumberOfConstraints)) {
                return this.myPhase1Weights.doubleValue(col);
            }
            return this.myInfeasibility;
        }

        @Override
        public Double get(long row, long col) {
            return this.doubleValue(row, col);
        }

        @Override
        protected int getOvercapacity() {
            int retVal = 0;
            for (int r = 0; r < this.myRows.length; ++r) {
                retVal = (int)((long)retVal + this.myRows[r].countZeros());
            }
            return retVal;
        }

        @Override
        protected void pivot(IterationPoint iterationPoint) {
            double colVal;
            UnaryFunction<double> tmpModifier;
            int row = iterationPoint.row;
            SparseArray<Double> pivotRow = this.myRows[row];
            int col = iterationPoint.col;
            double pivotElement = pivotRow.doubleValue(col);
            if (PrimitiveFunction.ABS.invoke(pivotElement) < PrimitiveMath.ONE) {
                tmpModifier = PrimitiveFunction.DIVIDE.second(pivotElement);
                pivotRow.modifyAll(tmpModifier);
                this.myRHS.modifyOne(row, tmpModifier);
            } else if (pivotElement != PrimitiveMath.ONE) {
                tmpModifier = PrimitiveFunction.MULTIPLY.second(PrimitiveMath.ONE / pivotElement);
                pivotRow.modifyAll(tmpModifier);
                this.myRHS.modifyOne(row, tmpModifier);
            }
            double pivotedRHS = this.myRHS.doubleValue(row);
            for (int i = 0; i < this.myRows.length; ++i) {
                SparseArray<Double> rowY;
                if (i == row || (colVal = -(rowY = this.myRows[i]).doubleValue(col)) == PrimitiveMath.ZERO) continue;
                pivotRow.axpy(colVal, rowY);
                this.myRHS.add((long)i, colVal * pivotedRHS);
            }
            colVal = -this.myObjectiveWeights.doubleValue(col);
            if (colVal != PrimitiveMath.ZERO) {
                pivotRow.axpy(colVal, this.myObjectiveWeights);
                this.myValue += colVal * pivotedRHS;
            }
            if ((colVal = -this.myPhase1Weights.doubleValue(col)) != PrimitiveMath.ZERO) {
                pivotRow.axpy(colVal, this.myPhase1Weights);
                this.myInfeasibility += colVal * pivotedRHS;
            }
            this.update(iterationPoint);
        }

        @Override
        protected Array1D<Double> sliceConstraintsRHS() {
            return this.myRHS;
        }

        @Override
        protected Access1D<Double> sliceDualVariables() {
            Access1D tmpSliceRange = this.myObjectiveWeights.sliceRange(this.countVariables(), this.countVariables() + this.countConstraints());
            return new Access1D<Double>((Array1D)tmpSliceRange){
                final /* synthetic */ Array1D val$tmpSliceRange;
                {
                    this.val$tmpSliceRange = array1D;
                }

                @Override
                public long count() {
                    return this.val$tmpSliceRange.count();
                }

                @Override
                public double doubleValue(long index) {
                    return -this.val$tmpSliceRange.doubleValue(index);
                }

                @Override
                public Double get(long index) {
                    return -this.val$tmpSliceRange.doubleValue(index);
                }
            };
        }

        @Override
        protected Access1D<Double> sliceTableauColumn(final int col) {
            if (col < this.countVariablesTotally()) {
                return new Access1D<Double>(){

                    @Override
                    public long count() {
                        return this.countConstraints();
                    }

                    @Override
                    public double doubleValue(long index) {
                        return myRows[(int)index].doubleValue(col);
                    }

                    @Override
                    public Double get(long index) {
                        return (Double)myRows[(int)index].get(col);
                    }
                };
            }
            return this.myRHS;
        }

        @Override
        protected Access1D<Double> sliceTableauRow(int row) {
            if (row < this.countConstraints()) {
                return this.myRows[row];
            }
            if (row == this.countConstraints()) {
                return this.myObjectiveWeights;
            }
            return this.myPhase1Weights;
        }

        @Override
        protected DenseTableau toDense() {
            return new DenseTableau(this);
        }

        double getInfeasibility() {
            return this.myInfeasibility;
        }

        @Override
        Mutate2D newConstraintsBody() {
            return new Mutate2D(){

                @Override
                public void add(long row, long col, double addend) {
                    myRows[(int)row].add(col, addend);
                    myPhase1Weights.add(col, -addend);
                }

                @Override
                public void add(long row, long col, Number addend) {
                    this.add(row, col, addend.doubleValue());
                }

                @Override
                public long countColumns() {
                    return this.countVariables();
                }

                @Override
                public long countRows() {
                    return this.countConstraints();
                }

                @Override
                public void set(long row, long col, double value) {
                    myRows[(int)row].set(col, value);
                    myPhase1Weights.add(col, -value);
                }

                @Override
                public void set(long row, long col, Number value) {
                    this.set(row, col, value.doubleValue());
                }
            };
        }

        @Override
        Mutate1D newConstraintsRHS() {
            return new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    myRows[(int)index].set((long)this.countVariables() + index, PrimitiveMath.ONE);
                    myRHS.add(index, addend);
                    myInfeasibility = myInfeasibility - addend;
                }

                @Override
                public void add(long index, Number addend) {
                    this.add(index, addend.doubleValue());
                }

                @Override
                public final long count() {
                    return this.countConstraints();
                }

                @Override
                public void set(long index, double value) {
                    myRows[(int)index].set((long)this.countVariables() + index, PrimitiveMath.ONE);
                    myRHS.set(index, value);
                    myInfeasibility = myInfeasibility - value;
                }

                @Override
                public void set(long index, Number value) {
                    this.set(index, value.doubleValue());
                }
            };
        }

        @Override
        Mutate1D newObjective() {
            return new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    myObjectiveWeights.add(index, addend);
                }

                @Override
                public void add(long index, Number addend) {
                    this.add(index, addend.doubleValue());
                }

                @Override
                public long count() {
                    return this.countVariables();
                }

                @Override
                public void set(long index, double value) {
                    myObjectiveWeights.set(index, value);
                }

                @Override
                public void set(long index, Number value) {
                    this.set(index, value.doubleValue());
                }
            };
        }

        PrimitiveDenseStore transpose() {
            PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.countColumns(), this.countRows());
            for (int i = 0; i < this.myRows.length; ++i) {
                for (SparseArray.NonzeroView nz : this.myRows[i].nonzeros()) {
                    retVal.set(nz.index(), (long)i, nz.doubleValue());
                }
            }
            retVal.fillColumn((long)this.myRows.length, this.myObjectiveWeights);
            retVal.fillColumn((long)(this.myRows.length + 1), this.myPhase1Weights);
            retVal.fillRow((long)(this.countVariables() + this.countConstraints()), this.myRHS);
            retVal.set((long)(this.countVariables() + this.countConstraints()), (long)this.countConstraints(), this.myValue);
            retVal.set((long)(this.countVariables() + this.countConstraints()), (long)(this.countConstraints() + 1), this.myInfeasibility);
            return retVal;
        }
    }

    static final class IterationPoint {
        private boolean myPhase1 = true;
        int col;
        int row;

        IterationPoint() {
            this.reset();
        }

        boolean isPhase1() {
            return this.myPhase1;
        }

        boolean isPhase2() {
            return !this.myPhase1;
        }

        void reset() {
            this.row = -1;
            this.col = -1;
        }

        void switchToPhase2() {
            this.myPhase1 = false;
        }
    }

    static final class DenseTableau
    extends SimplexTableau {
        private final PrimitiveDenseStore myTransposed;

        DenseTableau(int numberOfConstraints, int numberOfProblemVariables, int numberOfSlackVariables) {
            super(numberOfConstraints, numberOfProblemVariables, numberOfSlackVariables);
            int numbRows = numberOfConstraints + 2;
            int numbCols = numberOfProblemVariables + numberOfSlackVariables + numberOfConstraints + 1;
            this.myTransposed = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(numbCols, numbRows);
        }

        DenseTableau(LinearSolver.Builder matrices) {
            super(matrices.countConstraints(), matrices.countVariables(), 0);
            int tmpConstraintsCount = this.countConstraints();
            int tmpVariablesCount = this.countVariables();
            MatrixStore.LogicalBuilder<Double> tmpTableauBuilder = MatrixStore.PRIMITIVE.makeZero(1, 1);
            tmpTableauBuilder.left(new MatrixStore[]{matrices.getC().transpose().logical().right(new MatrixStore[]{MatrixStore.PRIMITIVE.makeZero(1, tmpConstraintsCount).get()}).get()});
            if (tmpConstraintsCount >= 1) {
                tmpTableauBuilder.above(new MatrixStore[]{matrices.getAE(), MatrixStore.PRIMITIVE.makeIdentity(tmpConstraintsCount).get(), matrices.getBE()});
            }
            tmpTableauBuilder.below(new MatrixStore[]{MatrixStore.PRIMITIVE.makeZero(1, tmpVariablesCount).get(), (MatrixStore)PrimitiveDenseStore.FACTORY.makeFilled(1L, tmpConstraintsCount, new NullaryFunction<Double>(){

                @Override
                public double doubleValue() {
                    return PrimitiveMath.ONE;
                }

                @Override
                public Double invoke() {
                    return PrimitiveMath.ONE;
                }
            })});
            this.myTransposed = PrimitiveDenseStore.FACTORY.transpose((Access2D<?>)tmpTableauBuilder.get());
            for (int i = 0; i < tmpConstraintsCount; ++i) {
                this.myTransposed.caxpy(PrimitiveMath.NEG, i, tmpConstraintsCount + 1, 0);
            }
        }

        DenseTableau(SparseTableau sparse) {
            super(sparse.countConstraints(), sparse.countProblemVariables(), sparse.countSlackVariables());
            this.myTransposed = sparse.transpose();
        }

        @Override
        public long countColumns() {
            return this.myTransposed.countRows();
        }

        @Override
        public long countRows() {
            return this.myTransposed.countColumns();
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myTransposed.doubleValue(col, row);
        }

        @Override
        public Double get(long row, long col) {
            return this.myTransposed.get(col, row);
        }

        @Override
        protected int getOvercapacity() {
            return 0;
        }

        @Override
        protected void pivot(IterationPoint iterationPoint) {
            int row = iterationPoint.row;
            int col = iterationPoint.col;
            double pivotElement = this.myTransposed.doubleValue(col, row);
            int i = 0;
            while ((long)i < this.myTransposed.countColumns()) {
                double colVal;
                if (i != row && (colVal = this.myTransposed.doubleValue(col, i)) != PrimitiveMath.ZERO) {
                    this.myTransposed.caxpy(-colVal / pivotElement, row, i, 0);
                }
                ++i;
            }
            if (PrimitiveFunction.ABS.invoke(pivotElement) < PrimitiveMath.ONE) {
                this.myTransposed.modifyColumn(0L, (long)row, (UnaryFunction<Double>)PrimitiveFunction.DIVIDE.second(pivotElement));
            } else if (pivotElement != PrimitiveMath.ONE) {
                this.myTransposed.modifyColumn(0L, (long)row, (UnaryFunction<Double>)PrimitiveFunction.MULTIPLY.second(PrimitiveMath.ONE / pivotElement));
            }
            this.update(iterationPoint);
        }

        @Override
        protected Array1D<Double> sliceConstraintsRHS() {
            return ((Array1D)this.myTransposed.sliceRow(this.countVariablesTotally())).sliceRange(0L, this.countConstraints());
        }

        @Override
        protected Access1D<Double> sliceDualVariables() {
            Access1D tmpSliceRange = ((Array1D)this.myTransposed.sliceColumn(this.countConstraints())).sliceRange(this.countVariables(), this.countVariables() + this.countConstraints());
            return new Access1D<Double>((Array1D)tmpSliceRange){
                final /* synthetic */ Array1D val$tmpSliceRange;
                {
                    this.val$tmpSliceRange = array1D;
                }

                @Override
                public long count() {
                    return this.val$tmpSliceRange.count();
                }

                @Override
                public double doubleValue(long index) {
                    return -this.val$tmpSliceRange.doubleValue(index);
                }

                @Override
                public Double get(long index) {
                    return -this.val$tmpSliceRange.doubleValue(index);
                }
            };
        }

        protected Array1D<Double> sliceTableauColumn(int col) {
            return ((Array1D)this.myTransposed.sliceRow(col)).sliceRange(0L, this.countConstraints());
        }

        protected Array1D<Double> sliceTableauRow(int row) {
            return ((Array1D)this.myTransposed.sliceColumn(row)).sliceRange(0L, this.countVariablesTotally());
        }

        @Override
        protected DenseTableau toDense() {
            return this;
        }

        @Override
        Mutate2D newConstraintsBody() {
            return new Mutate2D(){

                @Override
                public void add(long row, long col, double addend) {
                    myTransposed.add(col, row, addend);
                    myTransposed.add(col, (long)(this.countConstraints() + 1), -addend);
                }

                @Override
                public void add(long row, long col, Number addend) {
                    this.add(row, col, addend.doubleValue());
                }

                @Override
                public long countColumns() {
                    return this.countVariables();
                }

                @Override
                public long countRows() {
                    return this.countConstraints();
                }

                @Override
                public void set(long row, long col, double value) {
                    myTransposed.set(col, row, value);
                    myTransposed.add(col, (long)(this.countConstraints() + 1), -value);
                }

                @Override
                public void set(long row, long col, Number value) {
                    this.set(row, col, value.doubleValue());
                }
            };
        }

        @Override
        Mutate1D newConstraintsRHS() {
            final int numbVar = this.countVariables();
            final int numbConstr = this.countConstraints();
            final int col = numbVar + numbConstr;
            return new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    myTransposed.set((long)numbVar + index, index, PrimitiveMath.ONE);
                    myTransposed.add((long)col, index, addend);
                    myTransposed.add((long)col, (long)(numbConstr + 1), -addend);
                }

                @Override
                public void add(long index, Number addend) {
                    this.add(index, addend.doubleValue());
                }

                @Override
                public final long count() {
                    return this.countConstraints();
                }

                @Override
                public void set(long index, double value) {
                    myTransposed.set((long)numbVar + index, index, PrimitiveMath.ONE);
                    myTransposed.set((long)col, index, value);
                    myTransposed.add((long)col, (long)(numbConstr + 1), -value);
                }

                @Override
                public void set(long index, Number value) {
                    this.set(index, value.doubleValue());
                }
            };
        }

        @Override
        Mutate1D newObjective() {
            final int row = this.countConstraints();
            return new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    myTransposed.add(index, (long)row, addend);
                }

                @Override
                public void add(long index, Number addend) {
                    this.add(index, addend.doubleValue());
                }

                @Override
                public long count() {
                    return this.countVariables();
                }

                @Override
                public void set(long index, double value) {
                    myTransposed.set(index, (long)row, value);
                }

                @Override
                public void set(long index, Number value) {
                    this.set(index, value.doubleValue());
                }
            };
        }
    }
}

