/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FftFilter;
import edu.mines.jtk.dsp.KaiserWindow;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class BandPassFilter {
    private double _klower;
    private double _kupper;
    private double _kwidth;
    private double _aerror;
    private FftFilter _ff1;
    private FftFilter _ff2;
    private FftFilter _ff3;
    private float[] _h1;
    private float[][] _h2;
    private float[][][] _h3;
    private Extrapolation _extrapolation = Extrapolation.ZERO_VALUE;
    private boolean _filterCaching;
    private static double PIO4 = 0.7853981633974483;
    private static double PIO6 = 0.5235987755982988;

    public BandPassFilter(double klower, double kupper, double kwidth, double aerror) {
        Check.argument(0.0 <= klower, "0<=klower");
        Check.argument(klower < kupper, "klower<kupper");
        Check.argument(kupper <= 0.5, "kupper<0.5");
        Check.argument(0.0 <= kwidth, "0<=kwidth");
        Check.argument(kwidth <= kupper - klower, "kwidth<=kupper-klower");
        Check.argument(0.0 < aerror, "0<aerror");
        Check.argument(aerror < 1.0, "aerror<1");
        this._klower = klower;
        this._kupper = kupper;
        this._kwidth = kwidth;
        this._aerror = aerror;
    }

    public void setExtrapolation(Extrapolation extrapolation) {
        if (this._extrapolation != extrapolation) {
            this._extrapolation = extrapolation;
            this._ff3 = null;
            this._ff2 = null;
            this._ff1 = null;
        }
    }

    public void setFilterCaching(boolean filterCaching) {
        if (this._filterCaching != filterCaching) {
            this._filterCaching = filterCaching;
            this._ff3 = null;
            this._ff2 = null;
            this._ff1 = null;
        }
    }

    public float[] getCoefficients1() {
        this.updateFilter1();
        return ArrayMath.copy(this._h1);
    }

    public float[][] getCoefficients2() {
        this.updateFilter2();
        return ArrayMath.copy(this._h2);
    }

    public float[][][] getCoefficients3() {
        this.updateFilter3();
        return ArrayMath.copy(this._h3);
    }

    public void apply(float[] x, float[] y) {
        this.updateFilter1();
        this._ff1.apply(x, y);
    }

    public void apply(float[][] x, float[][] y) {
        this.updateFilter2();
        this._ff2.apply(x, y);
    }

    public void apply(float[][][] x, float[][][] y) {
        this.updateFilter3();
        this._ff3.apply(x, y);
    }

    private FftFilter.Extrapolation ffExtrap(Extrapolation e) {
        if (e == Extrapolation.ZERO_VALUE) {
            return FftFilter.Extrapolation.ZERO_VALUE;
        }
        if (e == Extrapolation.ZERO_SLOPE) {
            return FftFilter.Extrapolation.ZERO_SLOPE;
        }
        return null;
    }

    private void updateFilter1() {
        if (this._ff1 == null) {
            int nh;
            KaiserWindow kw = KaiserWindow.fromErrorAndWidth(this._aerror, this._kwidth);
            int nh1 = nh = ((int)kw.getLength() + 1) / 2 * 2 + 1;
            int kh1 = (nh1 - 1) / 2;
            this._h1 = new float[nh1];
            double kus = 2.0 * this._kupper;
            double kls = 2.0 * this._klower;
            for (int i1 = 0; i1 < nh1; ++i1) {
                double x1 = i1 - kh1;
                double w1 = kw.evaluate(x1);
                double r = x1;
                double kur = 2.0 * this._kupper * r;
                double klr = 2.0 * this._klower * r;
                this._h1[i1] = (float)(w1 * (kus * BandPassFilter.h1(kur) - kls * BandPassFilter.h1(klr)));
            }
            this._ff1 = new FftFilter(this._h1);
            this._ff1.setExtrapolation(this.ffExtrap(this._extrapolation));
            this._ff1.setFilterCaching(this._filterCaching);
        }
    }

    private void updateFilter2() {
        if (this._ff2 == null) {
            int nh;
            KaiserWindow kw = KaiserWindow.fromErrorAndWidth(this._aerror, this._kwidth);
            int nh1 = nh = ((int)kw.getLength() + 1) / 2 * 2 + 1;
            int nh2 = nh;
            int kh1 = (nh1 - 1) / 2;
            int kh2 = (nh2 - 1) / 2;
            this._h2 = new float[nh2][nh1];
            double kus = 4.0 * this._kupper * this._kupper;
            double kls = 4.0 * this._klower * this._klower;
            for (int i2 = 0; i2 < nh2; ++i2) {
                double x2 = i2 - kh2;
                double w2 = kw.evaluate(x2);
                for (int i1 = 0; i1 < nh1; ++i1) {
                    double x1 = i1 - kh1;
                    double w1 = kw.evaluate(x1);
                    double r = ArrayMath.sqrt(x1 * x1 + x2 * x2);
                    double kur = 2.0 * this._kupper * r;
                    double klr = 2.0 * this._klower * r;
                    this._h2[i2][i1] = (float)(w1 * w2 * (kus * BandPassFilter.h2(kur) - kls * BandPassFilter.h2(klr)));
                }
            }
            this._ff2 = new FftFilter(this._h2);
            this._ff2.setExtrapolation(this.ffExtrap(this._extrapolation));
            this._ff2.setFilterCaching(this._filterCaching);
        }
    }

    private void updateFilter3() {
        if (this._ff3 == null) {
            int nh;
            KaiserWindow kw = KaiserWindow.fromErrorAndWidth(this._aerror, this._kwidth);
            int nh1 = nh = ((int)kw.getLength() + 1) / 2 * 2 + 1;
            int nh2 = nh;
            int nh3 = nh;
            int kh1 = (nh1 - 1) / 2;
            int kh2 = (nh2 - 1) / 2;
            int kh3 = (nh3 - 1) / 2;
            this._h3 = new float[nh3][nh2][nh1];
            double kus = 8.0 * this._kupper * this._kupper * this._kupper;
            double kls = 8.0 * this._klower * this._klower * this._klower;
            for (int i3 = 0; i3 < nh3; ++i3) {
                double x3 = i3 - kh3;
                double w3 = kw.evaluate(x3);
                for (int i2 = 0; i2 < nh2; ++i2) {
                    double x2 = i2 - kh2;
                    double w2 = kw.evaluate(x2);
                    for (int i1 = 0; i1 < nh1; ++i1) {
                        double x1 = i1 - kh1;
                        double w1 = kw.evaluate(x1);
                        double r = ArrayMath.sqrt(x1 * x1 + x2 * x2 + x3 * x3);
                        double kur = 2.0 * this._kupper * r;
                        double klr = 2.0 * this._klower * r;
                        this._h3[i3][i2][i1] = (float)(w1 * w2 * w3 * (kus * BandPassFilter.h3(kur) - kls * BandPassFilter.h3(klr)));
                    }
                }
            }
            this._ff3 = new FftFilter(this._h3);
            this._ff3.setExtrapolation(this.ffExtrap(this._extrapolation));
            this._ff3.setFilterCaching(this._filterCaching);
        }
    }

    private static double h1(double r) {
        return r == 0.0 ? 1.0 : ArrayMath.sin(Math.PI * r) / (Math.PI * r);
    }

    private static double h2(double r) {
        return r == 0.0 ? PIO4 : BandPassFilter.besselJ1(Math.PI * r) / (2.0 * r);
    }

    private static double besselJ1(double x) {
        double ax = ArrayMath.abs(x);
        if (ax < 8.0) {
            double xx = x * x;
            double num = x * (7.2362614232E10 + xx * (-7.895059235E9 + xx * (2.423968531E8 + xx * (-2972611.439 + xx * (15704.4826 + xx * -30.16036606)))));
            double den = 1.44725228442E11 + xx * (2.300535178E9 + xx * (1.858330474E7 + xx * (99447.43394 + xx * (376.9991397 + xx))));
            return num / den;
        }
        double z = 8.0 / ax;
        double zz = z * z;
        double t1 = 1.0 + zz * (0.00183105 + zz * (-3.516396496E-5 + zz * (2.457520174E-6 + zz * -2.40337019E-7)));
        double t2 = 0.04687499995 + zz * (-2.002690873E-4 + zz * (8.449199096E-6 + zz * (-8.8228987E-7 + zz * 1.05787412E-7)));
        double am = ax - 2.356194491;
        double y = ArrayMath.sqrt(0.636619772 / ax) * (ArrayMath.cos(am) * t1 - z * ArrayMath.sin(am) * t2);
        return x < 0.0 ? -y : y;
    }

    private static double h3(double r) {
        if (r == 0.0) {
            return PIO6;
        }
        double pir = Math.PI * r;
        return 1.5707963267948966 * (ArrayMath.sin(pir) - pir * ArrayMath.cos(pir)) / (pir * pir * pir);
    }

    public static enum Extrapolation {
        ZERO_VALUE,
        ZERO_SLOPE;

    }
}

