/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.interp.NearestGridder3;
import edu.mines.jtk.interp.TimeHeap3;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Stopwatch;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class TimeMarker3X {
    private static Logger log = Logger.getLogger(NearestGridder3.class.getName());
    private static final float INFINITY = Float.MAX_VALUE;
    private static final float EPSILON = 0.001f;
    private static final float ONE_MINUS_EPSILON = 0.999f;
    private int _n1;
    private int _n2;
    private int _n3;
    private Tensors3 _tensors;
    private Sample[][][] _s;
    private ArrayList<Sample> _als = new ArrayList(2048);
    private Concurrency _concurrency = Concurrency.PARALLEL;
    private static final int[] K1 = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] K2 = new int[]{0, 0, -1, 1, 0, 0};
    private static final int[] K3 = new int[]{0, 0, 0, 0, -1, 1};
    private static final int[][] K1S = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, -1, 1, 1, 0, 0, -1, 1, 0}, {-1, -1, 1, 1, 0, 0, -1, 1, 0}, {-1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0}};
    private static final int[][] K2S = new int[][]{{-1, -1, 1, 1, 0, 0, -1, 1, 0}, {-1, -1, 1, 1, 0, 0, -1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, -1, 1, 1, -1, -1, 1, 1, -1, -1, 1, 1, 0, 0, 0, 0, -1, 1, -1, 1, 0, 0, -1, 1, 0, 0}};
    private static final int[][] K3S = new int[][]{{-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, 1, -1, 1, -1, 1, 0, 0, 0}, {-1, -1, 1, 1, 0, 0, -1, 1, 0}, {-1, -1, 1, 1, 0, 0, -1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 1, 1, 1, 1, 0, 0, 0, 0, -1, -1, 1, 1, -1, -1, 1, 1, 0, 0, 0, 0, -1, 1}};
    private int _activated = 1;

    public TimeMarker3X(int n1, int n2, int n3, Tensors3 tensors) {
        this.init(n1, n2, n3, tensors);
    }

    public void setTensors(Tensors3 tensors) {
        this._tensors = tensors;
    }

    public void setConcurrency(Concurrency concurrency) {
        this._concurrency = concurrency;
    }

    public void apply(float[][][] times, int[][][] marks) {
        Stopwatch sw = new Stopwatch();
        sw.start();
        log.fine("TimeMarker3X.apply: begin time=" + (int)sw.time());
        TimeHeap3 theap = this.makeTimeHeap(times, marks);
        int nk = theap.size();
        log.fine("TimeMarker3X.apply: heap time=" + (int)sw.time());
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    times[i3][i2][i1] = Float.MAX_VALUE;
                }
            }
        }
        float[][][] t = new float[this._n3][this._n2][this._n1];
        ActiveList al = new ActiveList();
        for (int ik = 0; ik < nk; ++ik) {
            if (ik % (1 + (nk - 1) / 100) == 0) {
                log.fine("  apply: ik/nk=" + ik + "/" + nk + " time=" + (int)sw.time());
            }
            TimeHeap3.Entry ek = theap.remove();
            int k1 = ek.i1;
            int k2 = ek.i2;
            int k3 = ek.i3;
            int m = ek.mark;
            times[k3][k2][k1] = 0.0f;
            marks[k3][k2][k1] = m;
            this.clearActivated();
            t[k3][k2][k1] = 0.0f;
            al.append(this._s[k3][k2][k1]);
            this.solve(al, t, m, times, marks);
            this.updateTimeHeap(times, marks, ek, theap);
        }
        sw.stop();
        log.fine("TimeMarker3X.apply: end time=" + (int)sw.time());
    }

    private void init(int n1, int n2, int n3, Tensors3 tensors) {
        this._n1 = n1;
        this._n2 = n2;
        this._n3 = n3;
        this._tensors = tensors;
        this._s = new Sample[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    this._s[i3][i2][i1] = new Sample(i1, i2, i3);
                }
            }
        }
    }

    private void clearActivated() {
        if (this._activated == Integer.MAX_VALUE) {
            this._activated = 1;
            for (int i3 = 0; i3 < this._n3; ++i3) {
                for (int i2 = 0; i2 < this._n2; ++i2) {
                    for (int i1 = 0; i1 < this._n1; ++i1) {
                        this._s[i3][i2][i1].activated = 0;
                    }
                }
            }
        } else {
            ++this._activated;
        }
    }

    private void setActivated(Sample s) {
        s.activated = this._activated;
    }

    private void clearActivated(Sample s) {
        s.activated = 0;
    }

    private boolean wasActivated(Sample s) {
        return s.activated == this._activated;
    }

    private TimeHeap3 makeTimeHeap(float[][][] times, int[][][] marks) {
        int[][] kk = this.indexKnownSamples(times, marks);
        int[] km = kk[0];
        int[] k1 = kk[1];
        int[] k2 = kk[2];
        int[] k3 = kk[3];
        int nk = km.length;
        int ikmid = 0;
        float dkmid = Float.MAX_VALUE;
        int m1 = this._n1 / 2;
        int m2 = this._n2 / 2;
        int m3 = this._n3 / 2;
        for (int ik = 0; ik < nk; ++ik) {
            int i1 = k1[ik];
            float d1 = i1 - m1;
            int i2 = k2[ik];
            float d2 = i2 - m2;
            int i3 = k3[ik];
            float d3 = i3 - m3;
            float dk = d1 * d1 + d2 * d2 + d3 * d3;
            if (!(dk < dkmid)) continue;
            ikmid = ik;
            dkmid = dk;
        }
        TimeHeap3 theap = new TimeHeap3(TimeHeap3.Type.MAX, this._n1, this._n2, this._n3);
        for (int ik = 0; ik < nk; ++ik) {
            if (ik == ikmid) {
                theap.insert(k1[ik], k2[ik], k3[ik], Float.MAX_VALUE, km[ik]);
                continue;
            }
            theap.insert(k1[ik], k2[ik], k3[ik], 1.7014117E38f, km[ik]);
        }
        return theap;
    }

    private void updateTimeHeap(float[][][] times, int[][][] marks, TimeHeap3.Entry ek, TimeHeap3 theap) {
        if (theap.isEmpty()) {
            return;
        }
        int k1 = ek.i1;
        int k2 = ek.i2;
        int k3 = ek.i3;
        int m = ek.mark;
        this._als.clear();
        this.addSampleToList(k1, k2, k3);
        while (!this._als.isEmpty()) {
            Sample s = this._als.remove(this._als.size() - 1);
            int i3 = s.i3;
            int i2 = s.i2;
            int i1 = s.i1;
            if (m == marks[i3][i2][i1] && theap.contains(i1, i2, i3)) {
                theap.reduce(i1, i2, i3, times[i3][i2][i1]);
            }
            if (0 < i1) {
                this.addSampleToList(i1 - 1, i2, i3);
            }
            if (0 < i2) {
                this.addSampleToList(i1, i2 - 1, i3);
            }
            if (0 < i3) {
                this.addSampleToList(i1, i2, i3 - 1);
            }
            if (i1 < this._n1 - 1) {
                this.addSampleToList(i1 + 1, i2, i3);
            }
            if (i2 < this._n2 - 1) {
                this.addSampleToList(i1, i2 + 1, i3);
            }
            if (i3 >= this._n3 - 1) continue;
            this.addSampleToList(i1, i3, i3 + 1);
        }
    }

    private void addSampleToList(int i1, int i2, int i3) {
        if (this.wasActivated(this._s[i3][i2][i1])) {
            this._als.add(this._s[i3][i2][i1]);
            this.clearActivated(this._s[i3][i2][i1]);
        }
    }

    private int[][] indexKnownSamples(float[][][] times, int[][][] marks) {
        int nk = 0;
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    if (times[i3][i2][i1] != 0.0f) continue;
                    ++nk;
                }
            }
        }
        int[] km = new int[nk];
        int[] k1 = new int[nk];
        int[] k2 = new int[nk];
        int[] k3 = new int[nk];
        int ik = 0;
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    if (times[i3][i2][i1] != 0.0f) continue;
                    km[ik] = marks[i3][i2][i1];
                    k1[ik] = i1;
                    k2[ik] = i2;
                    k3[ik] = i3;
                    ++ik;
                }
            }
        }
        return new int[][]{km, k1, k2, k3};
    }

    private void solve(ActiveList al, float[][][] t, int m, float[][][] times, int[][][] marks) {
        if (this._concurrency == Concurrency.PARALLEL) {
            this.solveParallel(al, t, m, times, marks);
        } else {
            this.solveSerial(al, t, m, times, marks);
        }
    }

    private void solveSerial(ActiveList al, float[][][] t, int m, float[][][] times, int[][][] marks) {
        float[] d = new float[6];
        ActiveList bl = new ActiveList();
        int ntotal = 0;
        while (!al.isEmpty()) {
            int n = al.size();
            ntotal += n;
            for (int i = 0; i < n; ++i) {
                Sample s = al.get(i);
                this.solveOne(t, m, times, marks, s, bl, d);
            }
            bl.setAllAbsent();
            al.clear();
            al.appendIfAbsent(bl);
            bl.clear();
        }
        TimeMarker3X.trace("solveSerial: ntotal=" + ntotal);
        TimeMarker3X.trace("             nratio=" + (float)ntotal / (float)(this._n1 * this._n2 * this._n3));
    }

    private void solveParallel(final ActiveList al, final float[][][] t, final int m, final float[][][] times, final int[][][] marks) {
        int nthread = Runtime.getRuntime().availableProcessors();
        ExecutorService es = Executors.newFixedThreadPool(nthread);
        ExecutorCompletionService<Void> cs = new ExecutorCompletionService<Void>(es);
        ActiveList[] bl = new ActiveList[nthread];
        float[][] d = new float[nthread][];
        for (int ithread = 0; ithread < nthread; ++ithread) {
            bl[ithread] = new ActiveList();
            d[ithread] = new float[6];
        }
        final AtomicInteger ai = new AtomicInteger();
        while (!al.isEmpty()) {
            int itask;
            ai.set(0);
            final int n = al.size();
            int mb = 32;
            final int nb = 1 + (n - 1) / 32;
            int ntask = ArrayMath.min(nb, nthread);
            for (itask = 0; itask < ntask; ++itask) {
                final ActiveList bltask = bl[itask];
                final float[] dtask = d[itask];
                cs.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int ib = ai.getAndIncrement();
                        while (ib < nb) {
                            int i = ib * 32;
                            int j = ArrayMath.min(i + 32, n);
                            for (int k = i; k < j; ++k) {
                                Sample s = al.get(k);
                                TimeMarker3X.this.solveOne(t, m, times, marks, s, bltask, dtask);
                            }
                            ib = ai.getAndIncrement();
                        }
                        bltask.setAllAbsent();
                        return null;
                    }
                });
            }
            try {
                for (itask = 0; itask < ntask; ++itask) {
                    cs.take();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            al.clear();
            for (itask = 0; itask < ntask; ++itask) {
                al.appendIfAbsent(bl[itask]);
                bl[itask].clear();
            }
        }
        es.shutdown();
    }

    private float currentTime(float[][][] t, int i1, int i2, int i3) {
        return this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private void solveOne(float[][][] t, int m, float[][][] times, int[][][] marks, Sample s, ActiveList bl, float[] d) {
        float ci;
        int i1 = s.i1;
        int i2 = s.i2;
        int i3 = s.i3;
        float ti = this.currentTime(t, i1, i2, i3);
        t[i3][i2][i1] = ci = this.computeTime(t, i1, i2, i3, K1S[6], K2S[6], K3S[6], d);
        if (ci >= ti * 0.999f) {
            boolean checkNabors;
            boolean bl2 = checkNabors = ci <= 1.5f * times[i3][i2][i1];
            if (ci < times[i3][i2][i1]) {
                times[i3][i2][i1] = ci;
                marks[i3][i2][i1] = m;
            }
            if (checkNabors) {
                for (int k = 0; k < 6; ++k) {
                    int j3;
                    int j2;
                    int j1 = i1 + K1[k];
                    if (j1 < 0 || j1 >= this._n1 || (j2 = i2 + K2[k]) < 0 || j2 >= this._n2 || (j3 = i3 + K3[k]) < 0 || j3 >= this._n3) continue;
                    float tj = this.currentTime(t, j1, j2, j3);
                    float cj = this.computeTime(t, j1, j2, j3, K1S[k], K2S[k], K3S[k], d);
                    if (!(cj < tj * 0.999f)) continue;
                    t[j3][j2][j1] = cj;
                    bl.append(this._s[j3][j2][j1]);
                }
            }
        } else {
            bl.append(s);
        }
    }

    private float t1m(float[][][] t, int i1, int i2, int i3) {
        return --i1 >= 0 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float t1p(float[][][] t, int i1, int i2, int i3) {
        return ++i1 < this._n1 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float t2m(float[][][] t, int i1, int i2, int i3) {
        return --i2 >= 0 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float t2p(float[][][] t, int i1, int i2, int i3) {
        return ++i2 < this._n2 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float t3m(float[][][] t, int i1, int i2, int i3) {
        return --i3 >= 0 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float t3p(float[][][] t, int i1, int i2, int i3) {
        return ++i3 < this._n3 && this.wasActivated(this._s[i3][i2][i1]) ? t[i3][i2][i1] : Float.MAX_VALUE;
    }

    private float computeTime(float[][][] t, int i1, int i2, int i3, int[] k1s, int[] k2s, int[] k3s, float[] d) {
        this._tensors.getTensor(i1, i2, i3, d);
        float d11 = d[0];
        float d12 = d[1];
        float d13 = d[2];
        float d22 = d[3];
        float d23 = d[4];
        float d33 = d[5];
        float o11 = 1.0f / d11;
        float o22 = 1.0f / d22;
        float o33 = 1.0f / d33;
        float d1212 = d12 * d12;
        float d1213 = d12 * d13;
        float d1223 = d12 * d23;
        float d1313 = d13 * d13;
        float d1323 = d13 * d23;
        float d2323 = d23 * d23;
        float a11 = d11 - d1313 * o33;
        float a12 = d12 - d1323 * o33;
        float a22 = d22 - d2323 * o33;
        float b11 = d11 - d1212 * o22;
        float b13 = d13 - d1223 * o22;
        float b33 = d33 - d2323 * o22;
        float c22 = d22 - d1212 * o11;
        float c23 = d23 - d1213 * o11;
        float c33 = d33 - d1313 * o11;
        float e12 = 1.0f / (a11 * a22 - a12 * a12);
        float e13 = 1.0f / (b11 * b33 - b13 * b13);
        float tc = this.currentTime(t, i1, i2, i3);
        float t1m = this.t1m(t, i1, i2, i3);
        float t1p = this.t1p(t, i1, i2, i3);
        float t2m = this.t2m(t, i1, i2, i3);
        float t2p = this.t2p(t, i1, i2, i3);
        float t3m = this.t3m(t, i1, i2, i3);
        float t3p = this.t3p(t, i1, i2, i3);
        for (int k = 0; k < k1s.length; ++k) {
            float t0;
            float t3;
            float t2;
            float t1;
            int k1 = k1s[k];
            int k2 = k2s[k];
            int k3 = k3s[k];
            if (k1 != 0 && k2 != 0 && k3 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                float f2 = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                float f3 = t3 = k3 < 0 ? t3m : t3p;
                if (t3 == Float.MAX_VALUE) continue;
                t0 = TimeMarker3X.computeTime(d11, d12, d13, d22, d23, d33, k1, k2, k3, t1, t2, t3);
            } else if (k1 != 0 && k2 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                float f4 = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                t0 = TimeMarker3X.computeTime(a11, a12, a22, k1, k2, t1, t2);
            } else if (k1 != 0 && k3 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                float f5 = t3 = k3 < 0 ? t3m : t3p;
                if (t3 == Float.MAX_VALUE) continue;
                t0 = TimeMarker3X.computeTime(b11, b13, b33, k1, k3, t1, t3);
            } else if (k2 != 0 && k3 != 0) {
                float f = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                float f6 = t3 = k3 < 0 ? t3m : t3p;
                if (t3 == Float.MAX_VALUE) continue;
                t0 = TimeMarker3X.computeTime(c22, c23, c33, k2, k3, t2, t3);
            } else if (k1 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                t0 = t1 + ArrayMath.sqrt(a22 * e12);
            } else if (k2 != 0) {
                float f = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                t0 = t2 + ArrayMath.sqrt(a11 * e12);
            } else {
                float f = t3 = k3 < 0 ? t3m : t3p;
                if (t3 == Float.MAX_VALUE) continue;
                t0 = t3 + ArrayMath.sqrt(b11 * e13);
            }
            if (!(t0 < tc)) continue;
            return t0;
        }
        return tc;
    }

    private static float computeTime(float d11, float d12, float d13, float d22, float d23, float d33, float s1, float s2, float s3, float t1, float t2, float t3) {
        double u3;
        double u2;
        double ds22 = d22 * s2 * s2;
        double ds12 = d12 * s1 * s2;
        double ds23 = d23 * s2 * s3;
        double t12 = t1 - t2;
        double ds33 = d33 * s3 * s3;
        double ds13 = d13 * s1 * s3;
        double t13 = t1 - t3;
        double b = 2.0 * ((ds22 + ds12 + ds23) * t12 + (ds33 + ds13 + ds23) * t13);
        double ds11 = d11 * s1 * s1;
        double a = ds11 + ds22 + ds33 + 2.0 * (ds12 + ds13 + ds23);
        double c = ds22 * t12 * t12 + ds33 * t13 * t13 + 2.0 * ds23 * t12 * t13 - 1.0;
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return Float.MAX_VALUE;
        }
        double u1 = (-b + ArrayMath.sqrt(d)) / (2.0 * a);
        if (ds11 * u1 + ds12 * (u2 = u1 + t12) + ds13 * (u3 = u1 + t13) < 0.0 || ds12 * u1 + ds22 * u2 + ds23 * u3 < 0.0 || ds13 * u1 + ds23 * u2 + ds33 * u3 < 0.0) {
            return Float.MAX_VALUE;
        }
        return t1 + (float)u1;
    }

    private static float computeTime(float d11, float d12, float d22, float s1, float s2, float t1, float t2) {
        double u2;
        double ds12 = d12 * s1 * s2;
        double ds22 = d22 * s2 * s2;
        double t12 = t1 - t2;
        double b = 2.0 * (ds12 + ds22) * t12;
        double ds11 = d11 * s1 * s1;
        double a = ds11 + 2.0 * ds12 + ds22;
        double c = ds22 * t12 * t12 - 1.0;
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return Float.MAX_VALUE;
        }
        double u1 = (-b + ArrayMath.sqrt(d)) / (2.0 * a);
        if (ds11 * u1 + ds12 * (u2 = u1 + t12) < 0.0 || ds12 * u1 + ds22 * u2 < 0.0) {
            return Float.MAX_VALUE;
        }
        return t1 + (float)u1;
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private static float[][][] toFloat(int[][][] i) {
        int n1 = i[0][0].length;
        int n2 = i[0].length;
        int n3 = i.length;
        float[][][] f = new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    f[i3][i2][i1] = i[i3][i2][i1];
                }
            }
        }
        return f;
    }

    private class ActiveList {
        private int _n;
        private Sample[] _a = new Sample[1024];

        private ActiveList() {
        }

        void append(Sample s) {
            s.activated = TimeMarker3X.this._activated;
            if (this._n == this._a.length) {
                this.growTo(2 * this._n);
            }
            this._a[this._n++] = s;
        }

        boolean isEmpty() {
            return this._n == 0;
        }

        int size() {
            return this._n;
        }

        Sample get(int i) {
            return this._a[i];
        }

        void clear() {
            this._n = 0;
        }

        void setAllAbsent() {
            for (int i = 0; i < this._n; ++i) {
                this._a[i].absent = true;
            }
        }

        void appendIfAbsent(ActiveList al) {
            if (this._n + al._n > this._a.length) {
                this.growTo(2 * (this._n + al._n));
            }
            int n = al._n;
            for (int i = 0; i < n; ++i) {
                Sample s = al.get(i);
                if (!s.absent) continue;
                this._a[this._n++] = s;
                s.absent = false;
            }
        }

        void shuffle() {
            Random r = new Random();
            for (int i = 0; i < this._n; ++i) {
                int j = r.nextInt(this._n);
                int k = r.nextInt(this._n);
                Sample aj = this._a[j];
                this._a[j] = this._a[k];
                this._a[k] = aj;
            }
        }

        void dump() {
            TimeMarker3X.trace("ActiveList.dump: n=" + this._n);
            for (int i = 0; i < this._n; ++i) {
                Sample s = this._a[i];
                TimeMarker3X.trace(" s[" + i + "] = (" + s.i1 + "," + s.i2 + "," + s.i3 + ")");
            }
        }

        private void growTo(int capacity) {
            Sample[] a = new Sample[capacity];
            System.arraycopy(this._a, 0, a, 0, this._n);
            this._a = a;
        }
    }

    private static class Sample {
        int i1;
        int i2;
        int i3;
        int activated;
        boolean absent;

        Sample(int i1, int i2, int i3) {
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
        }
    }

    public static enum Concurrency {
        PARALLEL,
        SERIAL;

    }
}

