/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.util.Almost;
import edu.mines.jtk.util.Monitor;
import java.util.Arrays;

public class ScalarSolver {
    private static final double GOLD = 0.5 * (Math.sqrt(5.0) - 1.0);
    private static final Almost s_almost = new Almost();
    private Function _function = null;
    private final double[] _doubleTemp = new double[4];

    public ScalarSolver(Function function) {
        this._function = function;
    }

    public double solve(double scalarMin, double scalarMax, double okError, double okFraction, int numberIterations, Monitor monitor) {
        double xmin;
        if (monitor == null) {
            monitor = Monitor.NULL_MONITOR;
        }
        monitor.report(0.0);
        int nter = numberIterations;
        if (nter < 6) {
            nter = 6;
        }
        double[] xs = new double[]{0.0, 0.25, 0.75, 1.0};
        double[] fs = new double[4];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = this.function(xs[i], scalarMin, scalarMax);
        }
        int iter = 4;
        double error = 1.0;
        double previousError = 1.0;
        while (true) {
            monitor.report((double)iter / (double)nter);
            int imin = this.sort(xs, fs);
            xmin = xs[imin];
            double previousPreviousError = previousError;
            previousError = error;
            if (imin == 0) {
                error = xs[1] - xs[0];
            } else if (imin == 3) {
                error = xs[3] - xs[2];
            } else if (imin == 1 || imin == 2) {
                error = xs[imin + 1] - xs[imin - 1];
            } else assert (false) : "impossible imin=" + imin;
            double fraction = Almost.FLOAT.divide(error, xmin, 0.0);
            if (iter >= nter || error < okError && fraction < okFraction || monitor.isCanceled()) break;
            double xnew = 3.4028234663852886E38;
            if (imin == 0) {
                assert (xs[imin] == 0.0) : "Left endpoint should be zero, not " + xs[imin];
                xnew = xs[1] * 0.1;
            } else if (imin == 3) {
                assert (xs[imin] == 1.0) : "Right endpoint should be one, not " + xs[imin];
                xnew = 1.0 - 0.1 * (1.0 - xs[2]);
            } else if (imin == 1 || imin == 2) {
                boolean goodConvergence = false;
                if (error < previousPreviousError * 0.501) {
                    try {
                        xnew = ScalarSolver.minParabola(xs[imin - 1], fs[imin - 1], xs[imin], fs[imin], xs[imin + 1], fs[imin + 1]);
                        goodConvergence = true;
                    }
                    catch (BadParabolaException e) {
                        goodConvergence = false;
                    }
                }
                if (!goodConvergence) {
                    xnew = xs[imin] - xs[imin - 1] >= xs[imin + 1] - xs[imin] ? xs[imin - 1] + GOLD * (xs[imin] - xs[imin - 1]) : xs[imin + 1] - GOLD * (xs[imin + 1] - xs[imin]);
                }
            } else assert (false) : "Impossible imin=" + imin;
            assert (xnew != 3.4028234663852886E38) : "bad xnew";
            double fnew = 3.4028234663852886E38;
            for (int i = 0; i < xs.length; ++i) {
                if (!Almost.FLOAT.equal(xnew, xs[i])) continue;
                fnew = fs[i];
            }
            if (fnew == 3.4028234663852886E38) {
                fnew = this.function(xnew, scalarMin, scalarMax);
            }
            if (imin < 2) {
                xs[3] = xnew;
                fs[3] = fnew;
            } else {
                xs[0] = xnew;
                fs[0] = fnew;
            }
            ++iter;
        }
        assert (xmin >= 0.0 && xmin <= 1.0) : "Impossible xmin=" + xmin;
        double result = scalarMin + xmin * (scalarMax - scalarMin);
        monitor.report(1.0);
        return result;
    }

    private int sort(double[] xs, double[] fs) {
        int i;
        assert (xs.length == 4);
        int[] sortedX = new IndexSorter(xs).getSortedIndices();
        System.arraycopy(xs, 0, this._doubleTemp, 0, 4);
        for (i = 0; i < xs.length; ++i) {
            xs[i] = this._doubleTemp[sortedX[i]];
        }
        System.arraycopy(fs, 0, this._doubleTemp, 0, 4);
        for (i = 0; i < xs.length; ++i) {
            fs[i] = this._doubleTemp[sortedX[i]];
        }
        int imin = 0;
        for (int i2 = 1; i2 < fs.length; ++i2) {
            if (!(fs[i2] < fs[imin])) continue;
            imin = i2;
        }
        return imin;
    }

    private double function(double x, double scalarMin, double scalarMax) {
        return this.function(scalarMin + x * (scalarMax - scalarMin));
    }

    private double function(double scalar) {
        return this._function.function(scalar);
    }

    private static double minParabola(double x1, double f1, double x2, double f2, double x3, double f3) throws BadParabolaException, IllegalArgumentException {
        double b;
        if (!Almost.FLOAT.le(x1, x2) || !Almost.FLOAT.le(x2, x3)) {
            throw new BadParabolaException("Violates x1 <= x2 <= x3: x1=" + x1 + " x2=" + x2 + " x3=" + x3);
        }
        if (Almost.FLOAT.equal(x1, x2)) {
            double result = x2 + 0.1 * (x3 - x2);
            return result;
        }
        if (Almost.FLOAT.equal(x2, x3)) {
            double result = x1 + 0.9 * (x2 - x1);
            return result;
        }
        if (!Almost.FLOAT.le(f2, f1) || !Almost.FLOAT.le(f2, f3)) {
            throw new BadParabolaException("Violates f(x2) <= f(x1), f(x2) <= f(x3): f1=" + f1 + " f2=" + f2 + " f3=" + f3);
        }
        double xm = Almost.FLOAT.divide(x2 - x1, x3 - x1, 0.0);
        if (xm < 0.001 || xm > 0.999) {
            throw new BadParabolaException("Parabola is badly sampled x1=" + x1 + " x2=" + x2 + " x3=" + x3);
        }
        double a = Almost.FLOAT.divide((f3 - f1) * xm - (f2 - f1), xm - xm * xm, 0.0);
        if (Almost.FLOAT.ge(a * (b = f3 - f1 - a), 0.0) || 0.5 * Math.abs(b) > Math.abs(a)) {
            throw new BadParabolaException("Poor numerical conditioning a=" + a + " b=" + b);
        }
        xm = Almost.FLOAT.divide(-0.5 * b, a, -1.0);
        if (xm < 0.0 || xm > 1.0) {
            throw new BadParabolaException("Poor numerical conditioning a=" + a + " b=" + b + " xm=" + xm);
        }
        return xm * (x3 - x1) + x1;
    }

    private class IndexSorter {
        private double[] _values = null;
        private int _length = 0;

        private IndexSorter(double[] values) {
            this._values = values;
            this._length = values.length;
        }

        public int[] getSortedIndices() {
            Object[] c = new MyComparable[this._length];
            for (int i = 0; i < c.length; ++i) {
                c[i] = new MyComparable(i);
            }
            Arrays.sort(c);
            int[] result = new int[c.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ((MyComparable)c[i]).index;
            }
            return result;
        }

        private class MyComparable
        implements Comparable<MyComparable> {
            private int index = 0;

            private MyComparable(int index) {
                this.index = index;
            }

            @Override
            public int compareTo(MyComparable o) {
                return s_almost.cmp(IndexSorter.this._values[this.index], IndexSorter.this._values[o.index]);
            }
        }
    }

    private static class BadParabolaException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private BadParabolaException(String message) {
            super(message);
        }
    }

    public static interface Function {
        public double function(double var1);
    }
}

